/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.mpp.apple.swiftexport;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.work.DisableCachingByDefault;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.utils.StringUtilsKt;
import org.jetbrains.kotlin.incremental.FileUtilsKt;

@DisableCachingByDefault(because="Swift Export is experimental, so no caching for now")
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0019\n\u0002\u0010\u0002\n\u0002\b\u0007\b!\u0018\u0000 92\u00020\u0001:\u00019B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u00102\u001a\u000203H\u0002J\b\u00104\u001a\u000203H\u0002J\b\u00105\u001a\u000203H\u0002J\b\u00106\u001a\u000203H\u0002J\b\u00107\u001a\u000203H\u0007J\b\u00108\u001a\u000203H\u0002R\u0011\u0010\u0003\u001a\u00020\u00048G\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001c\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\r8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0006R\u0014\u0010\u0012\u001a\u00020\u00138gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\b0\r8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u000fR\u0014\u0010\u0018\u001a\u00020\u00198gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u00048G\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0006R\u0014\u0010\u001e\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0006R\u0014\u0010 \u001a\u00020\u00138gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0015R\u0014\u0010\"\u001a\u00020\u00198gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u001bR\u0014\u0010$\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u0006R\u0014\u0010&\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u0006R\u001c\u0010(\u001a\n \t*\u0004\u0018\u00010\b0\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u000bR\u001a\u0010*\u001a\b\u0012\u0004\u0012\u00020\b0\r8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010\u000fR\u0014\u0010,\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010\u0006R\u0014\u0010.\u001a\u00020\u00138gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u0010\u0015R\u001a\u00100\u001a\b\u0012\u0004\u0012\u00020\b0\r8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u0010\u000f\u00a8\u0006:"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/mpp/apple/swiftexport/GenerateSPMPackageFromSwiftExport;", "Lorg/gradle/api/DefaultTask;", "()V", "headerBridgeIncludePath", "Ljava/io/File;", "getHeaderBridgeIncludePath", "()Ljava/io/File;", "headerBridgeModule", "", "kotlin.jvm.PlatformType", "getHeaderBridgeModule", "()Ljava/lang/String;", "headerBridgeModuleName", "Lorg/gradle/api/provider/Property;", "getHeaderBridgeModuleName", "()Lorg/gradle/api/provider/Property;", "headerBridgeModulePath", "getHeaderBridgeModulePath", "headerBridgePath", "Lorg/gradle/api/file/RegularFileProperty;", "getHeaderBridgePath", "()Lorg/gradle/api/file/RegularFileProperty;", "kotlinLibraryName", "getKotlinLibraryName", "kotlinRuntime", "Lorg/gradle/api/file/DirectoryProperty;", "getKotlinRuntime", "()Lorg/gradle/api/file/DirectoryProperty;", "kotlinRuntimeIncludePath", "getKotlinRuntimeIncludePath", "kotlinRuntimeModulePath", "getKotlinRuntimeModulePath", "libraryPath", "getLibraryPath", "packagePath", "getPackagePath", "sourcesPath", "getSourcesPath", "spmPackageRootPath", "getSpmPackageRootPath", "swiftApiModule", "getSwiftApiModule", "swiftApiModuleName", "getSwiftApiModuleName", "swiftApiModulePath", "getSwiftApiModulePath", "swiftApiPath", "getSwiftApiPath", "swiftLibraryName", "getSwiftLibraryName", "createHeaderTarget", "", "createKotlinRuntimeTarget", "createPackageManifest", "createSwiftTarget", "generate", "preparePackageDirectory", "Companion", "kotlin-gradle-plugin_common"})
@SourceDebugExtension(value={"SMAP\nGenerateSPMPackageFromSwiftExport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GenerateSPMPackageFromSwiftExport.kt\norg/jetbrains/kotlin/gradle/plugin/mpp/apple/swiftexport/GenerateSPMPackageFromSwiftExport\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,156:1\n1863#2,2:157\n*S KotlinDebug\n*F\n+ 1 GenerateSPMPackageFromSwiftExport.kt\norg/jetbrains/kotlin/gradle/plugin/mpp/apple/swiftexport/GenerateSPMPackageFromSwiftExport\n*L\n108#1:157,2\n*E\n"})
public abstract class GenerateSPMPackageFromSwiftExport
extends DefaultTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String KOTLIN_RUNTIME = "KotlinRuntime";

    @Input
    @NotNull
    public abstract Property<String> getSwiftApiModuleName();

    @Input
    @NotNull
    public abstract Property<String> getHeaderBridgeModuleName();

    @Input
    @NotNull
    public abstract Property<String> getSwiftLibraryName();

    @Input
    @NotNull
    public abstract Property<String> getKotlinLibraryName();

    @InputDirectory
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public abstract DirectoryProperty getKotlinRuntime();

    @InputFile
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public abstract RegularFileProperty getSwiftApiPath();

    @InputFile
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public abstract RegularFileProperty getHeaderBridgePath();

    @InputFile
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public abstract RegularFileProperty getLibraryPath();

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getPackagePath();

    @Internal
    @NotNull
    public final File getHeaderBridgeIncludePath() {
        return FilesKt.resolve((File)this.getHeaderBridgeModulePath(), (String)"include");
    }

    @Internal
    @NotNull
    public final File getKotlinRuntimeIncludePath() {
        return FilesKt.resolve((File)this.getKotlinRuntimeModulePath(), (String)"include");
    }

    private final String getSwiftApiModule() {
        return (String)this.getSwiftApiModuleName().get();
    }

    private final String getHeaderBridgeModule() {
        return (String)this.getHeaderBridgeModuleName().get();
    }

    private final File getSpmPackageRootPath() {
        return org.jetbrains.kotlin.gradle.utils.FileUtilsKt.getDirectoryAsFile((Provider<Directory>)((Provider)this.getPackagePath()));
    }

    private final File getSourcesPath() {
        return FilesKt.resolve((File)this.getSpmPackageRootPath(), (String)"Sources");
    }

    private final File getSwiftApiModulePath() {
        File file = this.getSourcesPath();
        String string = this.getSwiftApiModule();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"swiftApiModule");
        return FilesKt.resolve((File)file, (String)string);
    }

    private final File getHeaderBridgeModulePath() {
        File file = this.getSourcesPath();
        String string = this.getHeaderBridgeModule();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"headerBridgeModule");
        return FilesKt.resolve((File)file, (String)string);
    }

    private final File getKotlinRuntimeModulePath() {
        return FilesKt.resolve((File)this.getSourcesPath(), (String)KOTLIN_RUNTIME);
    }

    @TaskAction
    public final void generate() {
        this.preparePackageDirectory();
        this.createHeaderTarget();
        this.createSwiftTarget();
        this.createPackageManifest();
        this.createKotlinRuntimeTarget();
    }

    private final void preparePackageDirectory() {
        if (this.getSpmPackageRootPath().exists()) {
            FileUtilsKt.deleteRecursivelyOrThrow((File)this.getSpmPackageRootPath());
        }
        FileUtilsKt.createDirectory((File)this.getSwiftApiModulePath());
        FileUtilsKt.createDirectory((File)this.getHeaderBridgeIncludePath());
        FileUtilsKt.createDirectory((File)this.getKotlinRuntimeIncludePath());
    }

    private final void createHeaderTarget() {
        FilesKt.copyTo$default((File)org.jetbrains.kotlin.gradle.utils.FileUtilsKt.getFile((Provider<RegularFile>)((Provider)this.getHeaderBridgePath())), (File)FilesKt.resolve((File)this.getHeaderBridgeIncludePath(), (String)"Kotlin.h"), (boolean)false, (int)0, (int)6, null);
        FilesKt.writeText$default((File)FilesKt.resolve((File)this.getHeaderBridgeIncludePath(), (String)"module.modulemap"), (String)StringsKt.trimIndent((String)("\n            module " + this.getHeaderBridgeModule() + " {\n                umbrella \".\"\n                export *\n                \n                link \"" + (String)this.getSwiftLibraryName().get() + "\"\n                link \"" + (String)this.getKotlinLibraryName().get() + "\"\n            }\n            ")), null, (int)2, null);
        FilesKt.writeText$default((File)FilesKt.resolve((File)this.getHeaderBridgeModulePath(), (String)"linkingStub.c"), (String)"\n", null, (int)2, null);
    }

    private final void createKotlinRuntimeTarget() {
        FileTree fileTree = this.getKotlinRuntime().getAsFileTree();
        Intrinsics.checkNotNullExpressionValue((Object)fileTree, (String)"kotlinRuntime.asFileTree");
        Iterable $this$forEach$iv = (Iterable)fileTree;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            File file = this.getKotlinRuntimeIncludePath();
            String string = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
            FilesKt.copyTo$default((File)it, (File)FilesKt.resolve((File)file, (String)string), (boolean)false, (int)0, (int)6, null);
        }
        FilesKt.writeText$default((File)FilesKt.resolve((File)this.getKotlinRuntimeModulePath(), (String)"linkingStub.c"), (String)"\n", null, (int)2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void createSwiftTarget() {
        Object object = FilesKt.resolve((File)this.getSwiftApiModulePath(), (String)"Kotlin.swift");
        Object object2 = Charsets.UTF_8;
        object = new OutputStreamWriter((OutputStream)new FileOutputStream((File)object), (Charset)object2);
        object2 = null;
        try {
            OutputStreamWriter kotlinApi = (OutputStreamWriter)object;
            boolean bl = false;
            File file = ((RegularFile)this.getSwiftApiPath().get()).getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"swiftApiPath.get().asFile");
            File file2 = file;
            Charset charset = Charsets.UTF_8;
            TextStreamsKt.forEachLine((Reader)new InputStreamReader((InputStream)new FileInputStream(file2), charset), (Function1)((Function1)new Function1<String, Unit>(kotlinApi){
                final /* synthetic */ OutputStreamWriter $kotlinApi;
                {
                    this.$kotlinApi = $kotlinApi;
                    super(1);
                }

                public final void invoke(String it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    Writer writer = this.$kotlinApi.append(it);
                    Intrinsics.checkNotNullExpressionValue((Object)writer, (String)"kotlinApi.append(it)");
                    StringUtilsKt.appendLine(writer);
                }
            }));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
    }

    private final void createPackageManifest() {
        File manifest = FilesKt.resolve((File)this.getSpmPackageRootPath(), (String)"Package.swift");
        FilesKt.writeText$default((File)manifest, (String)StringsKt.trimIndent((String)("\n            // swift-tools-version: 5.9\n            \n            import PackageDescription\n            let package = Package(\n                name: \"" + this.getSwiftApiModule() + "\",\n                products: [\n                    .library(\n                        name: \"" + this.getSwiftApiModule() + "Library\",\n                        targets: [\"" + this.getSwiftApiModule() + "\"]\n                    ),\n                ],\n                targets: [\n                    .target(\n                        name: \"" + this.getSwiftApiModule() + "\",\n                        dependencies: [\"" + this.getHeaderBridgeModule() + "\", \"KotlinRuntime\"]\n                    ),\n                    .target(\n                        name: \"" + this.getHeaderBridgeModule() + "\"\n                    ),\n                    .target(\n                        name: \"KotlinRuntime\"\n                    )\n                ]\n            )\n            ")), null, (int)2, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/mpp/apple/swiftexport/GenerateSPMPackageFromSwiftExport$Companion;", "", "()V", "KOTLIN_RUNTIME", "", "kotlin-gradle-plugin_common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

