/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.google.gson.internal.bind;

import java.io.IOException;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import org.jetbrains.kotlin.com.google.gson.Gson;
import org.jetbrains.kotlin.com.google.gson.TypeAdapter;
import org.jetbrains.kotlin.com.google.gson.internal.bind.ReflectiveTypeAdapterFactory;
import org.jetbrains.kotlin.com.google.gson.internal.bind.SerializationDelegatingTypeAdapter;
import org.jetbrains.kotlin.com.google.gson.reflect.TypeToken;
import org.jetbrains.kotlin.com.google.gson.stream.JsonReader;
import org.jetbrains.kotlin.com.google.gson.stream.JsonWriter;

final class TypeAdapterRuntimeTypeWrapper<T>
extends TypeAdapter<T> {
    private final Gson context;
    private final TypeAdapter<T> delegate;
    private final Type type;

    TypeAdapterRuntimeTypeWrapper(Gson context, TypeAdapter<T> delegate2, Type type) {
        this.context = context;
        this.delegate = delegate2;
        this.type = type;
    }

    @Override
    public T read(JsonReader in) throws IOException {
        return this.delegate.read(in);
    }

    @Override
    public void write(JsonWriter out, T value2) throws IOException {
        TypeAdapter<Object> chosen = this.delegate;
        Type runtimeType = TypeAdapterRuntimeTypeWrapper.getRuntimeTypeIfMoreSpecific(this.type, value2);
        if (runtimeType != this.type) {
            TypeAdapter<?> runtimeTypeAdapter = this.context.getAdapter(TypeToken.get(runtimeType));
            chosen = !(runtimeTypeAdapter instanceof ReflectiveTypeAdapterFactory.Adapter) ? runtimeTypeAdapter : (!TypeAdapterRuntimeTypeWrapper.isReflective(this.delegate) ? this.delegate : runtimeTypeAdapter);
        }
        chosen.write(out, value2);
    }

    private static boolean isReflective(TypeAdapter<?> typeAdapter) {
        TypeAdapter delegate2;
        while (typeAdapter instanceof SerializationDelegatingTypeAdapter && (delegate2 = ((SerializationDelegatingTypeAdapter)typeAdapter).getSerializationDelegate()) != typeAdapter) {
            typeAdapter = delegate2;
        }
        return typeAdapter instanceof ReflectiveTypeAdapterFactory.Adapter;
    }

    private static Type getRuntimeTypeIfMoreSpecific(Type type, Object value2) {
        if (value2 != null && (type instanceof Class || type instanceof TypeVariable)) {
            type = value2.getClass();
        }
        return type;
    }
}

