/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.util;

import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.openapi.util.RecursionGuard;
import org.jetbrains.kotlin.com.intellij.openapi.util.RecursionManager;
import org.jetbrains.kotlin.com.intellij.openapi.util.UserDataHolder;
import org.jetbrains.kotlin.com.intellij.util.NullableFunction;
import org.jetbrains.kotlin.com.intellij.util.ObjectUtils;

public final class NullableLazyKey<T, H extends UserDataHolder>
extends Key<T> {
    private final NullableFunction<? super H, ? extends T> myFunction;

    private NullableLazyKey(@NonNls String name, NullableFunction<? super H, ? extends T> function) {
        super(name);
        this.myFunction = function;
    }

    @Nullable
    public T getValue(H h) {
        Object data = h.getUserData(this);
        if (data == null) {
            RecursionGuard.StackStamp stamp = RecursionManager.markStack();
            data = this.myFunction.fun(h);
            if (stamp.mayCacheNow()) {
                h.putUserData(this, (Object)(data == null ? ObjectUtils.NULL : data));
            }
        }
        return data == ObjectUtils.NULL ? null : (T)data;
    }

    public static <T, H extends UserDataHolder> NullableLazyKey<T, H> create(@NonNls String name, NullableFunction<? super H, ? extends T> function) {
        return new NullableLazyKey<T, H>(name, function);
    }
}

