/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.kotlin.com.intellij.util.concurrency.AppExecutorUtil;

public abstract class WaitFor {
    private static final int DEFAULT_STEP = 10;
    private static final int MAX_TIMEOUT = 60000;
    private long myWaitTime;
    private boolean myInterrupted;
    private volatile boolean myConditionRealized;
    private Future<?> myThread;

    public WaitFor() {
        this(60000);
    }

    public WaitFor(int timeoutMsecs) {
        this(timeoutMsecs, 10);
    }

    public WaitFor(int timeoutMsecs, int step) {
        long started2 = System.currentTimeMillis();
        long deadline = timeoutMsecs == -1 ? Long.MAX_VALUE : started2 + (long)timeoutMsecs;
        this.myConditionRealized = false;
        try {
            while (!(this.myConditionRealized = this.condition()) && System.currentTimeMillis() < deadline) {
                Thread.sleep(step);
            }
        }
        catch (InterruptedException e) {
            this.myInterrupted = true;
        }
        this.myWaitTime = System.currentTimeMillis() - started2;
    }

    public WaitFor(int timeoutMsecs, Runnable toRunOnTrue) {
        this.myThread = AppExecutorUtil.getAppExecutorService().submit(() -> {
            this.myConditionRealized = new WaitFor(timeoutMsecs){

                @Override
                protected boolean condition() {
                    return WaitFor.this.condition();
                }
            }.isConditionRealized();
            if (this.myConditionRealized) {
                toRunOnTrue.run();
            }
        });
    }

    public long getWaitedTime() {
        return this.myWaitTime;
    }

    public boolean isConditionRealized() {
        return this.myConditionRealized;
    }

    public boolean isInterrupted() {
        return this.myInterrupted;
    }

    protected abstract boolean condition();

    public void assertCompleted() {
        this.assertCompleted("");
    }

    public void assertCompleted(String message2) {
        assert (this.condition()) : message2;
    }

    @TestOnly
    public void join() throws InterruptedException, ExecutionException {
        Future<?> thread2 = this.myThread;
        if (thread2 != null) {
            thread2.get();
        }
    }
}

