/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.indexing.containers;

import java.util.Arrays;
import java.util.function.IntPredicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.util.indexing.containers.ChangeBufferingList;
import org.jetbrains.kotlin.com.intellij.util.indexing.containers.IdBitSet;
import org.jetbrains.kotlin.com.intellij.util.indexing.containers.IntIdsIterator;
import org.jetbrains.kotlin.com.intellij.util.indexing.containers.RandomAccessIntContainer;

public final class SortedIdSet
implements Cloneable,
RandomAccessIntContainer {
    private int[] mySet;
    private int mySetLength;
    private int mySize;

    public SortedIdSet(int initialCapacity) {
        assert (initialCapacity < Short.MAX_VALUE);
        this.mySet = new int[initialCapacity];
    }

    public SortedIdSet(int[] array2, int size) {
        this.mySet = array2;
        this.mySetLength = this.mySize = size;
    }

    public boolean isEmpty() {
        return this.mySize == 0;
    }

    @Override
    public int size() {
        return this.mySize;
    }

    @Override
    public boolean add(int value2) {
        boolean lengthIsIncreased;
        assert (value2 > 0);
        int pos = this.mySetLength == 0 || this.mySetLength > 0 && Math.abs(this.mySet[this.mySetLength - 1]) < value2 ? -this.mySetLength - 1 : SortedIdSet.binarySearch(this.mySet, 0, this.mySetLength, value2);
        if (pos >= 0) {
            if (this.mySet[pos] > 0) {
                return false;
            }
            pos = -pos - 1;
        }
        if (this.mySetLength == this.mySet.length) {
            int nextArraySize = this.mySet.length < 1024 ? this.mySet.length << 1 : this.mySet.length + this.mySet.length / 5;
            this.mySet = Arrays.copyOf(this.mySet, nextArraySize);
        }
        boolean bl = lengthIsIncreased = (pos = -pos - 1) == this.mySetLength;
        if (!lengthIsIncreased && Math.abs(this.mySet[pos]) != value2) {
            System.arraycopy(this.mySet, pos, this.mySet, pos + 1, this.mySetLength - pos);
            lengthIsIncreased = true;
        }
        this.mySet[pos] = value2;
        ++this.mySize;
        if (lengthIsIncreased) {
            ++this.mySetLength;
        }
        return true;
    }

    @Override
    public boolean remove(int value2) {
        assert (value2 > 0);
        int pos = SortedIdSet.binarySearch(this.mySet, 0, this.mySetLength, value2);
        if (pos < 0 || this.mySet[pos] < 0) {
            return false;
        }
        this.mySet[pos] = -value2;
        --this.mySize;
        return true;
    }

    @Override
    @NotNull
    public IntIdsIterator intIterator() {
        return new Iterator();
    }

    private static int binarySearch(int[] set, int startOffset, int endOffset, int key) {
        int low = startOffset;
        int high = endOffset - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int midVal = Math.abs(set[mid]);
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public void forEach(IntPredicate procedure) {
        int value2;
        for (int i2 = 0; i2 < this.mySetLength && ((value2 = this.mySet[i2]) <= 0 || procedure.test(value2)); ++i2) {
        }
    }

    @Override
    public boolean contains(int value2) {
        if (value2 <= 0) {
            return false;
        }
        int pos = SortedIdSet.binarySearch(this.mySet, 0, this.mySetLength, value2);
        return pos >= 0 && this.mySet[pos] > 0;
    }

    @Override
    public Object clone() {
        try {
            SortedIdSet set = (SortedIdSet)super.clone();
            set.mySet = (int[])this.mySet.clone();
            return set;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void compact() {
        if (2 * this.mySize < this.mySetLength && this.mySetLength > 5) {
            int positivePosition = -1;
            for (int i2 = 0; i2 < this.mySetLength; ++i2) {
                if (this.mySet[i2] < 0) {
                    while (i2 < this.mySetLength && this.mySet[i2] < 0) {
                        ++i2;
                    }
                    if (i2 == this.mySetLength) break;
                    this.mySet[++positivePosition] = this.mySet[i2];
                    continue;
                }
                if (i2 == ++positivePosition) continue;
                this.mySet[positivePosition] = this.mySet[i2];
            }
            this.mySetLength = (short)(positivePosition + 1);
        }
    }

    @Override
    @NotNull
    public RandomAccessIntContainer ensureContainerCapacity(int count) {
        int newSize = this.mySetLength + count;
        if (newSize < this.mySet.length) {
            SortedIdSet sortedIdSet = this;
            if (sortedIdSet == null) {
                SortedIdSet.$$$reportNull$$$0(0);
            }
            return sortedIdSet;
        }
        if (newSize > 20000) {
            return new IdBitSet(this, count);
        }
        newSize = ChangeBufferingList.calcNextArraySize(this.mySet.length, newSize);
        assert (newSize < Short.MAX_VALUE);
        int[] newSet = new int[newSize];
        System.arraycopy(this.mySet, 0, newSet, 0, this.mySetLength);
        this.mySet = newSet;
        SortedIdSet sortedIdSet = this;
        if (sortedIdSet == null) {
            SortedIdSet.$$$reportNull$$$0(1);
        }
        return sortedIdSet;
    }

    public int findNext(int i2) {
        while (i2 < this.mySetLength) {
            if (this.mySet[i2] > 0) {
                return i2;
            }
            ++i2;
        }
        return -1;
    }

    public int get(int cursor) {
        assert (cursor < this.mySetLength);
        int value2 = this.mySet[cursor];
        assert (value2 > 0);
        return value2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/indexing/containers/SortedIdSet", "ensureContainerCapacity"));
    }

    private final class Iterator
    implements IntIdsIterator {
        private int myCursor;

        Iterator() {
            this.myCursor = SortedIdSet.this.findNext(0);
        }

        @Override
        public boolean hasNext() {
            return this.myCursor != -1;
        }

        @Override
        public int next() {
            int result2 = SortedIdSet.this.get(this.myCursor);
            this.myCursor = SortedIdSet.this.findNext(this.myCursor + 1);
            return result2;
        }

        @Override
        public int size() {
            return SortedIdSet.this.size();
        }

        @Override
        public boolean hasAscendingOrder() {
            return true;
        }

        @Override
        public IntIdsIterator createCopyInInitialState() {
            return new Iterator();
        }
    }
}

