/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.diagnostics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.plugin.diagnostics.ToolingDiagnostic;
import org.jetbrains.kotlin.gradle.plugin.diagnostics.ToolingDiagnosticRenderingOptions;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000N\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0003\u001a \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a&\u0010\f\u001a\u00020\u00052\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a\u0018\u0010\u000f\u001a\u00060\u0010j\u0002`\u0011*\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a\u001e\u0010\u0012\u001a\u00020\u0001*\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\u0013\u001a\u00020\u0014H\u0002\u001a\"\u0010\u0015\u001a\u00020\u0005*\u00060\u0016j\u0002`\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u0014H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000*\f\b\u0000\u0010\u001b\"\u00020\u00102\u00020\u0010\u00a8\u0006\u001c"}, d2={"DIAGNOSTIC_SEPARATOR", "", "DIAGNOSTIC_STACKTRACE_END_SEPARATOR", "DIAGNOSTIC_STACKTRACE_START", "renderReportedDiagnostic", "", "diagnostic", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "logger", "Lorg/gradle/api/logging/Logger;", "renderingOptions", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticRenderingOptions;", "renderReportedDiagnostics", "diagnostics", "", "createAnExceptionForFatalDiagnostic", "Lorg/gradle/api/InvalidUserCodeException;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinDiagnosticsException;", "render", "showStacktrace", "", "renderStacktrace", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "throwable", "", "useParsableFormatting", "KotlinDiagnosticsException", "kotlin-gradle-plugin_common"})
@SourceDebugExtension(value={"SMAP\nrenderReportedDiagnostics.kt\nKotlin\n*S Kotlin\n*F\n+ 1 renderReportedDiagnostics.kt\norg/jetbrains/kotlin/gradle/plugin/diagnostics/RenderReportedDiagnosticsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,93:1\n774#2:94\n865#2,2:95\n1863#2,2:97\n*S KotlinDebug\n*F\n+ 1 renderReportedDiagnostics.kt\norg/jetbrains/kotlin/gradle/plugin/diagnostics/RenderReportedDiagnosticsKt\n*L\n66#1:94\n66#1:95,2\n66#1:97,2\n*E\n"})
public final class RenderReportedDiagnosticsKt {
    @NotNull
    public static final String DIAGNOSTIC_SEPARATOR = "#diagnostic-end";
    @NotNull
    public static final String DIAGNOSTIC_STACKTRACE_START = "Stacktrace:";
    @NotNull
    public static final String DIAGNOSTIC_STACKTRACE_END_SEPARATOR = "#stacktrace-end";

    public static final void renderReportedDiagnostics(@NotNull Collection<ToolingDiagnostic> diagnostics, @NotNull Logger logger, @NotNull ToolingDiagnosticRenderingOptions renderingOptions) {
        Intrinsics.checkNotNullParameter(diagnostics, (String)"diagnostics");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)renderingOptions, (String)"renderingOptions");
        for (ToolingDiagnostic diagnostic : diagnostics) {
            RenderReportedDiagnosticsKt.renderReportedDiagnostic(diagnostic, logger, renderingOptions);
        }
    }

    public static final void renderReportedDiagnostic(@NotNull ToolingDiagnostic diagnostic, @NotNull Logger logger, @NotNull ToolingDiagnosticRenderingOptions renderingOptions) {
        Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)renderingOptions, (String)"renderingOptions");
        switch (WhenMappings.$EnumSwitchMapping$0[diagnostic.getSeverity().ordinal()]) {
            case 1: {
                logger.warn("w: " + RenderReportedDiagnosticsKt.render$default(diagnostic, renderingOptions, false, 2, null) + '\n');
                break;
            }
            case 2: {
                logger.error("e: " + RenderReportedDiagnosticsKt.render$default(diagnostic, renderingOptions, false, 2, null) + '\n');
                break;
            }
            case 3: {
                throw RenderReportedDiagnosticsKt.createAnExceptionForFatalDiagnostic(diagnostic, renderingOptions);
            }
        }
    }

    @NotNull
    public static final InvalidUserCodeException createAnExceptionForFatalDiagnostic(@NotNull ToolingDiagnostic $this$createAnExceptionForFatalDiagnostic, @NotNull ToolingDiagnosticRenderingOptions renderingOptions) {
        Intrinsics.checkNotNullParameter((Object)$this$createAnExceptionForFatalDiagnostic, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)renderingOptions, (String)"renderingOptions");
        String message2 = RenderReportedDiagnosticsKt.render($this$createAnExceptionForFatalDiagnostic, renderingOptions, false);
        if ($this$createAnExceptionForFatalDiagnostic.getThrowable() != null) {
            throw new InvalidUserCodeException(message2, $this$createAnExceptionForFatalDiagnostic.getThrowable());
        }
        throw new InvalidUserCodeException(message2);
    }

    /*
     * WARNING - void declaration
     */
    private static final String render(ToolingDiagnostic $this$render, ToolingDiagnosticRenderingOptions renderingOptions, boolean showStacktrace) {
        StringBuilder stringBuilder;
        StringBuilder $this$render_u24lambda_u244 = stringBuilder = new StringBuilder();
        boolean bl = false;
        ToolingDiagnosticRenderingOptions $this$render_u24lambda_u244_u24lambda_u243 = renderingOptions;
        boolean bl2 = false;
        if (!$this$render_u24lambda_u244_u24lambda_u243.getUseParsableFormat() && $this$render_u24lambda_u244_u24lambda_u243.getShowSeverityEmoji()) {
            switch (WhenMappings.$EnumSwitchMapping$0[$this$render.getSeverity().ordinal()]) {
                case 1: {
                    StringBuilder stringBuilder2 = $this$render_u24lambda_u244.append("\u26a0\ufe0f " + $this$render.getIdentifier().getDisplayName());
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append(...)");
                    break;
                }
                case 2: 
                case 3: {
                    StringBuilder stringBuilder3 = $this$render_u24lambda_u244.append("\u274c " + $this$render.getIdentifier().getDisplayName());
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(...)");
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append(...)");
                }
            }
        }
        if ($this$render_u24lambda_u244_u24lambda_u243.getUseParsableFormat()) {
            StringBuilder stringBuilder4 = $this$render_u24lambda_u244.append($this$render);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append(...)");
        } else {
            StringBuilder stringBuilder5;
            void $this$forEach$iv;
            Iterator $this$filterTo$iv$iv;
            StringBuilder stringBuilder6 = $this$render_u24lambda_u244.append($this$render.getMessage());
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6.append('\n'), (String)"append(...)");
            Iterable $this$filter$iv = $this$render.getSolutions();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            Iterator iterator2 = $this$filterTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv$iv = iterator2.next();
                String it = (String)element$iv$iv;
                boolean bl3 = false;
                boolean bl4 = !StringsKt.isBlank((CharSequence)it);
                if (!bl4) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl5 = false;
                StringBuilder stringBuilder7 = $this$render_u24lambda_u244.append(it);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7, (String)"append(...)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7.append('\n'), (String)"append(...)");
            }
            ToolingDiagnostic.Documentation documentation2 = $this$render.getDocumentation();
            if (documentation2 != null) {
                ToolingDiagnostic.Documentation it = documentation2;
                boolean bl6 = false;
                StringBuilder stringBuilder8 = $this$render_u24lambda_u244.append(it.getAdditionalUrlContext());
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder8, (String)"append(...)");
                StringBuilder stringBuilder9 = stringBuilder8.append('\n');
                stringBuilder5 = stringBuilder9;
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder9, (String)"append(...)");
            } else {
                stringBuilder5 = null;
            }
        }
        if (showStacktrace) {
            RenderReportedDiagnosticsKt.renderStacktrace($this$render_u24lambda_u244, $this$render.getThrowable(), $this$render_u24lambda_u244_u24lambda_u243.getUseParsableFormat());
        }
        if ($this$render_u24lambda_u244_u24lambda_u243.getUseParsableFormat()) {
            StringBuilder stringBuilder10 = $this$render_u24lambda_u244.append(DIAGNOSTIC_SEPARATOR);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder10, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder10.append('\n'), (String)"append(...)");
        }
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    static /* synthetic */ String render$default(ToolingDiagnostic toolingDiagnostic, ToolingDiagnosticRenderingOptions toolingDiagnosticRenderingOptions, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = toolingDiagnosticRenderingOptions.getShowStacktrace();
        }
        return RenderReportedDiagnosticsKt.render(toolingDiagnostic, toolingDiagnosticRenderingOptions, bl);
    }

    private static final void renderStacktrace(StringBuilder $this$renderStacktrace, Throwable throwable, boolean useParsableFormatting) {
        if (throwable == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)$this$renderStacktrace.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder = $this$renderStacktrace.append(DIAGNOSTIC_STACKTRACE_START);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder2 = $this$renderStacktrace.append(StringsKt.prependIndent((String)((Object)StringsKt.trim((CharSequence)ExceptionsKt.stackTraceToString((Throwable)throwable))).toString(), (String)"    "));
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append(...)");
        if (useParsableFormatting) {
            StringBuilder stringBuilder3 = $this$renderStacktrace.append(DIAGNOSTIC_STACKTRACE_END_SEPARATOR);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append(...)");
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ToolingDiagnostic.Severity.values().length];
            try {
                nArray[ToolingDiagnostic.Severity.WARNING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ToolingDiagnostic.Severity.ERROR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ToolingDiagnostic.Severity.FATAL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

