/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.utils.StringUtilsKt;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0005\u001a%\u0010\u0004\u001a\u00020\u00052\u0016\u0010\u0006\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00050\u0007\"\u0004\u0018\u00010\u0005H\u0000\u00a2\u0006\u0002\u0010\b\u001a\u0018\u0010\u0004\u001a\u00020\u00052\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\tH\u0000\u001a\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005H\u0000\u001a%\u0010\f\u001a\u00020\u00052\u0016\u0010\u0006\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00050\u0007\"\u0004\u0018\u00010\u0005H\u0000\u00a2\u0006\u0002\u0010\b\u001a\u0014\u0010\r\u001a\u00060\u000ej\u0002`\u000f*\u00060\u000ej\u0002`\u000fH\u0000\u001a\u001e\u0010\r\u001a\u00060\u000ej\u0002`\u000f*\u00060\u000ej\u0002`\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0000\u001a\f\u0010\u0012\u001a\u00020\u0005*\u00020\u0005H\u0000\u001a\f\u0010\u0013\u001a\u00020\u0005*\u00020\u0005H\u0000\u001a\f\u0010\u0014\u001a\u00020\u0005*\u00020\u0005H\u0000\u001a\f\u0010\u0015\u001a\u00020\u0005*\u00020\u0005H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"ANSI_COLOR_REGEX", "Lkotlin/text/Regex;", "invalidTaskNameCharacters", "upperCaseRegex", "dashSeparatedName", "", "nameParts", "", "([Ljava/lang/String;)Ljava/lang/String;", "", "dashSeparatedToUpperCamelCase", "name", "lowerCamelCaseName", "appendLine", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "value", "", "asValidTaskName", "clearAnsiColor", "decamelize", "removingTrailingNewline", "kotlin-gradle-plugin_common"})
@SourceDebugExtension(value={"SMAP\nstringUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 stringUtils.kt\norg/jetbrains/kotlin/gradle/utils/StringUtilsKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,59:1\n11483#2,9:60\n13409#2:69\n13410#2:72\n11492#2:73\n11483#2,9:76\n13409#2:85\n13410#2:87\n11492#2:88\n1#3:70\n1#3:71\n1#3:86\n37#4,2:74\n389#5,4:89\n*S KotlinDebug\n*F\n+ 1 stringUtils.kt\norg/jetbrains/kotlin/gradle/utils/StringUtilsKt\n*L\n12#1:60,9\n12#1:69\n12#1:72\n12#1:73\n27#1:76,9\n27#1:85\n27#1:87\n27#1:88\n12#1:71\n27#1:86\n24#1:74,2\n59#1:89,4\n*E\n"})
public final class StringUtilsKt {
    @NotNull
    private static final Regex upperCaseRegex = new Regex("([A-Z])");
    @NotNull
    private static final Regex invalidTaskNameCharacters = new Regex("[/\\\\:<>\"?*|]");
    @NotNull
    private static final Regex ANSI_COLOR_REGEX = new Regex("\\x1b\\[[0-9;]*m");

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String lowerCamelCaseName(String ... nameParts) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)nameParts, (String)"nameParts");
        String[] $this$mapNotNull$iv = nameParts;
        boolean $i$f$mapNotNull = false;
        String[] stringArray = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int j = 0; j < n; ++j) {
            Object object;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[j];
            boolean bl = false;
            void it = element$iv$iv;
            boolean bl2 = false;
            if (it != null) {
                void var16_15;
                void p0 = var16_15;
                boolean bl3 = false;
                boolean $i$f$lowerCamelCaseName$lambda$0$stub_for_inlining = false;
                object = ((CharSequence)p0).length() > 0 ? var16_15 : null;
            } else {
                object = null;
            }
            if (object == null) continue;
            Object it$iv$iv = object;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List nonEmptyParts = (List)destination$iv$iv;
        Iterable iterable = CollectionsKt.drop((Iterable)nonEmptyParts, (int)1);
        CharSequence charSequence = "";
        String string2 = (String)CollectionsKt.firstOrNull((List)nonEmptyParts);
        if (string2 == null) {
            string2 = "";
        }
        return CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)charSequence, (CharSequence)string2, null, (int)0, null, (Function1)lowerCamelCaseName.1.INSTANCE, (int)28, null);
    }

    @NotNull
    public static final String dashSeparatedToUpperCamelCase(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String[] stringArray = new String[]{"-"};
        return CollectionsKt.joinToString$default((Iterable)StringsKt.split$default((CharSequence)name, (String[])stringArray, (boolean)false, (int)0, (int)6, null), (CharSequence)"", null, null, (int)0, null, (Function1)dashSeparatedToUpperCamelCase.1.INSTANCE, (int)30, null);
    }

    @NotNull
    public static final String dashSeparatedName(@NotNull Iterable<String> nameParts) {
        Intrinsics.checkNotNullParameter(nameParts, (String)"nameParts");
        Collection $this$toTypedArray$iv = CollectionsKt.toList(nameParts);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        return StringUtilsKt.dashSeparatedName(Arrays.copyOf(stringArray, stringArray.length));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String dashSeparatedName(String ... nameParts) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)nameParts, (String)"nameParts");
        String[] $this$mapNotNull$iv = nameParts;
        boolean $i$f$mapNotNull = false;
        String[] stringArray = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int j = 0; j < n; ++j) {
            Object object;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[j];
            boolean bl = false;
            void it = element$iv$iv;
            boolean bl2 = false;
            if (it != null) {
                void var16_15;
                void p0 = var16_15;
                boolean bl3 = false;
                boolean $i$f$dashSeparatedName$lambda$2$stub_for_inlining$1 = false;
                object = ((CharSequence)p0).length() > 0 ? var16_15 : null;
            } else {
                object = null;
            }
            if (object == null) continue;
            Object it$iv$iv = object;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List nonEmptyParts = (List)destination$iv$iv;
        return CollectionsKt.joinToString$default((Iterable)nonEmptyParts, (CharSequence)"-", null, null, (int)0, null, null, (int)62, null);
    }

    @NotNull
    public static final String decamelize(@NotNull String $this$decamelize) {
        Intrinsics.checkNotNullParameter((Object)$this$decamelize, (String)"<this>");
        CharSequence charSequence = $this$decamelize;
        Regex regex = upperCaseRegex;
        Function1 function1 = decamelize.1.INSTANCE;
        return regex.replace(charSequence, function1);
    }

    @NotNull
    public static final String asValidTaskName(@NotNull String $this$asValidTaskName) {
        Intrinsics.checkNotNullParameter((Object)$this$asValidTaskName, (String)"<this>");
        CharSequence charSequence = $this$asValidTaskName;
        Regex regex = invalidTaskNameCharacters;
        String string2 = "_";
        return regex.replace(charSequence, string2);
    }

    @NotNull
    public static final String clearAnsiColor(@NotNull String $this$clearAnsiColor) {
        Intrinsics.checkNotNullParameter((Object)$this$clearAnsiColor, (String)"<this>");
        CharSequence charSequence = $this$clearAnsiColor;
        Regex regex = ANSI_COLOR_REGEX;
        String string2 = "";
        return regex.replace(charSequence, string2);
    }

    @NotNull
    public static final Appendable appendLine(@NotNull Appendable $this$appendLine, @Nullable Object value2) {
        Intrinsics.checkNotNullParameter((Object)$this$appendLine, (String)"<this>");
        Appendable appendable = $this$appendLine.append(String.valueOf(value2));
        Intrinsics.checkNotNullExpressionValue((Object)appendable, (String)"append(value.toString())");
        return StringUtilsKt.appendLine(appendable);
    }

    @NotNull
    public static final Appendable appendLine(@NotNull Appendable $this$appendLine) {
        Intrinsics.checkNotNullParameter((Object)$this$appendLine, (String)"<this>");
        Appendable appendable = $this$appendLine.append('\n');
        Intrinsics.checkNotNullExpressionValue((Object)appendable, (String)"append('\\n')");
        return appendable;
    }

    @NotNull
    public static final String removingTrailingNewline(@NotNull String $this$removingTrailingNewline) {
        String string2;
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$removingTrailingNewline, (String)"<this>");
            String $this$dropLastWhile$iv = $this$removingTrailingNewline;
            boolean $i$f$dropLastWhile = false;
            for (int index$iv = StringsKt.getLastIndex((CharSequence)$this$dropLastWhile$iv); -1 < index$iv; --index$iv) {
                char it = $this$dropLastWhile$iv.charAt(index$iv);
                boolean bl = false;
                if (it == '\n') continue;
                String string3 = $this$dropLastWhile$iv;
                int n = 0;
                int n2 = index$iv + 1;
                String string4 = string3.substring(n, n2);
                string2 = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                break block1;
            }
            string2 = "";
        }
        return string2;
    }
}

