/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.it.unimi.dsi.fastutil.ints;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleConsumer;
import java.util.function.IntConsumer;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.HashCommon;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.Size64;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.doubles.AbstractDoubleCollection;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.doubles.DoubleCollection;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.doubles.DoubleIterator;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.doubles.DoubleSpliterator;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.doubles.DoubleSpliterators;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.ints.AbstractInt2DoubleFunction;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.ints.AbstractIntSet;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.ints.Int2DoubleMap;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.ints.Int2DoubleMaps;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.ints.IntIterator;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.ints.IntSet;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.ints.IntSpliterator;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.ints.IntSpliterators;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.objects.ObjectIterator;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.objects.ObjectSpliterator;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.objects.ObjectSpliterators;

public abstract class AbstractInt2DoubleMap
extends AbstractInt2DoubleFunction
implements Int2DoubleMap,
Serializable {
    private static final long serialVersionUID = -4940583368468432370L;

    protected AbstractInt2DoubleMap() {
    }

    @Override
    public boolean containsKey(int k) {
        Iterator i2 = this.int2DoubleEntrySet().iterator();
        while (i2.hasNext()) {
            if (((Int2DoubleMap.Entry)i2.next()).getIntKey() != k) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(double v) {
        Iterator i2 = this.int2DoubleEntrySet().iterator();
        while (i2.hasNext()) {
            if (((Int2DoubleMap.Entry)i2.next()).getDoubleValue() != v) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public final double mergeDouble(int key, double value2, org.jetbrains.kotlin.it.unimi.dsi.fastutil.doubles.DoubleBinaryOperator remappingFunction) {
        return this.mergeDouble(key, value2, (DoubleBinaryOperator)remappingFunction);
    }

    @Override
    public IntSet keySet() {
        return new AbstractIntSet(){

            @Override
            public boolean contains(int k) {
                return AbstractInt2DoubleMap.this.containsKey(k);
            }

            @Override
            public int size() {
                return AbstractInt2DoubleMap.this.size();
            }

            @Override
            public void clear() {
                AbstractInt2DoubleMap.this.clear();
            }

            @Override
            public IntIterator iterator() {
                return new IntIterator(){
                    private final ObjectIterator<Int2DoubleMap.Entry> i;
                    {
                        this.i = Int2DoubleMaps.fastIterator(AbstractInt2DoubleMap.this);
                    }

                    @Override
                    public int nextInt() {
                        return ((Int2DoubleMap.Entry)this.i.next()).getIntKey();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    @Override
                    public void remove() {
                        this.i.remove();
                    }

                    @Override
                    public void forEachRemaining(IntConsumer action2) {
                        this.i.forEachRemaining((? super E entry2) -> action2.accept(entry2.getIntKey()));
                    }
                };
            }

            @Override
            public IntSpliterator spliterator() {
                return IntSpliterators.asSpliterator(this.iterator(), Size64.sizeOf(AbstractInt2DoubleMap.this), 321);
            }
        };
    }

    @Override
    public DoubleCollection values() {
        return new AbstractDoubleCollection(){

            @Override
            public boolean contains(double k) {
                return AbstractInt2DoubleMap.this.containsValue(k);
            }

            @Override
            public int size() {
                return AbstractInt2DoubleMap.this.size();
            }

            @Override
            public void clear() {
                AbstractInt2DoubleMap.this.clear();
            }

            @Override
            public DoubleIterator iterator() {
                return new DoubleIterator(){
                    private final ObjectIterator<Int2DoubleMap.Entry> i;
                    {
                        this.i = Int2DoubleMaps.fastIterator(AbstractInt2DoubleMap.this);
                    }

                    @Override
                    public double nextDouble() {
                        return ((Int2DoubleMap.Entry)this.i.next()).getDoubleValue();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    @Override
                    public void remove() {
                        this.i.remove();
                    }

                    @Override
                    public void forEachRemaining(DoubleConsumer action2) {
                        this.i.forEachRemaining((? super E entry2) -> action2.accept(entry2.getDoubleValue()));
                    }
                };
            }

            @Override
            public DoubleSpliterator spliterator() {
                return DoubleSpliterators.asSpliterator(this.iterator(), Size64.sizeOf(AbstractInt2DoubleMap.this), 320);
            }
        };
    }

    @Override
    public void putAll(Map<? extends Integer, ? extends Double> m) {
        if (m instanceof Int2DoubleMap) {
            ObjectIterator<Int2DoubleMap.Entry> i2 = Int2DoubleMaps.fastIterator((Int2DoubleMap)m);
            while (i2.hasNext()) {
                Int2DoubleMap.Entry e = (Int2DoubleMap.Entry)i2.next();
                this.put(e.getIntKey(), e.getDoubleValue());
            }
        } else {
            int n = m.size();
            Iterator<Map.Entry<? extends Integer, ? extends Double>> i3 = m.entrySet().iterator();
            while (n-- != 0) {
                Map.Entry<? extends Integer, ? extends Double> e = i3.next();
                this.put(e.getKey(), e.getValue());
            }
        }
    }

    @Override
    public int hashCode() {
        int h = 0;
        int n = this.size();
        ObjectIterator<Int2DoubleMap.Entry> i2 = Int2DoubleMaps.fastIterator(this);
        while (n-- != 0) {
            h += ((Int2DoubleMap.Entry)i2.next()).hashCode();
        }
        return h;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        if (m.size() != this.size()) {
            return false;
        }
        return this.int2DoubleEntrySet().containsAll(m.entrySet());
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        ObjectIterator<Int2DoubleMap.Entry> i2 = Int2DoubleMaps.fastIterator(this);
        int n = this.size();
        boolean first = true;
        s.append("{");
        while (n-- != 0) {
            if (first) {
                first = false;
            } else {
                s.append(", ");
            }
            Int2DoubleMap.Entry e = (Int2DoubleMap.Entry)i2.next();
            s.append(String.valueOf(e.getIntKey()));
            s.append("=>");
            s.append(String.valueOf(e.getDoubleValue()));
        }
        s.append("}");
        return s.toString();
    }

    public static abstract class BasicEntrySet
    extends AbstractObjectSet<Int2DoubleMap.Entry> {
        protected final Int2DoubleMap map;

        public BasicEntrySet(Int2DoubleMap map) {
            this.map = map;
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            if (o instanceof Int2DoubleMap.Entry) {
                Int2DoubleMap.Entry e = (Int2DoubleMap.Entry)o;
                int k = e.getIntKey();
                return this.map.containsKey(k) && Double.doubleToLongBits(this.map.get(k)) == Double.doubleToLongBits(e.getDoubleValue());
            }
            Map.Entry e = (Map.Entry)o;
            Object key = e.getKey();
            if (key == null || !(key instanceof Integer)) {
                return false;
            }
            int k = (Integer)key;
            Object value2 = e.getValue();
            if (value2 == null || !(value2 instanceof Double)) {
                return false;
            }
            return this.map.containsKey(k) && Double.doubleToLongBits(this.map.get(k)) == Double.doubleToLongBits((Double)value2);
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            if (o instanceof Int2DoubleMap.Entry) {
                Int2DoubleMap.Entry e = (Int2DoubleMap.Entry)o;
                return this.map.remove(e.getIntKey(), e.getDoubleValue());
            }
            Map.Entry e = (Map.Entry)o;
            Object key = e.getKey();
            if (key == null || !(key instanceof Integer)) {
                return false;
            }
            int k = (Integer)key;
            Object value2 = e.getValue();
            if (value2 == null || !(value2 instanceof Double)) {
                return false;
            }
            double v = (Double)value2;
            return this.map.remove(k, v);
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public ObjectSpliterator<Int2DoubleMap.Entry> spliterator() {
            return ObjectSpliterators.asSpliterator(this.iterator(), Size64.sizeOf(this.map), 65);
        }
    }

    public static class BasicEntry
    implements Int2DoubleMap.Entry {
        protected int key;
        protected double value;

        public BasicEntry() {
        }

        public BasicEntry(Integer key, Double value2) {
            this.key = key;
            this.value = value2;
        }

        public BasicEntry(int key, double value2) {
            this.key = key;
            this.value = value2;
        }

        @Override
        public int getIntKey() {
            return this.key;
        }

        @Override
        public double getDoubleValue() {
            return this.value;
        }

        @Override
        public double setValue(double value2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            if (o instanceof Int2DoubleMap.Entry) {
                Int2DoubleMap.Entry e = (Int2DoubleMap.Entry)o;
                return this.key == e.getIntKey() && Double.doubleToLongBits(this.value) == Double.doubleToLongBits(e.getDoubleValue());
            }
            Map.Entry e = (Map.Entry)o;
            Object key = e.getKey();
            if (key == null || !(key instanceof Integer)) {
                return false;
            }
            Object value2 = e.getValue();
            if (value2 == null || !(value2 instanceof Double)) {
                return false;
            }
            return this.key == (Integer)key && Double.doubleToLongBits(this.value) == Double.doubleToLongBits((Double)value2);
        }

        @Override
        public int hashCode() {
            return this.key ^ HashCommon.double2int(this.value);
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

