/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.commons.io.filefilter;

import java.io.File;
import java.io.Serializable;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.stream.Stream;
import org.jetbrains.kotlin.org.apache.commons.io.IOUtils;
import org.jetbrains.kotlin.org.apache.commons.io.filefilter.AbstractFileFilter;
import org.jetbrains.kotlin.org.apache.commons.io.filefilter.IOFileFilter;

public class EmptyFileFilter
extends AbstractFileFilter
implements Serializable {
    public static final IOFileFilter EMPTY = new EmptyFileFilter();
    public static final IOFileFilter NOT_EMPTY = EMPTY.negate();
    private static final long serialVersionUID = 3631422087512832211L;

    protected EmptyFileFilter() {
    }

    @Override
    public boolean accept(File file2) {
        if (file2 == null) {
            return true;
        }
        if (file2.isDirectory()) {
            Object[] files2 = file2.listFiles();
            return IOUtils.length(files2) == 0;
        }
        return file2.length() == 0L;
    }

    @Override
    public FileVisitResult accept(Path file2, BasicFileAttributes attributes2) {
        if (file2 == null) {
            return this.toFileVisitResult(true);
        }
        return this.get(() -> {
            if (Files.isDirectory(file2, new LinkOption[0])) {
                try (Stream<Path> stream = Files.list(file2);){
                    FileVisitResult fileVisitResult = this.toFileVisitResult(!stream.findFirst().isPresent());
                    return fileVisitResult;
                }
            }
            return this.toFileVisitResult(Files.size(file2) == 0L);
        });
    }
}

