/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.internal.types;

import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.internal.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.gradle.internal.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.gradle.internal.descriptors.impl.TypeParameterDescriptorImpl;
import org.jetbrains.kotlin.gradle.internal.types.CustomTypeParameter;
import org.jetbrains.kotlin.gradle.internal.types.DelegatingSimpleType;
import org.jetbrains.kotlin.gradle.internal.types.FlexibleType;
import org.jetbrains.kotlin.gradle.internal.types.FlexibleTypesKt;
import org.jetbrains.kotlin.gradle.internal.types.KotlinType;
import org.jetbrains.kotlin.gradle.internal.types.SimpleType;
import org.jetbrains.kotlin.gradle.internal.types.SpecialTypesKt;
import org.jetbrains.kotlin.gradle.internal.types.StubTypeForBuilderInference;
import org.jetbrains.kotlin.gradle.internal.types.TypeAttributes;
import org.jetbrains.kotlin.gradle.internal.types.TypeRefinement;
import org.jetbrains.kotlin.gradle.internal.types.TypeUtils;
import org.jetbrains.kotlin.gradle.internal.types.UnwrappedType;
import org.jetbrains.kotlin.gradle.internal.types.checker.NewCapturedType;
import org.jetbrains.kotlin.gradle.internal.types.checker.NewTypeVariableConstructor;
import org.jetbrains.kotlin.gradle.internal.types.checker.NullabilityChecker;
import org.jetbrains.kotlin.gradle.internal.types.model.DefinitelyNotNullTypeMarker;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \u001c2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001\u001cB\u0019\b\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0016J\u0010\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0007H\u0016J\n\u0010\u0019\u001a\u00020\u001aH\u0096\u0080\u0004J\u0010\u0010\u001b\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u0005H\u0017R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\u00058TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u0014\u0010\u000e\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000f\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/gradle/internal/types/DefinitelyNotNullType;", "Lorg/jetbrains/kotlin/gradle/internal/types/DelegatingSimpleType;", "Lorg/jetbrains/kotlin/gradle/internal/types/CustomTypeParameter;", "Lorg/jetbrains/kotlin/gradle/internal/types/model/DefinitelyNotNullTypeMarker;", "original", "Lorg/jetbrains/kotlin/gradle/internal/types/SimpleType;", "useCorrectedNullabilityForTypeParameters", "", "<init>", "(Lorg/jetbrains/kotlin/types/SimpleType;Z)V", "getOriginal", "()Lorg/jetbrains/kotlin/types/SimpleType;", "delegate", "getDelegate", "isMarkedNullable", "()Z", "isTypeParameter", "substitutionResult", "Lorg/jetbrains/kotlin/gradle/internal/types/KotlinType;", "replacement", "replaceAttributes", "newAttributes", "Lorg/jetbrains/kotlin/gradle/internal/types/TypeAttributes;", "makeNullableAsSpecified", "newNullability", "toString", "", "replaceDelegate", "Companion", "descriptors"})
public final class DefinitelyNotNullType
extends DelegatingSimpleType
implements CustomTypeParameter,
DefinitelyNotNullTypeMarker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SimpleType original;
    private final boolean useCorrectedNullabilityForTypeParameters;

    private DefinitelyNotNullType(SimpleType original, boolean useCorrectedNullabilityForTypeParameters) {
        this.original = original;
        this.useCorrectedNullabilityForTypeParameters = useCorrectedNullabilityForTypeParameters;
    }

    @NotNull
    public final SimpleType getOriginal() {
        return this.original;
    }

    @Override
    @NotNull
    protected SimpleType getDelegate() {
        return this.original;
    }

    @Override
    public boolean isMarkedNullable() {
        return false;
    }

    @Override
    public boolean isTypeParameter() {
        return this.getDelegate().getConstructor() instanceof NewTypeVariableConstructor || this.getDelegate().getConstructor().getDeclarationDescriptor() instanceof TypeParameterDescriptor;
    }

    @Override
    @NotNull
    public KotlinType substitutionResult(@NotNull KotlinType replacement) {
        Intrinsics.checkNotNullParameter((Object)replacement, (String)"replacement");
        return SpecialTypesKt.makeDefinitelyNotNullOrNotNull(replacement.unwrap(), this.useCorrectedNullabilityForTypeParameters);
    }

    @Override
    @NotNull
    public SimpleType replaceAttributes(@NotNull TypeAttributes newAttributes) {
        Intrinsics.checkNotNullParameter((Object)newAttributes, (String)"newAttributes");
        return new DefinitelyNotNullType(this.getDelegate().replaceAttributes(newAttributes), this.useCorrectedNullabilityForTypeParameters);
    }

    @Override
    @NotNull
    public SimpleType makeNullableAsSpecified(boolean newNullability) {
        return newNullability ? this.getDelegate().makeNullableAsSpecified(newNullability) : (SimpleType)this;
    }

    @Override
    @NotNull
    public String toString() {
        return this.getDelegate() + " & Any";
    }

    @Override
    @TypeRefinement
    @NotNull
    public DefinitelyNotNullType replaceDelegate(@NotNull SimpleType delegate2) {
        Intrinsics.checkNotNullParameter((Object)delegate2, (String)"delegate");
        return new DefinitelyNotNullType(delegate2, this.useCorrectedNullabilityForTypeParameters);
    }

    public /* synthetic */ DefinitelyNotNullType(SimpleType original, boolean useCorrectedNullabilityForTypeParameters, DefaultConstructorMarker $constructor_marker) {
        this(original, useCorrectedNullabilityForTypeParameters);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\tH\u0007J\u0018\u0010\u000b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\tH\u0002J\f\u0010\r\u001a\u00020\t*\u00020\u0007H\u0002\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/gradle/internal/types/DefinitelyNotNullType$Companion;", "", "<init>", "()V", "makeDefinitelyNotNull", "Lorg/jetbrains/kotlin/gradle/internal/types/DefinitelyNotNullType;", "type", "Lorg/jetbrains/kotlin/gradle/internal/types/UnwrappedType;", "useCorrectedNullabilityForTypeParameters", "", "avoidCheckingActualTypeNullability", "makesSenseToBeDefinitelyNotNull", "useCorrectedNullabilityForFlexibleTypeParameters", "canHaveUndefinedNullability", "descriptors"})
    public static final class Companion {
        private Companion() {
        }

        @JvmOverloads
        @Nullable
        public final DefinitelyNotNullType makeDefinitelyNotNull(@NotNull UnwrappedType type, boolean useCorrectedNullabilityForTypeParameters, boolean avoidCheckingActualTypeNullability) {
            DefinitelyNotNullType definitelyNotNullType;
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            if (type instanceof DefinitelyNotNullType) {
                definitelyNotNullType = (DefinitelyNotNullType)type;
            } else if (avoidCheckingActualTypeNullability || this.makesSenseToBeDefinitelyNotNull(type, useCorrectedNullabilityForTypeParameters)) {
                if (type instanceof FlexibleType) {
                    boolean bl = Intrinsics.areEqual((Object)((FlexibleType)type).getLowerBound().getConstructor(), (Object)((FlexibleType)type).getUpperBound().getConstructor());
                    if (_Assertions.ENABLED && !bl) {
                        boolean bl2 = false;
                        String string = "DefinitelyNotNullType for flexible type (" + type + ") can be created only from type variable with the same constructor for bounds";
                        throw new AssertionError((Object)string);
                    }
                }
                definitelyNotNullType = new DefinitelyNotNullType(FlexibleTypesKt.lowerIfFlexible(type).makeNullableAsSpecified(false), useCorrectedNullabilityForTypeParameters, null);
            } else {
                definitelyNotNullType = null;
            }
            return definitelyNotNullType;
        }

        public static /* synthetic */ DefinitelyNotNullType makeDefinitelyNotNull$default(Companion companion, UnwrappedType unwrappedType, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            if ((n & 4) != 0) {
                bl2 = false;
            }
            return companion.makeDefinitelyNotNull(unwrappedType, bl, bl2);
        }

        private final boolean makesSenseToBeDefinitelyNotNull(UnwrappedType type, boolean useCorrectedNullabilityForFlexibleTypeParameters) {
            if (!this.canHaveUndefinedNullability(type)) {
                return false;
            }
            if (type instanceof StubTypeForBuilderInference) {
                return TypeUtils.isNullableType(type);
            }
            ClassifierDescriptor classifierDescriptor = type.getConstructor().getDeclarationDescriptor();
            TypeParameterDescriptorImpl typeParameterDescriptorImpl = classifierDescriptor instanceof TypeParameterDescriptorImpl ? (TypeParameterDescriptorImpl)classifierDescriptor : null;
            boolean bl = typeParameterDescriptorImpl != null ? !typeParameterDescriptorImpl.isInitialized() : false;
            if (bl) {
                return true;
            }
            if (useCorrectedNullabilityForFlexibleTypeParameters && type.getConstructor().getDeclarationDescriptor() instanceof TypeParameterDescriptor) {
                return TypeUtils.isNullableType(type);
            }
            return !NullabilityChecker.INSTANCE.isSubtypeOfAny(type);
        }

        private final boolean canHaveUndefinedNullability(UnwrappedType $this$canHaveUndefinedNullability) {
            return $this$canHaveUndefinedNullability.getConstructor() instanceof NewTypeVariableConstructor || $this$canHaveUndefinedNullability.getConstructor().getDeclarationDescriptor() instanceof TypeParameterDescriptor || $this$canHaveUndefinedNullability instanceof NewCapturedType || $this$canHaveUndefinedNullability instanceof StubTypeForBuilderInference;
        }

        @JvmOverloads
        @Nullable
        public final DefinitelyNotNullType makeDefinitelyNotNull(@NotNull UnwrappedType type, boolean useCorrectedNullabilityForTypeParameters) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            return org.jetbrains.kotlin.gradle.internal.types.DefinitelyNotNullType$Companion.makeDefinitelyNotNull$default(this, type, useCorrectedNullabilityForTypeParameters, false, 4, null);
        }

        @JvmOverloads
        @Nullable
        public final DefinitelyNotNullType makeDefinitelyNotNull(@NotNull UnwrappedType type) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            return org.jetbrains.kotlin.gradle.internal.types.DefinitelyNotNullType$Companion.makeDefinitelyNotNull$default(this, type, false, false, 6, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

