/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPackage;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.load.java.AbstractJavaClassFinder;
import org.jetbrains.kotlin.load.java.JavaClassFinder;
import org.jetbrains.kotlin.load.java.structure.JavaClass;
import org.jetbrains.kotlin.load.java.structure.JavaPackage;
import org.jetbrains.kotlin.load.java.structure.impl.JavaPackageImpl;
import org.jetbrains.kotlin.load.java.structure.impl.source.JavaElementSourceFactory;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.jvm.KotlinJavaPsiFacade;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000f2\u0006\u0010\f\u001a\u00020\rH\u0016J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u001c\u0018\u00010\u001b2\u0006\u0010\u001d\u001a\u00020\u0013H\u0016J\b\u0010\u001e\u001a\u00020\u0015H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/load/java/JavaClassFinderImpl;", "Lorg/jetbrains/kotlin/load/java/AbstractJavaClassFinder;", "<init>", "()V", "javaFacade", "Lorg/jetbrains/kotlin/resolve/jvm/KotlinJavaPsiFacade;", "setProjectInstance", "", "project", "Lcom/intellij/openapi/project/Project;", "findClass", "Lorg/jetbrains/kotlin/load/java/structure/JavaClass;", "request", "Lorg/jetbrains/kotlin/load/java/JavaClassFinder$Request;", "findClasses", "", "findPackage", "Lorg/jetbrains/kotlin/load/java/structure/JavaPackage;", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "mayHaveAnnotations", "", "createJavaPackage", "Lorg/jetbrains/kotlin/load/java/structure/impl/JavaPackageImpl;", "psiPackage", "Lcom/intellij/psi/PsiPackage;", "knownClassNamesInPackage", "", "", "packageFqName", "canComputeKnownClassNamesInPackage", "frontend.java"})
@SourceDebugExtension(value={"SMAP\nJavaClassFinderImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaClassFinderImpl.kt\norg/jetbrains/kotlin/load/java/JavaClassFinderImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,75:1\n1#2:76\n*E\n"})
public final class JavaClassFinderImpl
extends AbstractJavaClassFinder {
    private KotlinJavaPsiFacade javaFacade;

    @Override
    @Inject
    public void setProjectInstance(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super.setProjectInstance(project);
        this.javaFacade = KotlinJavaPsiFacade.getInstance((Project)project);
    }

    @Override
    @Nullable
    public JavaClass findClass(@NotNull JavaClassFinder.Request request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        KotlinJavaPsiFacade kotlinJavaPsiFacade = this.javaFacade;
        if (kotlinJavaPsiFacade == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"javaFacade");
            kotlinJavaPsiFacade = null;
        }
        return kotlinJavaPsiFacade.findClass(request, this.getJavaSearchScope());
    }

    @Override
    @NotNull
    public List<JavaClass> findClasses(@NotNull JavaClassFinder.Request request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        KotlinJavaPsiFacade kotlinJavaPsiFacade = this.javaFacade;
        if (kotlinJavaPsiFacade == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"javaFacade");
            kotlinJavaPsiFacade = null;
        }
        List list = kotlinJavaPsiFacade.findClasses(request, this.getJavaSearchScope());
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"findClasses(...)");
        return list;
    }

    @Override
    @Nullable
    public JavaPackage findPackage(@NotNull FqName fqName, boolean mayHaveAnnotations) {
        JavaPackageImpl javaPackageImpl;
        PsiPackage psiPackage;
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"fqName");
        KotlinJavaPsiFacade kotlinJavaPsiFacade = this.javaFacade;
        if (kotlinJavaPsiFacade == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"javaFacade");
            kotlinJavaPsiFacade = null;
        }
        if ((psiPackage = kotlinJavaPsiFacade.findPackage(fqName.asString(), this.getJavaSearchScope())) != null) {
            PsiPackage it = psiPackage;
            boolean bl = false;
            javaPackageImpl = this.createJavaPackage(it, mayHaveAnnotations);
        } else {
            javaPackageImpl = null;
        }
        return (JavaPackage)javaPackageImpl;
    }

    private final JavaPackageImpl createJavaPackage(PsiPackage psiPackage, boolean mayHaveAnnotations) {
        KotlinJavaPsiFacade kotlinJavaPsiFacade = this.javaFacade;
        if (kotlinJavaPsiFacade == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"javaFacade");
            kotlinJavaPsiFacade = null;
        }
        Project project = kotlinJavaPsiFacade.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        JavaElementSourceFactory sourceFactory = JavaElementSourceFactory.Companion.getInstance(project2);
        return new JavaPackageImpl(sourceFactory.createPsiSource((PsiElement)psiPackage), this.getJavaSearchScope(), mayHaveAnnotations);
    }

    @Override
    @Nullable
    public Set<String> knownClassNamesInPackage(@NotNull FqName packageFqName) {
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        KotlinJavaPsiFacade kotlinJavaPsiFacade = this.javaFacade;
        if (kotlinJavaPsiFacade == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"javaFacade");
            kotlinJavaPsiFacade = null;
        }
        return kotlinJavaPsiFacade.knownClassNamesInPackage(packageFqName, this.getJavaSearchScope());
    }

    @Override
    public boolean canComputeKnownClassNamesInPackage() {
        KotlinJavaPsiFacade kotlinJavaPsiFacade = this.javaFacade;
        if (kotlinJavaPsiFacade == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"javaFacade");
            kotlinJavaPsiFacade = null;
        }
        Boolean bl = kotlinJavaPsiFacade.canComputeKnownClassNamesInPackage();
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"canComputeKnownClassNamesInPackage(...)");
        return bl;
    }
}

