/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jps.build;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.FSOperations;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.fs.CompilationRound;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;
import org.jetbrains.jps.incremental.storage.BuildDataManager;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.kotlin.build.SerializationUtilsKt;
import org.jetbrains.kotlin.incremental.IncrementalCompilationContext;
import org.jetbrains.kotlin.incremental.storage.FileToPathConverter;
import org.jetbrains.kotlin.jps.KotlinJpsBundle;
import org.jetbrains.kotlin.jps.build.HasKotlinMarker;
import org.jetbrains.kotlin.jps.build.JpsFileToPathConverter;
import org.jetbrains.kotlin.jps.build.KotlinBuilder;
import org.jetbrains.kotlin.jps.build.KotlinChunk;
import org.jetbrains.kotlin.jps.build.KotlinCompileContext;
import org.jetbrains.kotlin.jps.build.KotlinDirtySourceFilesHolderKt;
import org.jetbrains.kotlin.jps.build.RebuildAfterCacheVersionChangeMarker;
import org.jetbrains.kotlin.jps.build.TestingBuildLogger;
import org.jetbrains.kotlin.jps.build.TestingContext;
import org.jetbrains.kotlin.jps.build.TestingContextKt;
import org.jetbrains.kotlin.jps.incremental.CacheAttributesDiff;
import org.jetbrains.kotlin.jps.incremental.CacheAttributesManager;
import org.jetbrains.kotlin.jps.incremental.CacheAttributesManagerKt;
import org.jetbrains.kotlin.jps.incremental.CacheStatus;
import org.jetbrains.kotlin.jps.incremental.CompositeLookupsCacheAttributes;
import org.jetbrains.kotlin.jps.incremental.CompositeLookupsCacheAttributesManager;
import org.jetbrains.kotlin.jps.incremental.JpsIncrementalCache;
import org.jetbrains.kotlin.jps.incremental.JpsIncrementalCacheKt;
import org.jetbrains.kotlin.jps.incremental.JpsLookupStorageManager;
import org.jetbrains.kotlin.jps.incremental.KotlinDataContainerTarget;
import org.jetbrains.kotlin.jps.targets.KotlinModuleBuildTarget;
import org.jetbrains.kotlin.jps.targets.KotlinTargetsIndex;
import org.jetbrains.kotlin.jps.targets.KotlinTargetsIndexBuilder;
import org.jetbrains.kotlin.jps.targets.KotlinUnsupportedModuleBuildTarget;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00b6\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010E\u001a\u00020FJ\u000e\u0010G\u001a\u00020F2\u0006\u0010H\u001a\u00020IJ\u0006\u0010J\u001a\u00020FJ\b\u0010K\u001a\u00020FH\u0002J\b\u0010L\u001a\u00020FH\u0002J\u0006\u0010M\u001a\u00020FJ\u0006\u0010N\u001a\u00020FJ\u0010\u0010O\u001a\u0004\u0018\u00010I2\u0006\u0010P\u001a\u00020QJ\u0006\u0010R\u001a\u00020\u001dJ\u000e\u0010S\u001a\b\u0012\u0004\u0012\u00020T0\u001bH\u0002J\u0018\u0010U\u001a\u00020\u001d2\u0006\u0010V\u001a\u00020W2\u0006\u0010X\u001a\u00020\u001dH\u0002J\b\u0010Y\u001a\u00020*H\u0002J\u0010\u0010Z\u001a\u00020F2\u0006\u0010[\u001a\u00020\\H\u0002J\u0010\u0010]\u001a\u00020F2\u0006\u0010H\u001a\u00020IH\u0002J\u0006\u0010^\u001a\u00020FR\u0019\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0019\u0010\n\u001a\n \u0007*\u0004\u0018\u00010\u000b0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0012\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u001c\u001a\u00020\u001d8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001f\u0010 \u001a\u0004\b\u001c\u0010\u001eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010%\u001a\u00020&\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0011\u0010)\u001a\u00020*\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u0011\u0010-\u001a\u00020.\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\u001a\u00101\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u0010\u001e\"\u0004\b3\u00104R\u0011\u00105\u001a\u00020\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u0010\u001eR!\u00107\u001a\u0012\u0012\u0004\u0012\u000209\u0012\b\u0012\u0006\u0012\u0002\b\u00030:088F\u00a2\u0006\u0006\u001a\u0004\b;\u0010<R\u0011\u0010=\u001a\u00020>\u00a2\u0006\b\n\u0000\u001a\u0004\b?\u0010@R\u0013\u0010A\u001a\u0004\u0018\u00010B8F\u00a2\u0006\u0006\u001a\u0004\bC\u0010D\u00a8\u0006_"}, d2={"Lorg/jetbrains/kotlin/jps/build/KotlinCompileContext;", "", "jpsContext", "Lorg/jetbrains/jps/incremental/CompileContext;", "(Lorg/jetbrains/jps/incremental/CompileContext;)V", "dataManager", "Lorg/jetbrains/jps/incremental/storage/BuildDataManager;", "kotlin.jvm.PlatformType", "getDataManager", "()Lorg/jetbrains/jps/incremental/storage/BuildDataManager;", "dataPaths", "Lorg/jetbrains/jps/builders/storage/BuildDataPaths;", "getDataPaths", "()Lorg/jetbrains/jps/builders/storage/BuildDataPaths;", "fileToPathConverter", "Lorg/jetbrains/kotlin/incremental/storage/FileToPathConverter;", "getFileToPathConverter", "()Lorg/jetbrains/kotlin/incremental/storage/FileToPathConverter;", "hasKotlinMarker", "Lorg/jetbrains/kotlin/jps/build/HasKotlinMarker;", "getHasKotlinMarker", "()Lorg/jetbrains/kotlin/jps/build/HasKotlinMarker;", "icContext", "Lorg/jetbrains/kotlin/incremental/IncrementalCompilationContext;", "getIcContext", "()Lorg/jetbrains/kotlin/incremental/IncrementalCompilationContext;", "initialLookupsCacheStateDiff", "Lorg/jetbrains/kotlin/jps/incremental/CacheAttributesDiff;", "isInstrumentationEnabled", "", "()Z", "isInstrumentationEnabled$delegate", "Lkotlin/Lazy;", "getJpsContext", "()Lorg/jetbrains/jps/incremental/CompileContext;", "lookupAttributesSaved", "Ljava/util/concurrent/atomic/AtomicBoolean;", "lookupStorageManager", "Lorg/jetbrains/kotlin/jps/incremental/JpsLookupStorageManager;", "getLookupStorageManager", "()Lorg/jetbrains/kotlin/jps/incremental/JpsLookupStorageManager;", "lookupsCacheAttributesManager", "Lorg/jetbrains/kotlin/jps/incremental/CompositeLookupsCacheAttributesManager;", "getLookupsCacheAttributesManager", "()Lorg/jetbrains/kotlin/jps/incremental/CompositeLookupsCacheAttributesManager;", "rebuildAfterCacheVersionChanged", "Lorg/jetbrains/kotlin/jps/build/RebuildAfterCacheVersionChangeMarker;", "getRebuildAfterCacheVersionChanged", "()Lorg/jetbrains/kotlin/jps/build/RebuildAfterCacheVersionChangeMarker;", "rebuildingAllKotlin", "getRebuildingAllKotlin", "setRebuildingAllKotlin", "(Z)V", "shouldCheckCacheVersions", "getShouldCheckCacheVersions", "targetsBinding", "", "Lorg/jetbrains/jps/incremental/ModuleBuildTarget;", "Lorg/jetbrains/kotlin/jps/targets/KotlinModuleBuildTarget;", "getTargetsBinding", "()Ljava/util/Map;", "targetsIndex", "Lorg/jetbrains/kotlin/jps/targets/KotlinTargetsIndex;", "getTargetsIndex", "()Lorg/jetbrains/kotlin/jps/targets/KotlinTargetsIndex;", "testingLogger", "Lorg/jetbrains/kotlin/jps/build/TestingBuildLogger;", "getTestingLogger", "()Lorg/jetbrains/kotlin/jps/build/TestingBuildLogger;", "checkCacheVersions", "", "checkChunkCacheVersion", "chunk", "Lorg/jetbrains/kotlin/jps/build/KotlinChunk;", "cleanupCaches", "clearAllCaches", "clearLookupCache", "dispose", "ensureLookupsCacheAttributesSaved", "getChunk", "rawChunk", "Lorg/jetbrains/jps/ModuleChunk;", "hasKotlin", "loadLookupsCacheStateDiff", "Lorg/jetbrains/kotlin/jps/incremental/CompositeLookupsCacheAttributes;", "logMarkDirtyForTestingBeforeRound", "file", "Ljava/io/File;", "shouldProcess", "makeLookupsCacheAttributesManager", "markAllKotlinForRebuild", "reason", "", "markChunkForRebuildBeforeBuild", "reportUnsupportedTargets", "jps-plugin"})
@SourceDebugExtension(value={"SMAP\nKotlinCompileContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinCompileContext.kt\norg/jetbrains/kotlin/jps/build/KotlinCompileContext\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,314:1\n1869#2:315\n1869#2,2:316\n1870#2:318\n1761#2,2:319\n1761#2,3:321\n1763#2:324\n1869#2,2:325\n1869#2,2:327\n1869#2:329\n1869#2,2:330\n1870#2:332\n1869#2:333\n1869#2,2:334\n1870#2:336\n1869#2:337\n1870#2:345\n1011#2,2:347\n1563#2:349\n1634#2,3:350\n384#3,7:338\n216#4:346\n217#4:353\n*S KotlinDebug\n*F\n+ 1 KotlinCompileContext.kt\norg/jetbrains/kotlin/jps/build/KotlinCompileContext\n*L\n111#1:315\n112#1:316,2\n111#1:318\n151#1:319,2\n152#1:321,3\n151#1:324\n212#1:325,2\n220#1:327,2\n235#1:329\n236#1:330,2\n235#1:332\n251#1:333\n252#1:334,2\n251#1:336\n282#1:337\n282#1:345\n292#1:347,2\n293#1:349\n293#1:350,3\n286#1:338,7\n291#1:346\n291#1:353\n*E\n"})
public final class KotlinCompileContext {
    @NotNull
    private final CompileContext jpsContext;
    private final BuildDataManager dataManager;
    private final BuildDataPaths dataPaths;
    @NotNull
    private final KotlinTargetsIndex targetsIndex;
    @NotNull
    private final CompositeLookupsCacheAttributesManager lookupsCacheAttributesManager;
    private final boolean shouldCheckCacheVersions;
    @NotNull
    private final HasKotlinMarker hasKotlinMarker;
    @NotNull
    private final Lazy isInstrumentationEnabled$delegate;
    @NotNull
    private final FileToPathConverter fileToPathConverter;
    @NotNull
    private final IncrementalCompilationContext icContext;
    @NotNull
    private final JpsLookupStorageManager lookupStorageManager;
    @NotNull
    private final RebuildAfterCacheVersionChangeMarker rebuildAfterCacheVersionChanged;
    private boolean rebuildingAllKotlin;
    @NotNull
    private final CacheAttributesDiff<?> initialLookupsCacheStateDiff;
    @NotNull
    private final AtomicBoolean lookupAttributesSaved;

    public KotlinCompileContext(@NotNull CompileContext jpsContext) {
        Intrinsics.checkNotNullParameter((Object)jpsContext, (String)"jpsContext");
        this.jpsContext = jpsContext;
        this.dataManager = this.jpsContext.getProjectDescriptor().dataManager;
        this.dataPaths = this.dataManager.getDataPaths();
        this.targetsIndex = new KotlinTargetsIndexBuilder(this).build();
        this.lookupsCacheAttributesManager = this.makeLookupsCacheAttributesManager();
        this.shouldCheckCacheVersions = System.getProperty("kotlin.jps.skip.cache.version.check") == null;
        BuildDataManager buildDataManager = this.dataManager;
        Intrinsics.checkNotNullExpressionValue((Object)buildDataManager, (String)"dataManager");
        this.hasKotlinMarker = new HasKotlinMarker(buildDataManager);
        this.isInstrumentationEnabled$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Boolean>(this){
            final /* synthetic */ KotlinCompileContext this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final Boolean invoke() {
                boolean value2;
                String string = System.getProperty("kotlin.jps.instrument.bytecode");
                boolean bl = value2 = string != null ? Boolean.parseBoolean(string) : false;
                if (value2) {
                    String message = KotlinJpsBundle.message("compiler.text.experimental.bytecode.instrumentation.for.kotlin.classes.is.enabled", new Object[0]);
                    this.this$0.getJpsContext().processMessage((BuildMessage)new CompilerMessage("Kotlin", BuildMessage.Kind.INFO, message));
                }
                return value2;
            }
        }));
        JpsProject jpsProject = this.jpsContext.getProjectDescriptor().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)jpsProject, (String)"jpsContext.projectDescriptor.project");
        this.fileToPathConverter = new JpsFileToPathConverter(jpsProject);
        this.icContext = new IncrementalCompilationContext(this.fileToPathConverter, this.fileToPathConverter, false, null, null, false, null, null, KotlinBuilder.Companion.isKotlinBuilderInDumbMode(), 252, null);
        BuildDataManager buildDataManager2 = this.dataManager;
        Intrinsics.checkNotNullExpressionValue((Object)buildDataManager2, (String)"dataManager");
        this.lookupStorageManager = new JpsLookupStorageManager(buildDataManager2, this.icContext);
        BuildDataManager buildDataManager3 = this.dataManager;
        Intrinsics.checkNotNullExpressionValue((Object)buildDataManager3, (String)"dataManager");
        this.rebuildAfterCacheVersionChanged = new RebuildAfterCacheVersionChangeMarker(buildDataManager3);
        this.initialLookupsCacheStateDiff = this.loadLookupsCacheStateDiff();
        this.lookupAttributesSaved = new AtomicBoolean(false);
    }

    @NotNull
    public final CompileContext getJpsContext() {
        return this.jpsContext;
    }

    public final BuildDataManager getDataManager() {
        return this.dataManager;
    }

    public final BuildDataPaths getDataPaths() {
        return this.dataPaths;
    }

    @Nullable
    public final TestingBuildLogger getTestingLogger() {
        TestingContext testingContext = TestingContextKt.getTestingContext(this.jpsContext);
        return testingContext != null ? testingContext.getBuildLogger() : null;
    }

    @NotNull
    public final KotlinTargetsIndex getTargetsIndex() {
        return this.targetsIndex;
    }

    @NotNull
    public final Map<ModuleBuildTarget, KotlinModuleBuildTarget<?>> getTargetsBinding() {
        return this.targetsIndex.getByJpsTarget();
    }

    @NotNull
    public final CompositeLookupsCacheAttributesManager getLookupsCacheAttributesManager() {
        return this.lookupsCacheAttributesManager;
    }

    public final boolean getShouldCheckCacheVersions() {
        return this.shouldCheckCacheVersions;
    }

    @NotNull
    public final HasKotlinMarker getHasKotlinMarker() {
        return this.hasKotlinMarker;
    }

    public final boolean isInstrumentationEnabled() {
        Lazy lazy = this.isInstrumentationEnabled$delegate;
        return (Boolean)lazy.getValue();
    }

    @NotNull
    public final FileToPathConverter getFileToPathConverter() {
        return this.fileToPathConverter;
    }

    @NotNull
    public final IncrementalCompilationContext getIcContext() {
        return this.icContext;
    }

    @NotNull
    public final JpsLookupStorageManager getLookupStorageManager() {
        return this.lookupStorageManager;
    }

    @NotNull
    public final RebuildAfterCacheVersionChangeMarker getRebuildAfterCacheVersionChanged() {
        return this.rebuildAfterCacheVersionChanged;
    }

    public final boolean getRebuildingAllKotlin() {
        return this.rebuildingAllKotlin;
    }

    public final void setRebuildingAllKotlin(boolean bl) {
        this.rebuildingAllKotlin = bl;
    }

    private final CompositeLookupsCacheAttributesManager makeLookupsCacheAttributesManager() {
        Set expectedLookupsCacheComponents = new LinkedHashSet();
        Iterable $this$forEach$iv = this.targetsIndex.getChunks();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KotlinChunk chunk = (KotlinChunk)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = chunk.getTargets();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                KotlinModuleBuildTarget target = (KotlinModuleBuildTarget)element$iv2;
                boolean bl2 = false;
                if (!target.isIncrementalCompilationEnabled()) continue;
                expectedLookupsCacheComponents.add(target.getGlobalLookupCacheId());
            }
        }
        File file = this.dataPaths.getTargetDataRoot((BuildTarget)KotlinDataContainerTarget.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"dataPaths.getTargetDataR\u2026otlinDataContainerTarget)");
        File lookupsCacheRootPath = file;
        Path path = lookupsCacheRootPath.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"lookupsCacheRootPath.toPath()");
        return new CompositeLookupsCacheAttributesManager(path, expectedLookupsCacheComponents);
    }

    private final CacheAttributesDiff<CompositeLookupsCacheAttributes> loadLookupsCacheStateDiff() {
        CacheAttributesDiff diff = CacheAttributesManagerKt.loadDiff$default(this.lookupsCacheAttributesManager, null, null, 3, null);
        if (diff.getStatus() == CacheStatus.VALID) {
            try {
                this.lookupStorageManager.withLookupStorage(loadLookupsCacheStateDiff.1.INSTANCE);
            }
            catch (Exception e) {
                this.jpsContext.processMessage((BuildMessage)new CompilerMessage("Kotlin", BuildMessage.Kind.WARNING, KotlinJpsBundle.message("compiler.text.incremental.caches.are.corrupted.all.kotlin.code.will.be.rebuilt", new Object[0])));
                KotlinBuilder.Companion.getLOG().info((Throwable)new Error("Lookup storage is corrupted, probe failed: " + e.getMessage(), e));
                this.markAllKotlinForRebuild("Lookup storage is corrupted");
                return CacheAttributesDiff.copy$default(diff, null, null, null, 5, null);
            }
        }
        return diff;
    }

    public final boolean hasKotlin() {
        boolean bl;
        block7: {
            Iterable $this$any$iv = this.targetsIndex.getChunks();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl2;
                    block6: {
                        KotlinChunk chunk = (KotlinChunk)element$iv;
                        boolean bl3 = false;
                        Iterable $this$any$iv2 = chunk.getTargets();
                        boolean $i$f$any2 = false;
                        if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                            bl2 = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv2) {
                                KotlinModuleBuildTarget target = (KotlinModuleBuildTarget)element$iv2;
                                boolean bl4 = false;
                                if (!Intrinsics.areEqual((Object)this.hasKotlinMarker.get(target), (Object)true)) continue;
                                bl2 = true;
                                break block6;
                            }
                            bl2 = false;
                        }
                    }
                    if (!bl2) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final void checkCacheVersions() {
        switch (WhenMappings.$EnumSwitchMapping$0[this.initialLookupsCacheStateDiff.getStatus().ordinal()]) {
            case 1: {
                TestingBuildLogger testingBuildLogger = this.getTestingLogger();
                if (testingBuildLogger != null) {
                    testingBuildLogger.invalidOrUnusedCache(null, null, this.initialLookupsCacheStateDiff);
                }
                if (this.initialLookupsCacheStateDiff.getActual() != null) {
                    this.markAllKotlinForRebuild("Kotlin incremental cache settings or format was changed");
                    this.clearLookupCache();
                    break;
                }
                this.markAllKotlinForRebuild("Kotlin incremental cache is missed or corrupted");
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                Object object = TestingContextKt.getTestingContext(this.jpsContext);
                if (object != null && (object = ((TestingContext)object).getBuildLogger()) != null) {
                    object.invalidOrUnusedCache(null, null, this.initialLookupsCacheStateDiff);
                }
                KotlinBuilder.Companion.getLOG().info("Removing global cache as it is not required anymore: " + this.initialLookupsCacheStateDiff);
                this.clearAllCaches();
                break;
            }
            case 4: {
            }
        }
    }

    public final void ensureLookupsCacheAttributesSaved() {
        if (this.lookupAttributesSaved.compareAndSet(false, true)) {
            CacheAttributesManager.writeVersion$default(this.initialLookupsCacheStateDiff.getManager(), null, 1, null);
        }
    }

    public final void checkChunkCacheVersion(@NotNull KotlinChunk chunk) {
        Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
        if (this.shouldCheckCacheVersions && !this.rebuildingAllKotlin && chunk.shouldRebuild()) {
            this.markChunkForRebuildBeforeBuild(chunk);
        }
    }

    private final boolean logMarkDirtyForTestingBeforeRound(File file, boolean shouldProcess) {
        block1: {
            if (!shouldProcess) break block1;
            TestingBuildLogger testingBuildLogger = this.getTestingLogger();
            if (testingBuildLogger != null) {
                testingBuildLogger.markedAsDirtyBeforeRound(CollectionsKt.listOf((Object)file));
            }
        }
        return shouldProcess;
    }

    private final void markAllKotlinForRebuild(String reason) {
        if (this.rebuildingAllKotlin) {
            return;
        }
        this.rebuildingAllKotlin = true;
        KotlinBuilder.Companion.getLOG().info("Rebuilding all Kotlin: " + reason);
        Iterable $this$forEach$iv = this.targetsIndex.getChunks();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KotlinChunk it = (KotlinChunk)element$iv;
            boolean bl = false;
            this.markChunkForRebuildBeforeBuild(it);
        }
        this.lookupStorageManager.cleanLookupStorage(KotlinBuilder.Companion.getLOG());
    }

    private final void markChunkForRebuildBeforeBuild(KotlinChunk chunk) {
        Iterable $this$forEach$iv = chunk.getTargets();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KotlinModuleBuildTarget it = (KotlinModuleBuildTarget)element$iv;
            boolean bl = false;
            FSOperations.markDirty((CompileContext)this.jpsContext, (CompilationRound)CompilationRound.NEXT, (ModuleBuildTarget)it.getJpsModuleBuildTarget(), arg_0 -> KotlinCompileContext.markChunkForRebuildBeforeBuild$lambda$6$lambda$5(this, arg_0));
            BuildDataManager buildDataManager = this.dataManager;
            Intrinsics.checkNotNullExpressionValue((Object)buildDataManager, (String)"dataManager");
            JpsIncrementalCache jpsIncrementalCache = JpsIncrementalCacheKt.getKotlinCache(buildDataManager, it);
            if (jpsIncrementalCache != null) {
                jpsIncrementalCache.clean();
            }
            this.hasKotlinMarker.clean(it);
            this.rebuildAfterCacheVersionChanged.set(it, true);
        }
    }

    private final void clearAllCaches() {
        this.clearLookupCache();
        KotlinBuilder.Companion.getLOG().info("Clearing caches for all targets");
        Iterable $this$forEach$iv = this.targetsIndex.getChunks();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KotlinChunk chunk = (KotlinChunk)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = chunk.getTargets();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                KotlinModuleBuildTarget it = (KotlinModuleBuildTarget)element$iv2;
                boolean bl2 = false;
                BuildDataManager buildDataManager = this.dataManager;
                Intrinsics.checkNotNullExpressionValue((Object)buildDataManager, (String)"dataManager");
                JpsIncrementalCache jpsIncrementalCache = JpsIncrementalCacheKt.getKotlinCache(buildDataManager, it);
                if (jpsIncrementalCache == null) continue;
                jpsIncrementalCache.clean();
            }
        }
    }

    private final void clearLookupCache() {
        KotlinBuilder.Companion.getLOG().info("Clearing lookup cache");
        this.lookupStorageManager.cleanLookupStorage(KotlinBuilder.Companion.getLOG());
        CacheAttributesManager.writeVersion$default(this.initialLookupsCacheStateDiff.getManager(), null, 1, null);
    }

    public final void cleanupCaches() {
        Iterable $this$forEach$iv = this.targetsIndex.getChunks();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KotlinChunk chunk = (KotlinChunk)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = chunk.getTargets();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                KotlinModuleBuildTarget target = (KotlinModuleBuildTarget)element$iv2;
                boolean bl2 = false;
                if (target.getInitialLocalCacheAttributesDiff().getStatus() != CacheStatus.SHOULD_BE_CLEARED) continue;
                KotlinBuilder.Companion.getLOG().info(target + " caches is cleared as not required anymore: " + target.getInitialLocalCacheAttributesDiff());
                TestingBuildLogger testingBuildLogger = this.getTestingLogger();
                if (testingBuildLogger != null) {
                    testingBuildLogger.invalidOrUnusedCache(null, target, target.getInitialLocalCacheAttributesDiff());
                }
                target.getInitialLocalCacheAttributesDiff().getManager().writeVersion(null);
                BuildDataManager buildDataManager = this.dataManager;
                Intrinsics.checkNotNullExpressionValue((Object)buildDataManager, (String)"dataManager");
                JpsIncrementalCache jpsIncrementalCache = JpsIncrementalCacheKt.getKotlinCache(buildDataManager, target);
                if (jpsIncrementalCache == null) continue;
                jpsIncrementalCache.clean();
            }
        }
    }

    public final void dispose() {
    }

    @Nullable
    public final KotlinChunk getChunk(@NotNull ModuleChunk rawChunk) {
        Intrinsics.checkNotNullParameter((Object)rawChunk, (String)"rawChunk");
        ModuleBuildTarget rawRepresentativeTarget = rawChunk.representativeTarget();
        if (!this.getTargetsBinding().containsKey(rawRepresentativeTarget)) {
            return null;
        }
        KotlinChunk kotlinChunk = this.targetsIndex.getChunksByJpsRepresentativeTarget().get(rawRepresentativeTarget);
        if (kotlinChunk == null) {
            throw new IllegalStateException(("Kotlin binding for chunk " + this + " is not loaded at build start").toString());
        }
        return kotlinChunk;
    }

    /*
     * WARNING - void declaration
     */
    public final void reportUnsupportedTargets() {
        Iterable answer$iv;
        Object element$iv;
        Map byKind = new LinkedHashMap();
        Object $this$forEach$iv = this.targetsIndex.getChunks();
        boolean $i$f$forEach = false;
        Iterator<Object> iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            Object object;
            void $this$getOrPut$iv;
            element$iv = iterator2.next();
            KotlinChunk it = (KotlinChunk)element$iv;
            boolean bl = false;
            KotlinModuleBuildTarget<?> target = it.getRepresentativeTarget();
            if (!(target instanceof KotlinUnsupportedModuleBuildTarget) || !(!target.getSourceFiles().isEmpty())) continue;
            Map map = byKind;
            String key$iv = ((KotlinUnsupportedModuleBuildTarget)target).getKind();
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl2 = false;
                answer$iv = new ArrayList();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            ((List)object).add(target);
        }
        $this$forEach$iv = byKind;
        $i$f$forEach = false;
        iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            String string;
            Object[] objectArray;
            void $this$mapTo$iv$iv;
            List targets;
            Object object = element$iv = (Map.Entry)iterator2.next();
            boolean bl = false;
            String kind = (String)object.getKey();
            List $this$sortBy$iv = targets = (List)object.getValue();
            boolean $i$f$sortBy = false;
            if ($this$sortBy$iv.size() > 1) {
                CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        KotlinUnsupportedModuleBuildTarget it = (KotlinUnsupportedModuleBuildTarget)a;
                        boolean bl = false;
                        Comparable comparable = (Comparable)((Object)it.getModule().getName());
                        it = (KotlinUnsupportedModuleBuildTarget)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getModule().getName())));
                    }
                });
            }
            Iterable $this$map$iv = targets;
            boolean $i$f$map = false;
            answer$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                KotlinUnsupportedModuleBuildTarget kotlinUnsupportedModuleBuildTarget = (KotlinUnsupportedModuleBuildTarget)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                collection.add(it.getChunk().getPresentableShortName());
            }
            List chunkNames = (List)destination$iv$iv;
            String presentableChunksListString = SerializationUtilsKt.joinToReadableString(chunkNames);
            if (kind == null) {
                objectArray = new Object[]{presentableChunksListString};
                string = KotlinJpsBundle.message("compiler.text.0.is.not.yet.supported.in.idea.internal.build.system.please.use.gradle.to.build.them.enable.delegate.ide.build.run.actions.to.gradle.in.settings", objectArray);
            } else {
                objectArray = new Object[]{kind, presentableChunksListString};
                string = KotlinJpsBundle.message("compiler.text.0.is.not.yet.supported.in.idea.internal.build.system.please.use.gradle.to.build.1.enable.delegate.ide.build.run.actions.to.gradle.in.settings", objectArray);
            }
            String msg = string;
            TestingBuildLogger testingBuildLogger = this.getTestingLogger();
            if (testingBuildLogger != null) {
                testingBuildLogger.addCustomMessage(msg);
            }
            this.jpsContext.processMessage((BuildMessage)new CompilerMessage("Kotlin", BuildMessage.Kind.WARNING, msg));
        }
    }

    private static final boolean markChunkForRebuildBeforeBuild$lambda$6$lambda$5(KotlinCompileContext this$0, File file) {
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
        return this$0.logMarkDirtyForTestingBeforeRound(file, KotlinDirtySourceFilesHolderKt.isKotlinSourceFile(file));
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CacheStatus.values().length];
            try {
                nArray[CacheStatus.INVALID.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CacheStatus.VALID.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CacheStatus.SHOULD_BE_CLEARED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CacheStatus.CLEARED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

