/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jps.build;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.storage.BuildDataManager;
import org.jetbrains.jps.model.java.JpsJavaClasspathKind;
import org.jetbrains.jps.model.java.JpsJavaDependencyExtension;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.module.JpsDependencyElement;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleDependency;
import org.jetbrains.kotlin.build.BuildMetaInfo;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.jps.build.JpsUtilKt;
import org.jetbrains.kotlin.jps.build.KotlinBuilder;
import org.jetbrains.kotlin.jps.build.KotlinChunk$Companion$calculateTargetDependencies$;
import org.jetbrains.kotlin.jps.build.KotlinCompileContext;
import org.jetbrains.kotlin.jps.build.TestingBuildLogger;
import org.jetbrains.kotlin.jps.incremental.CacheAttributesManager;
import org.jetbrains.kotlin.jps.incremental.CacheStatus;
import org.jetbrains.kotlin.jps.incremental.JpsIncrementalCache;
import org.jetbrains.kotlin.jps.incremental.JpsIncrementalCacheKt;
import org.jetbrains.kotlin.jps.model.ModuleSettingsKt;
import org.jetbrains.kotlin.jps.targets.KotlinModuleBuildTarget;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0005\u0018\u0000 J2\u00020\u0001:\u0001JB#\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0010\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u00106\u001a\u00020\u000eJ\u000e\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:J\u0006\u0010;\u001a\u00020<J\u0016\u0010=\u001a\u00020<2\u000e\b\u0002\u0010>\u001a\b\u0012\u0004\u0012\u00020\u00000?J \u0010@\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012\u0004\u0012\u00020B0A2\b\b\u0002\u0010C\u001a\u00020\u000eJ\u0016\u0010D\u001a\u00020<2\f\u0010E\u001a\b\u0012\u0004\u0012\u00020B0FH\u0002J\n\u0010I\u001a\u00020\u001eH\u0096\u0080\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001b\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\fR\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00140\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\fR\u0015\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u001e8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0011\u0010!\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0010R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010%\u001a\u00020&8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b)\u0010*\u001a\u0004\b'\u0010(R\u001b\u0010+\u001a\u00020$8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b.\u0010*\u001a\u0004\b,\u0010-R\u001b\u0010/\u001a\u0002008FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b3\u0010*\u001a\u0004\b1\u00102R\u001b\u00104\u001a\u00020\u000e8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b5\u0010*\u001a\u0004\b4\u0010\u0010R\u0011\u0010G\u001a\u00020\u001e8F\u00a2\u0006\u0006\u001a\u0004\bH\u0010 \u00a8\u0006K"}, d2={"Lorg/jetbrains/kotlin/jps/build/KotlinChunk;", "", "context", "Lorg/jetbrains/kotlin/jps/build/KotlinCompileContext;", "targets", "", "Lorg/jetbrains/kotlin/jps/targets/KotlinModuleBuildTarget;", "<init>", "(Lorg/jetbrains/kotlin/jps/build/KotlinCompileContext;Ljava/util/List;)V", "getContext", "()Lorg/jetbrains/kotlin/jps/build/KotlinCompileContext;", "getTargets", "()Ljava/util/List;", "containsTests", "", "getContainsTests", "()Z", "areChunkDependenciesCalculated", "_dependencies", "", "Lorg/jetbrains/kotlin/jps/targets/KotlinModuleBuildTarget$Dependency;", "dependencies", "getDependencies", "_dependents", "dependents", "getDependents", "representativeTarget", "getRepresentativeTarget", "()Lorg/jetbrains/kotlin/jps/targets/KotlinModuleBuildTarget;", "presentableModulesToCompilersList", "", "getPresentableModulesToCompilersList", "()Ljava/lang/String;", "haveSameCompiler", "getHaveSameCompiler", "defaultLanguageVersion", "Lorg/jetbrains/kotlin/config/LanguageVersion;", "compilerArguments", "Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;", "getCompilerArguments", "()Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;", "compilerArguments$delegate", "Lkotlin/Lazy;", "langVersion", "getLangVersion", "()Lorg/jetbrains/kotlin/config/LanguageVersion;", "langVersion$delegate", "apiVersion", "Lorg/jetbrains/kotlin/config/ApiVersion;", "getApiVersion", "()Lorg/jetbrains/kotlin/config/ApiVersion;", "apiVersion$delegate", "isEnabled", "isEnabled$delegate", "shouldRebuild", "compilerArgumentsFile", "Ljava/nio/file/Path;", "target", "Lorg/jetbrains/jps/incremental/ModuleBuildTarget;", "saveVersions", "", "collectDependentChunksRecursivelyExportedOnly", "result", "", "loadCaches", "", "Lorg/jetbrains/kotlin/jps/incremental/JpsIncrementalCache;", "loadDependent", "addDependentCaches", "targetsCaches", "", "presentableShortName", "getPresentableShortName", "toString", "Companion", "jps-plugin"})
@SourceDebugExtension(value={"SMAP\nKotlinChunk.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinChunk.kt\norg/jetbrains/kotlin/jps/build/KotlinChunk\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,238:1\n1807#2,3:239\n1786#2,3:242\n1915#2,2:246\n1915#2,2:248\n1915#2,2:250\n1915#2,2:252\n1915#2:254\n1915#2,2:255\n1916#2:257\n1#3:245\n*S KotlinDebug\n*F\n+ 1 KotlinChunk.kt\norg/jetbrains/kotlin/jps/build/KotlinChunk\n*L\n27#1:239,3\n112#1:242,3\n142#1:246,2\n166#1:248,2\n171#1:250,2\n178#1:252,2\n207#1:254\n208#1:255,2\n207#1:257\n*E\n"})
public final class KotlinChunk {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KotlinCompileContext context;
    @NotNull
    private final List<KotlinModuleBuildTarget<?>> targets;
    private final boolean containsTests;
    private boolean areChunkDependenciesCalculated;
    @NotNull
    private final List<KotlinModuleBuildTarget.Dependency> _dependencies;
    @NotNull
    private final List<KotlinModuleBuildTarget.Dependency> _dependents;
    private final boolean haveSameCompiler;
    @NotNull
    private final LanguageVersion defaultLanguageVersion;
    @NotNull
    private final Lazy compilerArguments$delegate;
    @NotNull
    private final Lazy langVersion$delegate;
    @NotNull
    private final Lazy apiVersion$delegate;
    @NotNull
    private final Lazy isEnabled$delegate;

    /*
     * WARNING - void declaration
     */
    public KotlinChunk(@NotNull KotlinCompileContext context, @NotNull List<? extends KotlinModuleBuildTarget<?>> targets) {
        boolean bl;
        boolean bl2;
        block7: {
            void $this$all$iv;
            KotlinModuleBuildTarget it;
            boolean bl3;
            Iterable $this$any$iv;
            KotlinChunk kotlinChunk;
            block6: {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter(targets, (String)"targets");
                this.context = context;
                this.targets = targets;
                Iterable iterable = this.targets;
                kotlinChunk = this;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl3 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it = (KotlinModuleBuildTarget)element$iv;
                        boolean bl4 = false;
                        if (!it.isTests()) continue;
                        bl3 = true;
                        break block6;
                    }
                    bl3 = false;
                }
            }
            kotlinChunk.containsTests = bl2 = bl3;
            this._dependencies = new ArrayList();
            this._dependents = new ArrayList();
            $this$any$iv = this.targets;
            kotlinChunk = this;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    it = (KotlinModuleBuildTarget)element$iv;
                    boolean bl5 = false;
                    if (Intrinsics.areEqual(it.getClass(), this.getRepresentativeTarget().getClass())) continue;
                    bl = false;
                    break block7;
                }
                bl = true;
            }
        }
        kotlinChunk.haveSameCompiler = bl2 = bl;
        this.defaultLanguageVersion = LanguageVersion.LATEST_STABLE;
        this.compilerArguments$delegate = LazyKt.lazy(() -> KotlinChunk.compilerArguments_delegate$lambda$0(this));
        this.langVersion$delegate = LazyKt.lazy(() -> KotlinChunk.langVersion_delegate$lambda$0(this));
        this.apiVersion$delegate = LazyKt.lazy(() -> KotlinChunk.apiVersion_delegate$lambda$0(this));
        this.isEnabled$delegate = LazyKt.lazy(() -> KotlinChunk.isEnabled_delegate$lambda$0(this));
    }

    @NotNull
    public final KotlinCompileContext getContext() {
        return this.context;
    }

    @NotNull
    public final List<KotlinModuleBuildTarget<?>> getTargets() {
        return this.targets;
    }

    public final boolean getContainsTests() {
        return this.containsTests;
    }

    @NotNull
    public final List<KotlinModuleBuildTarget.Dependency> getDependencies() {
        List<KotlinModuleBuildTarget.Dependency> list;
        List<KotlinModuleBuildTarget.Dependency> it = list = this._dependencies;
        boolean bl = false;
        List<KotlinModuleBuildTarget.Dependency> list2 = this.areChunkDependenciesCalculated ? list : null;
        if (list2 == null) {
            throw new IllegalStateException("Chunk dependencies are not calculated yet".toString());
        }
        return list2;
    }

    @NotNull
    public final List<KotlinModuleBuildTarget.Dependency> getDependents() {
        List<KotlinModuleBuildTarget.Dependency> list;
        List<KotlinModuleBuildTarget.Dependency> it = list = this._dependents;
        boolean bl = false;
        List<KotlinModuleBuildTarget.Dependency> list2 = this.areChunkDependenciesCalculated ? list : null;
        if (list2 == null) {
            throw new IllegalStateException("Chunk dependents are not calculated yet".toString());
        }
        return list2;
    }

    @NotNull
    public final KotlinModuleBuildTarget<?> getRepresentativeTarget() {
        return (KotlinModuleBuildTarget)kotlin.collections.CollectionsKt.first(this.targets);
    }

    @NotNull
    public final String getPresentableModulesToCompilersList() {
        return kotlin.collections.CollectionsKt.joinToString$default((Iterable)this.targets, null, null, null, (int)0, null, KotlinChunk::_get_presentableModulesToCompilersList_$lambda$0, (int)31, null);
    }

    public final boolean getHaveSameCompiler() {
        return this.haveSameCompiler;
    }

    @NotNull
    public final CommonCompilerArguments getCompilerArguments() {
        Lazy lazy = this.compilerArguments$delegate;
        return (CommonCompilerArguments)lazy.getValue();
    }

    @NotNull
    public final LanguageVersion getLangVersion() {
        Lazy lazy = this.langVersion$delegate;
        return (LanguageVersion)lazy.getValue();
    }

    @NotNull
    public final ApiVersion getApiVersion() {
        Lazy lazy = this.apiVersion$delegate;
        return (ApiVersion)lazy.getValue();
    }

    public final boolean isEnabled() {
        Lazy lazy = this.isEnabled$delegate;
        return (Boolean)lazy.getValue();
    }

    public final boolean shouldRebuild() {
        Iterable $this$forEach$iv = this.targets;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KotlinModuleBuildTarget target = (KotlinModuleBuildTarget)element$iv;
            boolean bl = false;
            if (target.isVersionChanged(this, this.getCompilerArguments())) {
                KotlinBuilder.Companion.getLOG().info(target + " version changed, rebuilding " + this);
                return true;
            }
            if (target.getInitialLocalCacheAttributesDiff().getStatus() != CacheStatus.INVALID) continue;
            TestingBuildLogger testingBuildLogger = this.context.getTestingLogger();
            if (testingBuildLogger != null) {
                testingBuildLogger.invalidOrUnusedCache(this, null, target.getInitialLocalCacheAttributesDiff());
            }
            KotlinBuilder.Companion.getLOG().info(target + " cache is invalid " + target.getInitialLocalCacheAttributesDiff() + ", rebuilding " + this);
            return true;
        }
        return false;
    }

    @NotNull
    public final Path compilerArgumentsFile(@NotNull ModuleBuildTarget target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Path path = this.context.getDataPaths().getTargetDataRoot((BuildTarget)target).toPath().resolve(this.getRepresentativeTarget().getCompilerArgumentsFileName());
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void saveVersions() {
        this.context.ensureLookupsCacheAttributesSaved();
        Iterable $this$forEach$iv = this.targets;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KotlinModuleBuildTarget it = (KotlinModuleBuildTarget)element$iv;
            boolean bl = false;
            CacheAttributesManager.writeVersion$default(it.getInitialLocalCacheAttributesDiff().getManager(), null, 1, null);
        }
        String serializedCompilerArguments = ((BuildMetaInfo)this.getRepresentativeTarget().getBuildMetaInfo()).serializeArgsToString(this.getCompilerArguments());
        Iterable $this$forEach$iv2 = this.targets;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            KotlinModuleBuildTarget target = (KotlinModuleBuildTarget)element$iv;
            boolean bl = false;
            OutputStream outputStream = Files.newOutputStream(this.compilerArgumentsFile(target.getJpsModuleBuildTarget()), new OpenOption[0]);
            Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(...)");
            Closeable closeable = outputStream;
            Object object = Charsets.UTF_8;
            Writer writer = new OutputStreamWriter((OutputStream)closeable, (Charset)object);
            int n = 8192;
            closeable = writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer, n);
            object = null;
            try {
                BufferedWriter it = (BufferedWriter)closeable;
                boolean bl2 = false;
                it.append(serializedCompilerArguments);
                writer = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
            }
        }
    }

    public final void collectDependentChunksRecursivelyExportedOnly(@NotNull Set<KotlinChunk> result) {
        Intrinsics.checkNotNullParameter(result, (String)"result");
        Iterable $this$forEach$iv = this.getDependents();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KotlinModuleBuildTarget.Dependency it = (KotlinModuleBuildTarget.Dependency)element$iv;
            boolean bl = false;
            if (!result.add(it.getSrc().getChunk()) || !it.getExported()) continue;
            it.getSrc().getChunk().collectDependentChunksRecursivelyExportedOnly(result);
        }
    }

    public static /* synthetic */ void collectDependentChunksRecursivelyExportedOnly$default(KotlinChunk kotlinChunk, Set set, int n, Object object) {
        if ((n & 1) != 0) {
            set = new LinkedHashSet();
        }
        kotlinChunk.collectDependentChunksRecursivelyExportedOnly(set);
    }

    @NotNull
    public final Map<KotlinModuleBuildTarget<?>, JpsIncrementalCache> loadCaches(boolean loadDependent) {
        BuildDataManager dataManager = this.context.getDataManager();
        Map<KotlinModuleBuildTarget<?>, JpsIncrementalCache> cacheByChunkTarget = CollectionsKt.keysToMapExceptNulls((Iterable)this.targets, arg_0 -> KotlinChunk.loadCaches$lambda$0(dataManager, arg_0));
        if (loadDependent) {
            this.addDependentCaches(cacheByChunkTarget.values());
        }
        return cacheByChunkTarget;
    }

    public static /* synthetic */ Map loadCaches$default(KotlinChunk kotlinChunk, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return kotlinChunk.loadCaches(bl);
    }

    private final void addDependentCaches(Collection<? extends JpsIncrementalCache> targetsCaches) {
        Set dependentChunks = new LinkedHashSet();
        this.collectDependentChunksRecursivelyExportedOnly(dependentChunks);
        BuildDataManager dataManager = this.context.getDataManager();
        Iterable $this$forEach$iv = dependentChunks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KotlinChunk decedentChunk = (KotlinChunk)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = decedentChunk.targets;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                KotlinModuleBuildTarget it = (KotlinModuleBuildTarget)element$iv2;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)dataManager);
                JpsIncrementalCache dependentCache = JpsIncrementalCacheKt.getKotlinCache(dataManager, it);
                if (dependentCache == null) continue;
                for (JpsIncrementalCache jpsIncrementalCache : targetsCaches) {
                    jpsIncrementalCache.addJpsDependentCache(dependentCache);
                }
            }
        }
    }

    @NotNull
    public final String getPresentableShortName() {
        StringBuilder stringBuilder;
        StringBuilder $this$_get_presentableShortName__u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        if (this.containsTests) {
            $this$_get_presentableShortName__u24lambda_u240.append("tests of ");
        }
        $this$_get_presentableShortName__u24lambda_u240.append(((KotlinModuleBuildTarget)kotlin.collections.CollectionsKt.first(this.targets)).getModule().getName());
        if (this.targets.size() > 1) {
            String andXMore = " and " + (this.targets.size() - 1) + " more";
            String other = ", " + SequencesKt.joinToString$default((Sequence)SequencesKt.drop((Sequence)kotlin.collections.CollectionsKt.asSequence((Iterable)this.targets), (int)1), null, null, null, (int)0, null, null, (int)63, null);
            $this$_get_presentableShortName__u24lambda_u240.append(other.length() < andXMore.length() ? other : andXMore);
        }
        return stringBuilder.toString();
    }

    @NotNull
    public String toString() {
        return "KotlinChunk<" + this.getRepresentativeTarget().getClass().getSimpleName() + ">(" + kotlin.collections.CollectionsKt.joinToString$default((Iterable)this.targets, null, null, null, (int)0, null, KotlinChunk::toString$lambda$0, (int)31, null) + ')';
    }

    private static final CharSequence _get_presentableModulesToCompilersList_$lambda$0(KotlinModuleBuildTarget it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getModule().getName() + " (" + it.getGlobalLookupCacheId() + ')';
    }

    private static final CommonCompilerArguments compilerArguments_delegate$lambda$0(KotlinChunk this$0) {
        CommonCompilerArguments commonCompilerArguments;
        JpsModule jpsModule = this$0.getRepresentativeTarget().getJpsModuleBuildTarget().getModule();
        Intrinsics.checkNotNullExpressionValue((Object)jpsModule, (String)"getModule(...)");
        CommonCompilerArguments it = commonCompilerArguments = ModuleSettingsKt.getKotlinCompilerArguments(jpsModule);
        boolean bl = false;
        it.setReportOutputFiles(true);
        it.setVersion(true);
        if (it.getLanguageVersion() == null) {
            it.setLanguageVersion(this$0.defaultLanguageVersion.getVersionString());
        }
        return commonCompilerArguments;
    }

    private static final LanguageVersion langVersion_delegate$lambda$0(KotlinChunk this$0) {
        Object object;
        block3: {
            block2: {
                object = this$0.getCompilerArguments().getLanguageVersion();
                if (object == null) break block2;
                String it = object;
                boolean bl = false;
                LanguageVersion languageVersion = LanguageVersion.Companion.fromVersionString(it);
                object = languageVersion;
                if (languageVersion != null) break block3;
            }
            object = this$0.defaultLanguageVersion;
        }
        return object;
    }

    private static final ApiVersion apiVersion_delegate$lambda$0(KotlinChunk this$0) {
        Object object;
        block3: {
            block2: {
                object = this$0.getCompilerArguments().getApiVersion();
                if (object == null) break block2;
                String it = object;
                boolean bl = false;
                ApiVersion apiVersion = ApiVersion.Companion.parse(it);
                object = apiVersion;
                if (apiVersion != null) break block3;
            }
            object = ApiVersion.Companion.createByLanguageVersion(this$0.getLangVersion());
        }
        return object;
    }

    private static final CommonCompilerArguments isEnabled_delegate$lambda$0$0(KotlinChunk this$0) {
        return this$0.getCompilerArguments();
    }

    private static final boolean isEnabled_delegate$lambda$0(KotlinChunk this$0) {
        return this$0.getRepresentativeTarget().isEnabled((Lazy<CommonCompilerArguments>)LazyKt.lazy(() -> KotlinChunk.isEnabled_delegate$lambda$0$0(this$0)));
    }

    private static final JpsIncrementalCache loadCaches$lambda$0(BuildDataManager $dataManager, KotlinModuleBuildTarget it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Intrinsics.checkNotNull((Object)$dataManager);
        return JpsIncrementalCacheKt.getKotlinCache($dataManager, it);
    }

    private static final CharSequence toString$lambda$0(KotlinModuleBuildTarget it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getJpsModuleBuildTarget().getPresentableName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPresentableName(...)");
        return string;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0016\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u000b\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0\nJ2\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00072\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\f2\u0016\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u000b\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0\nH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/jps/build/KotlinChunk$Companion;", "", "<init>", "()V", "calculateChunkDependencies", "", "chunks", "", "Lorg/jetbrains/kotlin/jps/build/KotlinChunk;", "byJpsModuleBuildTarget", "", "Lorg/jetbrains/jps/incremental/ModuleBuildTarget;", "Lorg/jetbrains/kotlin/jps/targets/KotlinModuleBuildTarget;", "calculateTargetDependencies", "Lorg/jetbrains/kotlin/jps/targets/KotlinModuleBuildTarget$Dependency;", "srcTarget", "jps-plugin"})
    @SourceDebugExtension(value={"SMAP\nKotlinChunk.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinChunk.kt\norg/jetbrains/kotlin/jps/build/KotlinChunk$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,238:1\n1915#2:239\n1916#2:241\n1915#2:242\n1915#2,2:243\n1916#2:245\n1#3:240\n479#4:246\n*S KotlinDebug\n*F\n+ 1 KotlinChunk.kt\norg/jetbrains/kotlin/jps/build/KotlinChunk$Companion\n*L\n58#1:239\n58#1:241\n62#1:242\n70#1:243,2\n62#1:245\n84#1:246\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final void calculateChunkDependencies(@NotNull List<KotlinChunk> chunks, @NotNull Map<ModuleBuildTarget, KotlinModuleBuildTarget<?>> byJpsModuleBuildTarget) {
            KotlinChunk chunk;
            Intrinsics.checkNotNullParameter(chunks, (String)"chunks");
            Intrinsics.checkNotNullParameter(byJpsModuleBuildTarget, (String)"byJpsModuleBuildTarget");
            Iterable $this$forEach$iv = chunks;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                chunk = (KotlinChunk)element$iv;
                boolean bl = false;
                if (!(!chunk.areChunkDependenciesCalculated)) {
                    boolean $i$a$-check-KotlinChunk$Companion$calculateChunkDependencies$1$22 = false;
                    String $i$a$-check-KotlinChunk$Companion$calculateChunkDependencies$1$22 = "Chunk dependencies should be calculated only once";
                    throw new IllegalStateException($i$a$-check-KotlinChunk$Companion$calculateChunkDependencies$1$22.toString());
                }
                chunk.areChunkDependenciesCalculated = true;
            }
            $this$forEach$iv = chunks;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                chunk = (KotlinChunk)element$iv;
                boolean bl = false;
                chunk._dependencies.addAll(SequencesKt.toList((Sequence)SequencesKt.distinct((Sequence)SequencesKt.flatMapIterable((Sequence)kotlin.collections.CollectionsKt.asSequence((Iterable)chunk.getTargets()), arg_0 -> Companion.calculateChunkDependencies$lambda$1$0(byJpsModuleBuildTarget, arg_0)))));
                Iterable $this$forEach$iv2 = chunk._dependencies;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    KotlinModuleBuildTarget.Dependency dependency = (KotlinModuleBuildTarget.Dependency)element$iv2;
                    boolean bl2 = false;
                    dependency.getTarget().getChunk()._dependents.add(dependency);
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private final List<KotlinModuleBuildTarget.Dependency> calculateTargetDependencies(KotlinModuleBuildTarget<?> srcTarget, Map<ModuleBuildTarget, KotlinModuleBuildTarget<?>> byJpsModuleBuildTarget) {
            KotlinModuleBuildTarget<?> srcProductionTarget;
            void $this$filterIsInstance$iv;
            JpsJavaClasspathKind compileClasspathKind = JpsJavaClasspathKind.compile((boolean)srcTarget.isTests());
            JpsJavaExtensionService jpsJavaExtensionService = JpsJavaExtensionService.getInstance();
            List list = srcTarget.getModule().getDependenciesList().getDependencies();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getDependencies(...)");
            Sequence sequence = kotlin.collections.CollectionsKt.asSequence((Iterable)list);
            boolean $i$f$filterIsInstance = false;
            Sequence sequence2 = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)Companion$calculateTargetDependencies$$inlined$filterIsInstance$1.INSTANCE);
            Intrinsics.checkNotNull((Object)sequence2, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
            List dependencies = SequencesKt.toMutableList((Sequence)SequencesKt.mapNotNull((Sequence)sequence2, arg_0 -> Companion.calculateTargetDependencies$lambda$0(jpsJavaExtensionService, compileClasspathKind, byJpsModuleBuildTarget, srcTarget, arg_0)));
            if (srcTarget.isTests() && (srcProductionTarget = byJpsModuleBuildTarget.get(JpsUtilKt.ModuleBuildTarget(srcTarget.getModule(), false))) != null) {
                dependencies.add(new KotlinModuleBuildTarget.Dependency(srcTarget, srcProductionTarget, true));
            }
            return dependencies;
        }

        private static final Iterable calculateChunkDependencies$lambda$1$0(Map $byJpsModuleBuildTarget, KotlinModuleBuildTarget it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Companion.calculateTargetDependencies(it, $byJpsModuleBuildTarget);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static final KotlinModuleBuildTarget.Dependency calculateTargetDependencies$lambda$0(JpsJavaExtensionService $jpsJavaExtensionService, JpsJavaClasspathKind $compileClasspathKind, Map $byJpsModuleBuildTarget, KotlinModuleBuildTarget $srcTarget, JpsModuleDependency dep) {
            JpsJavaDependencyExtension jpsJavaDependencyExtension;
            Intrinsics.checkNotNullParameter((Object)dep, (String)"dep");
            JpsJavaDependencyExtension jpsJavaDependencyExtension2 = $jpsJavaExtensionService.getDependencyExtension((JpsDependencyElement)dep);
            if (jpsJavaDependencyExtension2 == null) return null;
            Object it = jpsJavaDependencyExtension = jpsJavaDependencyExtension2;
            boolean bl = false;
            if (!it.getScope().isIncludedIn($compileClasspathKind)) return null;
            JpsJavaDependencyExtension jpsJavaDependencyExtension3 = jpsJavaDependencyExtension;
            JpsJavaDependencyExtension jpsJavaDependencyExtension4 = jpsJavaDependencyExtension3;
            if (jpsJavaDependencyExtension4 == null) return null;
            JpsJavaDependencyExtension extension = jpsJavaDependencyExtension4;
            jpsJavaDependencyExtension2 = dep.getModule();
            if (jpsJavaDependencyExtension2 == null) return null;
            it = jpsJavaDependencyExtension2;
            boolean bl2 = false;
            KotlinModuleBuildTarget kotlinModuleBuildTarget = (KotlinModuleBuildTarget)$byJpsModuleBuildTarget.get(JpsUtilKt.ModuleBuildTarget((JpsModule)it, $srcTarget.isTests()));
            if (kotlinModuleBuildTarget == null) return null;
            it = kotlinModuleBuildTarget;
            boolean bl3 = false;
            KotlinModuleBuildTarget.Dependency dependency = new KotlinModuleBuildTarget.Dependency($srcTarget, (KotlinModuleBuildTarget<?>)it, extension.isExported());
            return dependency;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

