/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.types.FlexibleType;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.ErrorTypesAreEqualToAnything;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0003\u001a\u00020\u0004*\u00020\u0002\u001a\n\u0010\u0005\u001a\u00020\u0001*\u00020\u0002\u001a\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u0002*\b\u0012\u0004\u0012\u00020\u00020\u0007\u001a\u0012\u0010\u0006\u001a\u0004\u0018\u00010\b*\b\u0012\u0004\u0012\u00020\b0\u0007\u001a\n\u0010\t\u001a\u00020\n*\u00020\u0002\u001a\n\u0010\u000b\u001a\u00020\n*\u00020\u0002\u00a8\u0006\f"}, d2={"isFlexible", "", "Lorg/jetbrains/kotlin/types/KotlinType;", "asFlexibleType", "Lorg/jetbrains/kotlin/types/FlexibleType;", "isNullabilityFlexible", "singleBestRepresentative", "", "Lorg/jetbrains/kotlin/types/TypeProjection;", "lowerIfFlexible", "Lorg/jetbrains/kotlin/types/SimpleType;", "upperIfFlexible", "descriptors"})
@SourceDebugExtension(value={"SMAP\nflexibleTypes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 flexibleTypes.kt\norg/jetbrains/kotlin/types/FlexibleTypesKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,174:1\n296#2:175\n1786#2,3:176\n297#2:179\n1586#2:180\n1661#2,3:181\n1586#2:184\n1661#2,3:185\n*S KotlinDebug\n*F\n+ 1 flexibleTypes.kt\norg/jetbrains/kotlin/types/FlexibleTypesKt\n*L\n50#1:175\n51#1:176,3\n50#1:179\n62#1:180\n62#1:181,3\n65#1:184\n65#1:185,3\n*E\n"})
public final class FlexibleTypesKt {
    public static final boolean isFlexible(@NotNull KotlinType $this$isFlexible) {
        Intrinsics.checkNotNullParameter((Object)$this$isFlexible, (String)"<this>");
        return $this$isFlexible.unwrap() instanceof FlexibleType;
    }

    @NotNull
    public static final FlexibleType asFlexibleType(@NotNull KotlinType $this$asFlexibleType) {
        Intrinsics.checkNotNullParameter((Object)$this$asFlexibleType, (String)"<this>");
        UnwrappedType unwrappedType = $this$asFlexibleType.unwrap();
        Intrinsics.checkNotNull((Object)unwrappedType, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.types.FlexibleType");
        return (FlexibleType)unwrappedType;
    }

    public static final boolean isNullabilityFlexible(@NotNull KotlinType $this$isNullabilityFlexible) {
        Intrinsics.checkNotNullParameter((Object)$this$isNullabilityFlexible, (String)"<this>");
        UnwrappedType unwrappedType = $this$isNullabilityFlexible.unwrap();
        FlexibleType flexibleType = unwrappedType instanceof FlexibleType ? (FlexibleType)unwrappedType : null;
        if (flexibleType == null) {
            return false;
        }
        FlexibleType flexibility = flexibleType;
        return flexibility.getLowerBound().isMarkedNullable() != flexibility.getUpperBound().isMarkedNullable();
    }

    @Nullable
    public static final KotlinType singleBestRepresentative(@NotNull Collection<? extends KotlinType> $this$singleBestRepresentative) {
        Object v1;
        block6: {
            Intrinsics.checkNotNullParameter($this$singleBestRepresentative, (String)"<this>");
            if ($this$singleBestRepresentative.size() == 1) {
                return (KotlinType)CollectionsKt.first((Iterable)$this$singleBestRepresentative);
            }
            Iterable $this$firstOrNull$iv = $this$singleBestRepresentative;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                boolean bl;
                block5: {
                    KotlinType candidate = (KotlinType)element$iv;
                    boolean bl2 = false;
                    Iterable $this$all$iv = $this$singleBestRepresentative;
                    boolean $i$f$all = false;
                    if (((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv2 : $this$all$iv) {
                            KotlinType other = (KotlinType)element$iv2;
                            boolean bl3 = false;
                            if (Intrinsics.areEqual((Object)candidate, (Object)other) || ErrorTypesAreEqualToAnything.INSTANCE.equalTypes(candidate, other)) continue;
                            bl = false;
                            break block5;
                        }
                        bl = true;
                    }
                }
                if (!bl) continue;
                v1 = element$iv;
                break block6;
            }
            v1 = null;
        }
        return v1;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final TypeProjection singleBestRepresentative(@NotNull Collection<? extends TypeProjection> $this$singleBestRepresentative) {
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter($this$singleBestRepresentative, (String)"<this>");
        if ($this$singleBestRepresentative.size() == 1) {
            return (TypeProjection)CollectionsKt.first((Iterable)$this$singleBestRepresentative);
        }
        Iterable $this$map$iv = $this$singleBestRepresentative;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            TypeProjection typeProjection = (TypeProjection)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getProjectionKind());
        }
        Set projectionKinds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        if (projectionKinds.size() != 1) {
            return null;
        }
        Iterable $this$map$iv2 = $this$singleBestRepresentative;
        boolean $i$f$map2 = false;
        Iterable $i$f$mapTo22 = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TypeProjection typeProjection = (TypeProjection)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(it.getType());
        }
        KotlinType kotlinType = FlexibleTypesKt.singleBestRepresentative((List)destination$iv$iv2);
        if (kotlinType == null) {
            return null;
        }
        KotlinType bestType = kotlinType;
        return new TypeProjectionImpl((Variance)((Object)CollectionsKt.single((Iterable)projectionKinds)), bestType);
    }

    @NotNull
    public static final SimpleType lowerIfFlexible(@NotNull KotlinType $this$lowerIfFlexible) {
        SimpleType simpleType;
        Intrinsics.checkNotNullParameter((Object)$this$lowerIfFlexible, (String)"<this>");
        UnwrappedType $this$lowerIfFlexible_u24lambda_u240 = $this$lowerIfFlexible.unwrap();
        boolean bl = false;
        UnwrappedType unwrappedType = $this$lowerIfFlexible_u24lambda_u240;
        if (unwrappedType instanceof FlexibleType) {
            simpleType = ((FlexibleType)$this$lowerIfFlexible_u24lambda_u240).getLowerBound();
        } else if (unwrappedType instanceof SimpleType) {
            simpleType = (SimpleType)$this$lowerIfFlexible_u24lambda_u240;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return simpleType;
    }

    @NotNull
    public static final SimpleType upperIfFlexible(@NotNull KotlinType $this$upperIfFlexible) {
        SimpleType simpleType;
        Intrinsics.checkNotNullParameter((Object)$this$upperIfFlexible, (String)"<this>");
        UnwrappedType $this$upperIfFlexible_u24lambda_u240 = $this$upperIfFlexible.unwrap();
        boolean bl = false;
        UnwrappedType unwrappedType = $this$upperIfFlexible_u24lambda_u240;
        if (unwrappedType instanceof FlexibleType) {
            simpleType = ((FlexibleType)$this$upperIfFlexible_u24lambda_u240).getUpperBound();
        } else if (unwrappedType instanceof SimpleType) {
            simpleType = (SimpleType)$this$upperIfFlexible_u24lambda_u240;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return simpleType;
    }
}

