/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.it.unimi.dsi.fastutil.ints;

import java.io.Serializable;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.Arrays;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.Hash;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.ints.IntComparator;

public final class IntArrays {
    public static final int[] EMPTY_ARRAY = new int[0];
    public static final int[] DEFAULT_EMPTY_ARRAY = new int[0];
    protected static final Segment POISON_PILL = new Segment(-1, -1, -1);
    public static final Hash.Strategy<int[]> HASH_STRATEGY = new a(0);

    /*
     * WARNING - void declaration
     */
    public static void ensureOffsetLength(int[] a2, int offset, int length) {
        void var2_2;
        void var1_1;
        Arrays.ensureOffsetLength(a2.length, (int)var1_1, (int)var2_2);
    }

    public static void swap(int[] x2, int a2, int b2) {
        int n2 = x2[a2];
        x2[var1_1] = x2[b2];
        var0[var2_2] = n2;
    }

    public static void swap(int[] x2, int a2, int b2, int n2) {
        int n3 = 0;
        while (n3 < n2) {
            IntArrays.swap(x2, a2, b2);
            ++n3;
            ++a2;
            ++b2;
        }
    }

    private static int b(int[] nArray, int n2, int n3, int n4, IntComparator intComparator) {
        int n5 = intComparator.compare(nArray[n2], nArray[n3]);
        int n6 = intComparator.compare(nArray[n2], nArray[n4]);
        int n7 = intComparator.compare(nArray[n3], nArray[n4]);
        if (n5 < 0) {
            if (n7 < 0) {
                return n3;
            }
            if (n6 < 0) {
                return n4;
            }
            return n2;
        }
        if (n7 > 0) {
            return n3;
        }
        if (n6 > 0) {
            return n4;
        }
        return n2;
    }

    public static void quickSort(int[] x2, int from, int to, IntComparator comp) {
        while (true) {
            int n2;
            int n3;
            int n4;
            if ((n4 = to - from) < 16) {
                while (from < to - 1) {
                    n4 = from;
                    for (n3 = from + 1; n3 < to; ++n3) {
                        if (comp.compare(x2[n3], x2[n4]) >= 0) continue;
                        n4 = n3;
                    }
                    if (n4 != from) {
                        n3 = x2[from];
                        x2[from] = x2[n4];
                        x2[n4] = n3;
                    }
                    ++from;
                }
                return;
            }
            n3 = from + n4 / 2;
            int n5 = from;
            int n6 = to - 1;
            if (n4 > 128) {
                int n7 = from;
                n5 = IntArrays.b(x2, n7, n7 + (n4 /= 8), from + 2 * n4, comp);
                int n8 = n3;
                n3 = IntArrays.b(x2, n3 - n4, n8, n8 + n4, comp);
                n6 = IntArrays.b(x2, n6 - 2 * n4, n6 - n4, n6, comp);
            }
            n3 = IntArrays.b(x2, n5, n3, n6, comp);
            n4 = x2[n3];
            n3 = from;
            n5 = from;
            int n9 = n6 = to - 1;
            while (true) {
                if (n5 <= n6 && (n2 = comp.compare(x2[n5], n4)) <= 0) {
                    if (n2 == 0) {
                        IntArrays.swap(x2, n3++, n5);
                    }
                    ++n5;
                    continue;
                }
                while (n6 >= n5 && (n2 = comp.compare(x2[n6], n4)) >= 0) {
                    if (n2 == 0) {
                        IntArrays.swap(x2, n6, n9--);
                    }
                    --n6;
                }
                if (n5 > n6) break;
                IntArrays.swap(x2, n5++, n6--);
            }
            n2 = Math.min(n3 - from, n5 - n3);
            IntArrays.swap(x2, from, n5 - n2, n2);
            n2 = Math.min(n9 - n6, to - n9 - 1);
            IntArrays.swap(x2, n5, to - n2, n2);
            n2 = n5 - n3;
            if (n2 > 1) {
                int n10 = from;
                IntArrays.quickSort(x2, n10, n10 + n2, comp);
            }
            if ((n2 = n9 - n6) <= 1) break;
            from = to - n2;
        }
    }

    private static int b(int[] nArray, int n2, int n3, int n4) {
        int n5 = Integer.compare(nArray[n2], nArray[n3]);
        int n6 = Integer.compare(nArray[n2], nArray[n4]);
        int n7 = Integer.compare(nArray[n3], nArray[n4]);
        if (n5 < 0) {
            if (n7 < 0) {
                return n3;
            }
            if (n6 < 0) {
                return n4;
            }
            return n2;
        }
        if (n7 > 0) {
            return n3;
        }
        if (n6 > 0) {
            return n4;
        }
        return n2;
    }

    public static void quickSort(int[] x2, int from, int to) {
        while (true) {
            int n2;
            int n3;
            int n4;
            if ((n4 = to - from) < 16) {
                while (from < to - 1) {
                    n4 = from;
                    for (n3 = from + 1; n3 < to; ++n3) {
                        if (x2[n3] >= x2[n4]) continue;
                        n4 = n3;
                    }
                    if (n4 != from) {
                        n3 = x2[from];
                        x2[from] = x2[n4];
                        x2[n4] = n3;
                    }
                    ++from;
                }
                return;
            }
            n3 = from + n4 / 2;
            int n5 = from;
            int n6 = to - 1;
            if (n4 > 128) {
                int n7 = from;
                n5 = IntArrays.b(x2, n7, n7 + (n4 /= 8), from + 2 * n4);
                int n8 = n3;
                n3 = IntArrays.b(x2, n3 - n4, n8, n8 + n4);
                n6 = IntArrays.b(x2, n6 - 2 * n4, n6 - n4, n6);
            }
            n3 = IntArrays.b(x2, n5, n3, n6);
            n4 = x2[n3];
            n3 = from;
            n5 = from;
            int n9 = n6 = to - 1;
            while (true) {
                if (n5 <= n6 && (n2 = Integer.compare(x2[n5], n4)) <= 0) {
                    if (n2 == 0) {
                        IntArrays.swap(x2, n3++, n5);
                    }
                    ++n5;
                    continue;
                }
                while (n6 >= n5 && (n2 = Integer.compare(x2[n6], n4)) >= 0) {
                    if (n2 == 0) {
                        IntArrays.swap(x2, n6, n9--);
                    }
                    --n6;
                }
                if (n5 > n6) break;
                IntArrays.swap(x2, n5++, n6--);
            }
            n2 = Math.min(n3 - from, n5 - n3);
            IntArrays.swap(x2, from, n5 - n2, n2);
            n2 = Math.min(n9 - n6, to - n9 - 1);
            IntArrays.swap(x2, n5, to - n2, n2);
            n2 = n5 - n3;
            if (n2 > 1) {
                int n10 = from;
                IntArrays.quickSort(x2, n10, n10 + n2);
            }
            if ((n2 = n9 - n6) <= 1) break;
            from = to - n2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void unstableSort(int[] a2, int from, int to) {
        void var2_2;
        void var1_1;
        int[] nArray;
        if (to - from >= 2000) {
            IntArrays.radixSort(a2, from, to);
            return;
        }
        IntArrays.quickSort(nArray, (int)var1_1, (int)var2_2);
    }

    public static void unstableSort(int[] a2) {
        int[] nArray;
        IntArrays.unstableSort(a2, 0, nArray.length);
    }

    /*
     * WARNING - void declaration
     */
    public static void unstableSort(int[] a2, int from, int to, IntComparator comp) {
        void var3_3;
        void var2_2;
        void var1_1;
        IntArrays.quickSort(a2, (int)var1_1, (int)var2_2, (IntComparator)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static void unstableSort(int[] a2, IntComparator comp) {
        void var1_1;
        int[] nArray;
        IntArrays.unstableSort(a2, 0, nArray.length, (IntComparator)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static void mergeSort(int[] a2, int from, int to, IntComparator comp, int[] supp22) {
        int[] supp22;
        int n2 = to - from;
        if (n2 < 16) {
            int supp22 = from;
            while (++supp22 < to) {
                n2 = a2[supp22];
                int n3 = supp22;
                int n4 = a2[n3 - 1];
                while (comp.compare(n2, n4) < 0) {
                    a2[n3] = n4;
                    if (from == n3 - 1) {
                        --n3;
                        break;
                    }
                    n4 = a2[--n3 - 1];
                }
                a2[n3] = n2;
            }
            return;
        }
        if (supp22 == null) {
            supp22 = java.util.Arrays.copyOf(a2, to);
        }
        int n5 = from + to >>> 1;
        IntArrays.mergeSort(supp22, from, n5, comp, a2);
        IntArrays.mergeSort(supp22, n5, to, comp, a2);
        if (comp.compare(supp22[n5 - 1], supp22[n5]) <= 0) {
            System.arraycopy(supp22, from, a2, from, n2);
            return;
        }
        int n6 = n5;
        for (n2 = from; n2 < to; ++n2) {
            void var1_1;
            a2[n2] = n6 >= to || var1_1 < n5 && comp.compare(supp22[var1_1], supp22[n6]) <= 0 ? supp22[++var1_1] : supp22[n6++];
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void mergeSort(int[] a2, int from, int to, IntComparator comp) {
        void var3_3;
        void var2_2;
        void var1_1;
        IntArrays.mergeSort(a2, (int)var1_1, (int)var2_2, (IntComparator)var3_3, null);
    }

    /*
     * WARNING - void declaration
     */
    public static void stableSort(int[] a2, int from, int to, IntComparator comp) {
        void var3_3;
        void var2_2;
        void var1_1;
        IntArrays.mergeSort(a2, (int)var1_1, (int)var2_2, (IntComparator)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static void stableSort(int[] a2, IntComparator comp) {
        void var1_1;
        int[] nArray;
        IntArrays.stableSort(a2, 0, nArray.length, (IntComparator)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static void radixSort(int[] a2, int from, int to) {
        void var1_1;
        void var2_3;
        if (to - from < 1024) {
            IntArrays.quickSort(a2, from, to);
            return;
        }
        int n2 = 0;
        int[] nArray = new int[766];
        int[] nArray2 = new int[766];
        int[] nArray3 = new int[766];
        nArray[0] = from;
        nArray2[0] = var2_3 - var1_1;
        ++n2;
        nArray3[0] = 0;
        int[] nArray4 = new int[256];
        int[] nArray5 = new int[256];
        while (n2 > 0) {
            int n3;
            int n4 = nArray[--n2];
            int n5 = nArray2[n2];
            int n6 = nArray3[n2];
            int n7 = n6 % 4 == 0 ? 128 : 0;
            int n8 = 3 - n6 % 4 << 3;
            int n9 = n4 + n5;
            while (n9-- != n4) {
                int n10 = a2[n9] >>> n8 & 0xFF ^ n7;
                nArray4[n10] = nArray4[n10] + 1;
            }
            n9 = -1;
            int n11 = n4;
            for (n3 = 0; n3 < 256; ++n3) {
                if (nArray4[n3] != 0) {
                    n9 = n3;
                }
                nArray5[n3] = n11 += nArray4[n3];
            }
            n3 = n4 + n5 - nArray4[n9];
            for (n11 = n4; n11 <= n3; n11 += nArray4[n4]) {
                n9 = a2[n11];
                n4 = n9 >>> n8 & 0xFF ^ n7;
                if (n11 < n3) {
                    while (true) {
                        int n12 = n4;
                        int n13 = nArray5[n12] - 1;
                        nArray5[n12] = n13;
                        n5 = n13;
                        if (n13 <= n11) break;
                        n4 = n9;
                        n9 = a2[n5];
                        a2[n5] = n4;
                        n4 = n9 >>> n8 & 0xFF ^ n7;
                    }
                    a2[n11] = n9;
                }
                if (n6 < 3 && nArray4[n4] > 1) {
                    if (nArray4[n4] < 1024) {
                        int n14 = n11;
                        IntArrays.quickSort(a2, n14, n14 + nArray4[n4]);
                    } else {
                        nArray[n2] = n11;
                        nArray2[n2] = nArray4[n4];
                        nArray3[n2++] = n6 + 1;
                    }
                }
                nArray4[n4] = 0;
            }
        }
    }

    protected static final class Segment {
        protected final int a;
        protected final int b;
        protected final int c;

        /*
         * WARNING - void declaration
         */
        protected Segment(int offset, int length, int level) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.a = var1_1;
            this.b = var2_2;
            this.c = var3_3;
        }

        public final String toString() {
            return "Segment [offset=" + this.a + ", length=" + this.b + ", level=" + this.c + "]";
        }
    }

    private static final class a
    implements Serializable,
    Hash.Strategy<int[]> {
        private a() {
        }

        /* synthetic */ a(byte by) {
            this();
        }
    }
}

