/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.konan.file;

import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileTime;
import java.nio.file.spi.FileSystemProvider;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.konan.file.File;

@Metadata(mv={1, 7, 0}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\u001a8\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u001a\b\u0002\u0010\b\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\n\u0012\u0004\u0012\u00020\u00040\tH\u0080\b\u00f8\u0001\u0000\u001a\f\u0010\u000b\u001a\u00020\u0006*\u00020\u0006H\u0002\u001a\u0012\u0010\f\u001a\u00020\r*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u0012\u0010\f\u001a\u00020\r*\u00020\u000e2\u0006\u0010\f\u001a\u00020\r\u001a3\u0010\u0011\u001a\u00020\u0004*\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00152\u0014\b\u0002\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00040\tH\u0082\b\u001a\u001e\u0010\u0018\u001a\u00020\u0004*\u00020\r2\u0006\u0010\u0019\u001a\u00020\r2\b\b\u0002\u0010\u001a\u001a\u00020\u0015H\u0002\u001a\u0014\u0010\u001b\u001a\n \u0002*\u0004\u0018\u00010\u00060\u0006*\u00020\rH\u0002\u001a&\u0010\u001c\u001a\u00020\u0004*\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u00062\b\b\u0002\u0010\u001e\u001a\u00020\u00062\b\b\u0002\u0010\u001a\u001a\u00020\u0015\u001a&\u0010\u001c\u001a\u00020\u0004*\u00020\r2\u0006\u0010\u001d\u001a\u00020\r2\b\b\u0002\u0010\u001e\u001a\u00020\r2\b\b\u0002\u0010\u001a\u001a\u00020\u0015\u001a)\u0010\u001f\u001a\u0002H \"\u0004\b\u0000\u0010 *\u00020\r2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u0002H 0\t\u00a2\u0006\u0002\u0010\"\u001a1\u0010\u001f\u001a\u0002H \"\u0004\b\u0000\u0010 *\u00020\r2\u0006\u0010#\u001a\u00020\u00152\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u0002H 0\t\u00a2\u0006\u0002\u0010$\u001a\u0012\u0010%\u001a\u00020\u0004*\u00020\r2\u0006\u0010&\u001a\u00020\r\u001a\u0016\u0010'\u001a\u00020\u000e*\u00020\r2\b\b\u0002\u0010#\u001a\u00020\u0015H\u0000\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006("}, d2={"DEFAULT_ZIP_ENTRY_TIME", "Ljava/nio/file/attribute/FileTime;", "kotlin.jvm.PlatformType", "zipDirAsInternal", "", "dirPath", "Ljava/nio/file/Path;", "zipFilePath", "shuffle", "Lkotlin/Function1;", "", "expandSymlinks", "file", "Lorg/jetbrains/kotlin/konan/file/File;", "Ljava/nio/file/FileSystem;", "path", "", "newEntry", "Ljava/util/zip/ZipOutputStream;", "relativePath", "isDir", "", "block", "Ljava/util/zip/ZipEntry;", "recursiveCopyTo", "destination", "resetTimeAttributes", "toPath", "unzipTo", "destinationDirectory", "fromSubdirectory", "withZipFileSystem", "T", "action", "(Lorg/jetbrains/kotlin/konan/file/File;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "create", "(Lorg/jetbrains/kotlin/konan/file/File;ZLkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "zipDirAs", "zipFile", "zipFileSystem", "kotlin-util-io"})
@SourceDebugExtension(value={"SMAP\nZipUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ZipUtil.kt\norg/jetbrains/kotlin/konan/file/ZipUtilKt\n+ 2 File.kt\norg/jetbrains/kotlin/konan/file/FileKt\n+ 3 ZipUtil.kt\norg/jetbrains/kotlin/konan/file/ZipUtilKt$zipDirAsInternal$1\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 ZipUtil.kt\norg/jetbrains/kotlin/konan/file/ZipUtilKt$newEntry$1\n*L\n1#1,200:1\n57#1,4:201\n61#1,5:208\n66#1,3:214\n69#1,14:218\n98#1,22:232\n83#1,2:254\n121#1,2:256\n86#1:258\n97#1,23:259\n121#1,2:283\n88#1,3:285\n91#1:289\n92#1:299\n93#1:309\n98#1,25:317\n97#1,23:342\n121#1,2:366\n98#1,25:394\n97#1,26:419\n219#2,3:205\n230#2,2:290\n222#2,7:292\n230#2,2:300\n222#2,7:302\n219#2,3:310\n219#2,3:313\n230#2,2:369\n222#2,7:371\n230#2,2:378\n222#2,7:380\n219#2,3:387\n219#2,3:390\n230#2,2:446\n222#2,7:448\n230#2,2:455\n222#2,7:457\n219#2,13:464\n57#3:213\n1869#4:217\n1870#4:288\n1869#4:316\n1870#4:368\n1869#4:393\n1870#4:445\n97#5:282\n97#5:365\n*S KotlinDebug\n*F\n+ 1 ZipUtil.kt\norg/jetbrains/kotlin/konan/file/ZipUtilKt\n*L\n55#1:201,4\n55#1:208,5\n55#1:214,3\n55#1:218,14\n55#1:232,22\n55#1:254,2\n55#1:256,2\n55#1:258\n55#1:259,23\n55#1:283,2\n55#1:285,3\n55#1:289\n55#1:299\n55#1:309\n82#1:317,25\n86#1:342,23\n86#1:366,2\n82#1:394,25\n86#1:419,26\n55#1:205,3\n55#1:290,2\n55#1:292,7\n55#1:300,2\n55#1:302,7\n60#1:310,3\n61#1:313,3\n61#1:369,2\n61#1:371,7\n60#1:378,2\n60#1:380,7\n60#1:387,3\n61#1:390,3\n61#1:446,2\n61#1:448,7\n60#1:455,2\n60#1:457,7\n164#1:464,13\n55#1:213\n55#1:217\n55#1:288\n68#1:316\n68#1:368\n68#1:393\n68#1:445\n55#1:282\n86#1:365\n*E\n"})
public final class ZipUtilKt {
    private static final FileTime DEFAULT_ZIP_ENTRY_TIME = FileTime.fromMillis(0L);

    @NotNull
    public static final FileSystem zipFileSystem(@NotNull File $this$zipFileSystem, boolean create) {
        FileSystem fileSystem;
        block7: {
            Intrinsics.checkNotNullParameter((Object)$this$zipFileSystem, (String)"<this>");
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"create", (Object)String.valueOf(create))};
            HashMap attributes = MapsKt.hashMapOf((Pair[])pairArray);
            List<FileSystemProvider> list = FileSystemProvider.installedProviders();
            Intrinsics.checkNotNullExpressionValue(list, (String)"installedProviders()");
            for (FileSystemProvider fileSystemProvider : (Iterable)list) {
                FileSystem fileSystem2;
                FileSystem fileSystem3;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)fileSystemProvider.getScheme(), (Object)"jar")) {
                    fileSystem3 = null;
                } else {
                    FileSystem fileSystem4;
                    try {
                        fileSystem4 = fileSystemProvider.newFileSystem(ZipUtilKt.toPath($this$zipFileSystem), (Map)attributes);
                    }
                    catch (Exception e) {
                        Exception exception = e;
                        if (!(exception instanceof UnsupportedOperationException ? true : exception instanceof IllegalArgumentException)) {
                            throw e;
                        }
                        fileSystem4 = null;
                    }
                    fileSystem3 = fileSystem4;
                }
                if ((fileSystem2 = fileSystem3) == null) continue;
                fileSystem = fileSystem2;
                break block7;
            }
            fileSystem = null;
        }
        if (fileSystem == null) {
            throw new ZipException("Cannot create a virtual file system to read KLIB archive file. Probably the file is a malformed archive or does not exist: " + $this$zipFileSystem);
        }
        return fileSystem;
    }

    @NotNull
    public static final File file(@NotNull FileSystem $this$file, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)$this$file, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Path path2 = $this$file.getPath(path, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"this.getPath(path)");
        return new File(path2);
    }

    private static final Path toPath(File $this$toPath) {
        return Paths.get($this$toPath.getPath(), new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T> T withZipFileSystem(@NotNull File $this$withZipFileSystem, boolean create, @NotNull Function1<? super FileSystem, ? extends T> action) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$withZipFileSystem, (String)"<this>");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        AutoCloseable $this$use$iv = ZipUtilKt.zipFileSystem($this$withZipFileSystem, create);
        boolean $i$f$use = false;
        boolean closed$iv = false;
        try {
            object = action.invoke((Object)$this$use$iv);
        }
        catch (Exception e$iv) {
            try {
                closed$iv = true;
                try {
                    AutoCloseable autoCloseable = $this$use$iv;
                    if (autoCloseable != null) {
                        autoCloseable.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw e$iv;
            }
            catch (Throwable throwable) {
                if (!closed$iv) {
                    AutoCloseable autoCloseable = $this$use$iv;
                    if (autoCloseable != null) {
                        autoCloseable.close();
                    }
                }
                throw throwable;
            }
        }
        AutoCloseable autoCloseable = $this$use$iv;
        if (autoCloseable != null) {
            autoCloseable.close();
        }
        return (T)object;
    }

    public static final <T> T withZipFileSystem(@NotNull File $this$withZipFileSystem, @NotNull Function1<? super FileSystem, ? extends T> action) {
        Intrinsics.checkNotNullParameter((Object)$this$withZipFileSystem, (String)"<this>");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        return ZipUtilKt.withZipFileSystem($this$withZipFileSystem, false, action);
    }
}

