/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.commonizer.cir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.commonizer.cir.AnyClassOrTypeAliasType;
import org.jetbrains.kotlin.commonizer.cir.CirClass;
import org.jetbrains.kotlin.commonizer.cir.CirClassType;
import org.jetbrains.kotlin.commonizer.cir.CirConversionsKt;
import org.jetbrains.kotlin.commonizer.cir.CirProvided;
import org.jetbrains.kotlin.commonizer.cir.CirSimpleType;
import org.jetbrains.kotlin.commonizer.cir.CirSupertypesResolver;
import org.jetbrains.kotlin.commonizer.cir.UtilsKt;
import org.jetbrains.kotlin.commonizer.mergedtree.CirClassifierIndex;
import org.jetbrains.kotlin.commonizer.mergedtree.CirClassifierIndexKt;
import org.jetbrains.kotlin.commonizer.mergedtree.CirProvidedClassifiers;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\u001e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\"\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\t*\u00020\u00052\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u0010H\u0002J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/commonizer/cir/SimpleCirSupertypesResolver;", "Lorg/jetbrains/kotlin/commonizer/cir/CirSupertypesResolver;", "classifiers", "Lorg/jetbrains/kotlin/commonizer/mergedtree/CirClassifierIndex;", "dependencies", "Lorg/jetbrains/kotlin/commonizer/mergedtree/CirProvidedClassifiers;", "<init>", "(Lorg/jetbrains/kotlin/commonizer/mergedtree/CirClassifierIndex;Lorg/jetbrains/kotlin/commonizer/mergedtree/CirProvidedClassifiers;)V", "supertypes", "", "Lorg/jetbrains/kotlin/commonizer/cir/CirClassType;", "type", "supertypesFromCirClass", "classifier", "Lorg/jetbrains/kotlin/commonizer/cir/CirClass;", "supertypesFromProvidedClass", "Lorg/jetbrains/kotlin/commonizer/cir/CirProvided$Class;", "buildSupertypeFromClassifierSupertype", "supertype", "kotlin-klib-commonizer"})
@SourceDebugExtension(value={"SMAP\nCirSupertypesResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CirSupertypesResolver.kt\norg/jetbrains/kotlin/commonizer/cir/SimpleCirSupertypesResolver\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 utils.kt\norg/jetbrains/kotlin/commonizer/cir/UtilsKt\n*L\n1#1,64:1\n812#2,12:65\n1642#2,10:77\n1915#2:87\n1916#2:89\n1652#2:90\n812#2,12:91\n1642#2,10:103\n1915#2:113\n1916#2:115\n1652#2:116\n1642#2,10:117\n1915#2:127\n1916#2:129\n1652#2:130\n1#3:88\n1#3:114\n1#3:128\n39#4:131\n*S KotlinDebug\n*F\n+ 1 CirSupertypesResolver.kt\norg/jetbrains/kotlin/commonizer/cir/SimpleCirSupertypesResolver\n*L\n44#1:65,12\n45#1:77,10\n45#1:87\n45#1:89\n45#1:90\n50#1:91,12\n51#1:103,10\n51#1:113\n51#1:115\n51#1:116\n52#1:117,10\n52#1:127\n52#1:129\n52#1:130\n45#1:88\n51#1:114\n52#1:128\n58#1:131\n*E\n"})
public final class SimpleCirSupertypesResolver
implements CirSupertypesResolver {
    @NotNull
    private final CirClassifierIndex classifiers;
    @NotNull
    private final CirProvidedClassifiers dependencies;

    public SimpleCirSupertypesResolver(@NotNull CirClassifierIndex classifiers2, @NotNull CirProvidedClassifiers dependencies) {
        Intrinsics.checkNotNullParameter((Object)classifiers2, (String)"classifiers");
        Intrinsics.checkNotNullParameter((Object)dependencies, (String)"dependencies");
        this.classifiers = classifiers2;
        this.dependencies = dependencies;
    }

    @Override
    @NotNull
    public Set<CirClassType> supertypes(@NotNull CirClassType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        CirClass cirClass = CirClassifierIndexKt.findClass(this.classifiers, type.getClassifierId());
        if (cirClass != null) {
            CirClass classifier = cirClass;
            boolean bl = false;
            return this.supertypesFromCirClass(type, classifier);
        }
        CirProvided.Classifier classifier = this.dependencies.classifier(type.getClassifierId());
        if (classifier != null) {
            CirProvided.Classifier classifier2 = classifier;
            boolean bl = false;
            if (classifier2 instanceof CirProvided.Class) {
                return this.supertypesFromProvidedClass(this.dependencies, type, (CirProvided.Class)classifier2);
            }
        }
        return SetsKt.emptySet();
    }

    /*
     * WARNING - void declaration
     */
    private final Set<CirClassType> supertypesFromCirClass(CirClassType type, CirClass classifier) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = classifier.getSupertypes();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof CirClassType)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterIsInstanceTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            CirClassType it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            CirClassType superType = (CirClassType)element$iv$iv;
            boolean bl2 = false;
            if (this.buildSupertypeFromClassifierSupertype(type, superType) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private final Set<CirClassType> supertypesFromProvidedClass(CirProvidedClassifiers $this$supertypesFromProvidedClass, CirClassType type, CirProvided.Class classifier) {
        CirClassType it$iv$iv;
        boolean bl;
        AnyClassOrTypeAliasType superType;
        boolean bl2;
        Object element$iv$iv;
        Object element$iv$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = classifier.getSupertypes();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv2 : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv2 instanceof CirProvided.ClassType)) continue;
            destination$iv$iv.add(element$iv$iv2);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterIsInstanceTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Iterable $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            element$iv$iv = element$iv$iv$iv = iterator2.next();
            bl2 = false;
            superType = (CirProvided.ClassType)element$iv$iv;
            boolean bl3 = false;
            if (CirConversionsKt.toCirClassTypeOrNull(superType, $this$supertypesFromProvidedClass) == null) continue;
            bl = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        $i$f$mapNotNull = false;
        $this$mapNotNullTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        $i$f$mapNotNullTo = false;
        $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        $i$f$forEach = false;
        iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            element$iv$iv = element$iv$iv$iv = iterator2.next();
            bl2 = false;
            superType = (CirClassType)element$iv$iv;
            boolean bl4 = false;
            if (this.buildSupertypeFromClassifierSupertype(type, (CirClassType)superType) == null) continue;
            bl = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private final CirClassType buildSupertypeFromClassifierSupertype(CirClassType type, CirClassType supertype) {
        if (type.getArguments().isEmpty() && supertype.getArguments().isEmpty()) {
            void $this$makeNullableIfNecessary$iv;
            CirSimpleType cirSimpleType = supertype;
            boolean necessary$iv = type.isMarkedNullable();
            boolean $i$f$makeNullableIfNecessary = false;
            return (CirClassType)(!necessary$iv ? $this$makeNullableIfNecessary$iv : UtilsKt.makeNullable($this$makeNullableIfNecessary$iv));
        }
        return null;
    }
}

