/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.lombok.processor;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiModifierList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.lombok.config.LombokAnnotations;
import org.jetbrains.kotlin.lombok.processor.AbstractConstructorProcessor;
import org.jetbrains.kotlin.lombok.utils.DescriptorUtilsKt;
import org.jetbrains.kotlin.lombok.utils.LombokNames;
import org.jetbrains.kotlin.resolve.source.PsiSourceElementKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0014J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0014J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tH\u0002\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/lombok/processor/RequiredArgsConstructorProcessor;", "Lorg/jetbrains/kotlin/lombok/processor/AbstractConstructorProcessor;", "Lorg/jetbrains/kotlin/lombok/config/LombokAnnotations$RequiredArgsConstructor;", "()V", "getAnnotation", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "getPropertiesForParameters", "", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "isFieldRequired", "", "field", "kotlin-maven-lombok"})
public final class RequiredArgsConstructorProcessor
extends AbstractConstructorProcessor<LombokAnnotations.RequiredArgsConstructor> {
    @Override
    @Nullable
    protected LombokAnnotations.RequiredArgsConstructor getAnnotation(@NotNull ClassDescriptor classDescriptor) {
        Intrinsics.checkNotNullParameter((Object)classDescriptor, (String)"classDescriptor");
        LombokAnnotations.RequiredArgsConstructor requiredArgsConstructor = (LombokAnnotations.RequiredArgsConstructor)LombokAnnotations.RequiredArgsConstructor.Companion.getOrNull((Annotated)classDescriptor);
        if (requiredArgsConstructor == null) {
            LombokAnnotations.Data data = (LombokAnnotations.Data)LombokAnnotations.Data.Companion.getOrNull((Annotated)classDescriptor);
            requiredArgsConstructor = data == null ? null : data.asRequiredArgsConstructor();
        }
        return requiredArgsConstructor;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected List<PropertyDescriptor> getPropertiesForParameters(@NotNull ClassDescriptor classDescriptor) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)classDescriptor, (String)"classDescriptor");
        Iterable $this$filter$iv = DescriptorUtilsKt.getJavaFields(classDescriptor);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PropertyDescriptor p0 = (PropertyDescriptor)element$iv$iv;
            boolean bl = false;
            if (!this.isFieldRequired(p0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isFieldRequired(PropertyDescriptor field) {
        boolean bl;
        SourceElement sourceElement = field.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)sourceElement, (String)"field.source");
        PsiElement psiElement = PsiSourceElementKt.getPsi((SourceElement)sourceElement);
        if (!(psiElement instanceof PsiField)) return false;
        PsiField psiField = (PsiField)psiElement;
        if (psiField == null) {
            return false;
        }
        PsiField psi = psiField;
        PsiModifierList psiModifierList = psi.getModifierList();
        if (!(psiModifierList == null ? false : (bl = psiModifierList.hasModifierProperty("final")))) {
            AnnotationDescriptor annotation;
            Iterable $this$any$iv = (Iterable)field.getAnnotations();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator iterator = $this$any$iv.iterator();
            do {
                if (!iterator.hasNext()) return false;
                Object element$iv = iterator.next();
                annotation = (AnnotationDescriptor)element$iv;
                boolean bl2 = false;
            } while (!CollectionsKt.contains((Iterable)LombokNames.INSTANCE.getNON_NULL_ANNOTATIONS(), (Object)annotation.getFqName()));
            boolean bl3 = true;
            if (!bl3) return false;
        }
        boolean bl4 = true;
        boolean bl5 = bl4;
        if (!bl5) return false;
        if (psi.hasInitializer()) return false;
        return true;
    }
}

