/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.serialization.compiler.diagnostic;

import java.io.Closeable;
import java.io.File;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinarySourceElement;
import org.jetbrains.kotlinx.serialization.compiler.diagnostic.RuntimeVersions;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bJ\u000e\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\tJ\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlinx/serialization/compiler/diagnostic/CommonVersionReader;", "", "<init>", "()V", "REQUIRE_KOTLIN_VERSION", "Ljava/util/jar/Attributes$Name;", "CLASS_SUFFIX", "", "computeRuntimeVersions", "Lorg/jetbrains/kotlinx/serialization/compiler/diagnostic/RuntimeVersions;", "sourceElement", "Lorg/jetbrains/kotlin/descriptors/SourceElement;", "getVersionsFromManifest", "runtimeLibraryPath", "Ljava/io/File;", "canSupportInlineClasses", "", "currentVersion", "getJarAttribute", "file", "attribute", "kotlinx-serialization-compiler-plugin.common"})
@SourceDebugExtension(value={"SMAP\nRuntimeVersions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RuntimeVersions.kt\norg/jetbrains/kotlinx/serialization/compiler/diagnostic/CommonVersionReader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,67:1\n1#2:68\n*E\n"})
public final class CommonVersionReader {
    @NotNull
    public static final CommonVersionReader INSTANCE = new CommonVersionReader();
    @NotNull
    private static final Attributes.Name REQUIRE_KOTLIN_VERSION = new Attributes.Name("Require-Kotlin-Version");
    @NotNull
    private static final String CLASS_SUFFIX = "!/kotlinx/serialization/KSerializer.class";

    private CommonVersionReader() {
    }

    @Nullable
    public final RuntimeVersions computeRuntimeVersions(@Nullable SourceElement sourceElement) {
        Object object = sourceElement instanceof KotlinJvmBinarySourceElement ? (KotlinJvmBinarySourceElement)sourceElement : null;
        if (object == null || (object = object.getBinaryClass()) == null || (object = object.getLocation()) == null) {
            return null;
        }
        Object location = object;
        String jarFile = StringsKt.removeSuffix((String)location, (CharSequence)CLASS_SUFFIX);
        if (!StringsKt.endsWith$default((String)jarFile, (String)".jar", (boolean)false, (int)2, null)) {
            return null;
        }
        File file = new File(jarFile);
        if (!file.exists()) {
            return null;
        }
        return this.getVersionsFromManifest(file);
    }

    @NotNull
    public final RuntimeVersions getVersionsFromManifest(@NotNull File runtimeLibraryPath) {
        ApiVersion apiVersion;
        ApiVersion apiVersion2;
        Object object;
        Intrinsics.checkNotNullParameter((Object)runtimeLibraryPath, (String)"runtimeLibraryPath");
        Attributes.Name name = Attributes.Name.IMPLEMENTATION_VERSION;
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"IMPLEMENTATION_VERSION");
        String string = this.getJarAttribute(runtimeLibraryPath, name);
        if (string != null) {
            String string2 = string;
            object = ApiVersion.Companion;
            String p0 = string2;
            boolean bl = false;
            apiVersion2 = object.parse(p0);
        } else {
            apiVersion2 = null;
        }
        ApiVersion version = apiVersion2;
        String string3 = this.getJarAttribute(runtimeLibraryPath, REQUIRE_KOTLIN_VERSION);
        if (string3 != null) {
            object = string3;
            ApiVersion.Companion companion = ApiVersion.Companion;
            Object p0 = object;
            boolean bl = false;
            apiVersion = companion.parse((String)p0);
        } else {
            apiVersion = null;
        }
        ApiVersion kotlinVersion = apiVersion;
        return new RuntimeVersions(version, kotlinVersion);
    }

    public final boolean canSupportInlineClasses(@Nullable RuntimeVersions currentVersion) {
        if (currentVersion == null) {
            return true;
        }
        ApiVersion apiVersion = currentVersion.getImplementationVersion();
        if (apiVersion == null) {
            return false;
        }
        ApiVersion implVersion = apiVersion;
        return implVersion.compareTo(RuntimeVersions.Companion.getMINIMAL_VERSION_FOR_INLINE_CLASSES()) >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String getJarAttribute(File file, Attributes.Name attribute) {
        if (file.canRead()) {
            Closeable closeable = new JarFile(file);
            Throwable throwable = null;
            try {
                JarFile jarFile = (JarFile)closeable;
                boolean bl = false;
                Cloneable cloneable = jarFile.getManifest();
                String string = cloneable != null && (cloneable = ((Manifest)cloneable).getMainAttributes()) != null ? ((Attributes)cloneable).getValue(attribute) : null;
                return string;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        return null;
    }
}

