/*
 * Decompiled with CFR 0.152.
 */
package kotlin.io.path;

import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lkotlin/io/path/PathRelativizer;", "", "()V", "emptyPath", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "parentPath", "tryRelativeTo", "path", "base", "kotlin-stdlib-jdk7"})
final class PathRelativizer {
    @NotNull
    public static final PathRelativizer INSTANCE = new PathRelativizer();
    private static final Path emptyPath = Paths.get("", new String[0]);
    private static final Path parentPath = Paths.get("..", new String[0]);

    private PathRelativizer() {
    }

    @NotNull
    public final Path tryRelativeTo(@NotNull Path path, @NotNull Path base) {
        Path path2;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)base, (String)"base");
        Path bn = base.normalize();
        Path pn = path.normalize();
        Path rn = bn.relativize(pn);
        int n = Math.min(bn.getNameCount(), pn.getNameCount());
        for (int i = 0; i < n && Intrinsics.areEqual((Object)bn.getName(i), (Object)parentPath); ++i) {
            if (Intrinsics.areEqual((Object)pn.getName(i), (Object)parentPath)) continue;
            throw new IllegalArgumentException("Unable to compute relative path");
        }
        if (!Intrinsics.areEqual((Object)pn, (Object)bn) && Intrinsics.areEqual((Object)bn, (Object)emptyPath)) {
            path2 = pn;
        } else {
            String rnString = ((Object)rn).toString();
            String string = rn.getFileSystem().getSeparator();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"rn.fileSystem.separator");
            path2 = StringsKt.endsWith$default((String)rnString, (String)string, (boolean)false, (int)2, null) ? rn.getFileSystem().getPath(StringsKt.dropLast((String)rnString, (int)rn.getFileSystem().getSeparator().length()), new String[0]) : rn;
        }
        Path r = path2;
        Intrinsics.checkNotNullExpressionValue((Object)r, (String)"r");
        return r;
    }
}

