/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.konan.file;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.Writer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.konan.file.File;
import org.jetbrains.kotlin.util.UtilKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010 \n\u0002\b\r\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\t\b\u0086\b\u0018\u0000 g2\u00020\u0001:\u0001gB\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\bB\u000f\b\u0016\u0012\u0006\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\nB\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0005\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u000bB\r\u0012\u0006\u0010\f\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\rJ\u0016\u0010/\u001a\n 0*\u0004\u0018\u00010\u00030\u00032\u0006\u00101\u001a\u000202J\u0014\u00103\u001a\u0002042\f\u00105\u001a\b\u0012\u0004\u0012\u00020\u000506J\u000e\u00107\u001a\u0002042\u0006\u00108\u001a\u00020\u0005J\u000e\u00109\u001a\n 0*\u0004\u0018\u00010:0:J\u000e\u0010\u0004\u001a\u00020\u00002\u0006\u0010)\u001a\u00020\u0005J\u000e\u0010;\u001a\u00020\u0003H\u00c0\u0003\u00a2\u0006\u0002\b<J\u0013\u0010=\u001a\u00020\u00002\b\b\u0002\u0010\f\u001a\u00020\u0003H\u00c6\u0001J\u000e\u0010>\u001a\u0002042\u0006\u0010?\u001a\u00020\u0000J\u000e\u0010@\u001a\u0002042\u0006\u0010A\u001a\u00020\u0005J\u0006\u0010B\u001a\u00020\u0019J\u0006\u0010C\u001a\u00020\u0019J\u0006\u0010D\u001a\u00020\u0000J\u0006\u0010E\u001a\u000204J\u0006\u0010F\u001a\u000204J\u0013\u0010G\u001a\u00020\u00192\b\u0010H\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u001a\u0010I\u001a\u0002042\u0012\u0010J\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u0002040KJ\b\u0010L\u001a\u00020MH\u0016J$\u0010N\u001a\u00020O2\b\b\u0002\u0010P\u001a\u00020Q2\b\b\u0002\u0010R\u001a\u00020S2\b\b\u0002\u0010T\u001a\u00020SJ\u000e\u0010U\u001a\n 0*\u0004\u0018\u00010\u00030\u0003J\u000e\u0010V\u001a\n 0*\u0004\u0018\u00010W0WJ\u001a\u0010X\u001a\u0002042\u0012\u0010Y\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u0002040KJ\u001a\u0010Z\u001a\u0002042\u0012\u0010Y\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u0002040KJ\u0006\u0010[\u001a\u00020\\J\u000e\u0010]\u001a\n 0*\u0004\u0018\u00010202J\f\u0010^\u001a\b\u0012\u0004\u0012\u00020\u00050_J\u000e\u0010`\u001a\u00020\u00192\u0006\u0010?\u001a\u00020\u0000J\u000e\u0010a\u001a\u00020\u00192\u0006\u0010b\u001a\u00020\u0000J\b\u0010c\u001a\u00020\u0005H\u0016J\u0016\u0010d\u001a\n 0*\u0004\u0018\u00010\u00030\u00032\u0006\u00101\u001a\u000202J\u0014\u0010e\u001a\u0002042\f\u00105\u001a\b\u0012\u0004\u0012\u00020\u000506J\u000e\u0010f\u001a\u0002042\u0006\u00108\u001a\u00020\u0005R\u0011\u0010\u000e\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0010R\u0011\u0010\u0016\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0013R\u0011\u0010\u0018\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0013R\u0011\u0010\u001e\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001bR\u0011\u0010\u001f\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u001bR\u0011\u0010 \u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u001bR\u0014\u0010\f\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0017\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00000$8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u0017\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00000$8F\u00a2\u0006\u0006\u001a\u0004\b(\u0010&R\u0011\u0010)\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b*\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b+\u0010\u0013R\u0011\u0010,\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b-\u0010\u0010R\u0011\u0010\t\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b.\u0010\u0013\u00a8\u0006h"}, d2={"Lorg/jetbrains/kotlin/konan/file/File;", "", "parent", "Ljava/nio/file/Path;", "child", "", "(Ljava/nio/file/Path;Ljava/lang/String;)V", "(Lorg/jetbrains/kotlin/konan/file/File;Ljava/lang/String;)V", "(Lorg/jetbrains/kotlin/konan/file/File;Lorg/jetbrains/kotlin/konan/file/File;)V", "path", "(Ljava/lang/String;)V", "(Ljava/lang/String;Ljava/lang/String;)V", "javaPath", "(Ljava/nio/file/Path;)V", "absoluteFile", "getAbsoluteFile", "()Lorg/jetbrains/kotlin/konan/file/File;", "absolutePath", "getAbsolutePath", "()Ljava/lang/String;", "canonicalFile", "getCanonicalFile", "canonicalPath", "getCanonicalPath", "exists", "", "getExists", "()Z", "extension", "getExtension", "isAbsolute", "isDirectory", "isFile", "getJavaPath$kotlin_util_io", "()Ljava/nio/file/Path;", "listFiles", "", "getListFiles", "()Ljava/util/List;", "listFilesOrEmpty", "getListFilesOrEmpty", "name", "getName", "getParent", "parentFile", "getParentFile", "getPath", "appendBytes", "kotlin.jvm.PlatformType", "bytes", "", "appendLines", "", "lines", "", "appendText", "text", "bufferedReader", "Ljava/io/BufferedReader;", "component1", "component1$kotlin_util_io", "copy", "copyTo", "destination", "createAsSymlink", "target", "createNew", "delete", "deleteOnExit", "deleteOnExitRecursively", "deleteRecursively", "equals", "other", "forEachLine", "action", "Lkotlin/Function1;", "hashCode", "", "map", "Ljava/nio/MappedByteBuffer;", "mode", "Ljava/nio/channels/FileChannel$MapMode;", "start", "", "size", "mkdirs", "outputStream", "Ljava/io/OutputStream;", "postorder", "task", "preorder", "printWriter", "Ljava/io/PrintWriter;", "readBytes", "readStrings", "", "renameTo", "startsWith", "another", "toString", "writeBytes", "writeLines", "writeText", "Companion", "kotlin-util-io"})
@SourceDebugExtension(value={"SMAP\nFile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 File.kt\norg/jetbrains/kotlin/konan/file/File\n+ 2 File.kt\norg/jetbrains/kotlin/konan/file/FileKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,213:1\n197#2,3:214\n208#2,2:221\n200#2,7:223\n197#2,13:231\n1549#3:217\n1620#3,3:218\n1#4:230\n*S KotlinDebug\n*F\n+ 1 File.kt\norg/jetbrains/kotlin/konan/file/File\n*L\n54#1:214,3\n54#1:221,2\n54#1:223,7\n141#1:231,13\n54#1:217\n54#1:218,3\n*E\n"})
public final class File {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Path javaPath;
    private static final String pathSeparator = java.io.File.pathSeparator;
    private static final String separator = java.io.File.separator;
    private static final char separatorChar = java.io.File.separatorChar;

    public File(@NotNull Path javaPath) {
        Intrinsics.checkNotNullParameter((Object)javaPath, (String)"javaPath");
        this.javaPath = javaPath;
    }

    @NotNull
    public final Path getJavaPath$kotlin_util_io() {
        return this.javaPath;
    }

    public File(@NotNull Path parent, @NotNull String child) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        Path path = parent.resolve(child);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"parent.resolve(child)");
        this(path);
    }

    public File(@NotNull File parent, @NotNull String child) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        Path path = parent.javaPath.resolve(child);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"parent.javaPath.resolve(child)");
        this(path);
    }

    public File(@NotNull File parent, @NotNull File child) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        Path path = parent.javaPath.resolve(child.javaPath);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"parent.javaPath.resolve(child.javaPath)");
        this(path);
    }

    public File(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Path path2 = Paths.get(path, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(path)");
        this(path2);
    }

    public File(@NotNull String parent, @NotNull String child) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        String[] stringArray = new String[]{child};
        Path path = Paths.get(parent, stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(parent, child)");
        this(path);
    }

    @NotNull
    public final String getPath() {
        return ((Object)this.javaPath).toString();
    }

    @NotNull
    public final String getAbsolutePath() {
        return ((Object)this.javaPath.toAbsolutePath()).toString();
    }

    @NotNull
    public final File getAbsoluteFile() {
        return new File(this.getAbsolutePath());
    }

    @NotNull
    public final String getCanonicalPath() {
        String string = this.javaPath.toFile().getCanonicalPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaPath.toFile().canonicalPath");
        return string;
    }

    @NotNull
    public final File getCanonicalFile() {
        return new File(this.getCanonicalPath());
    }

    @NotNull
    public final String getName() {
        String string = ((Object)this.javaPath.getFileName()).toString();
        String string2 = separator;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"separator");
        return UtilKt.removeSuffixIfPresent(string, string2);
    }

    @NotNull
    public final String getExtension() {
        return StringsKt.substringAfterLast((String)this.getName(), (char)'.', (String)"");
    }

    @NotNull
    public final String getParent() {
        return ((Object)this.javaPath.getParent()).toString();
    }

    @NotNull
    public final File getParentFile() {
        Path path = this.javaPath.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"javaPath.parent");
        return new File(path);
    }

    public final boolean getExists() {
        return Files.exists(this.javaPath, new LinkOption[0]);
    }

    public final boolean isDirectory() {
        return Files.isDirectory(this.javaPath, new LinkOption[0]);
    }

    public final boolean isFile() {
        return Files.isRegularFile(this.javaPath, new LinkOption[0]);
    }

    public final boolean isAbsolute() {
        return this.javaPath.isAbsolute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final List<File> getListFiles() {
        Iterable stream;
        AutoCloseable $this$use$iv = Files.newDirectoryStream(this.javaPath);
        boolean $i$f$use = false;
        boolean closed$iv = false;
        try {
            void $this$mapTo$iv$iv;
            stream = (DirectoryStream)$this$use$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)stream, (String)"stream");
            Iterable $this$map$iv = stream;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                Path path = (Path)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(new File((Path)p0));
            }
            stream = (List)destination$iv$iv;
        }
        catch (Exception e$iv) {
            try {
                closed$iv = true;
                try {
                    AutoCloseable autoCloseable = $this$use$iv;
                    if (autoCloseable != null) {
                        autoCloseable.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw e$iv;
            }
            catch (Throwable throwable) {
                if (!closed$iv) {
                    AutoCloseable autoCloseable = $this$use$iv;
                    if (autoCloseable != null) {
                        autoCloseable.close();
                    }
                }
                throw throwable;
            }
        }
        AutoCloseable autoCloseable = $this$use$iv;
        if (autoCloseable != null) {
            autoCloseable.close();
        }
        return stream;
    }

    @NotNull
    public final List<File> getListFilesOrEmpty() {
        return this.getExists() ? this.getListFiles() : CollectionsKt.emptyList();
    }

    @NotNull
    public final File child(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return new File(this, name);
    }

    public final boolean startsWith(@NotNull File another) {
        Intrinsics.checkNotNullParameter((Object)another, (String)"another");
        return this.javaPath.startsWith(another.javaPath);
    }

    public final void copyTo(@NotNull File destination) {
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
        Files.copy(this.javaPath, destination.javaPath, copyOptionArray);
    }

    public final boolean renameTo(@NotNull File destination) {
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        return this.javaPath.toFile().renameTo(destination.javaPath.toFile());
    }

    public final Path mkdirs() {
        return Files.createDirectories(this.javaPath, new FileAttribute[0]);
    }

    public final boolean delete() {
        return Files.deleteIfExists(this.javaPath);
    }

    public final void deleteRecursively() {
        this.postorder((Function1<? super Path, Unit>)((Function1)deleteRecursively.1.INSTANCE));
    }

    public final void deleteOnExitRecursively() {
        this.preorder((Function1<? super Path, Unit>)((Function1)deleteOnExitRecursively.1.INSTANCE));
    }

    public final void preorder(@NotNull Function1<? super Path, Unit> task) {
        Intrinsics.checkNotNullParameter(task, (String)"task");
        if (!this.getExists()) {
            return;
        }
        Files.walkFileTree(this.javaPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(task){
            final /* synthetic */ Function1<Path, Unit> $task;
            {
                this.$task = $task;
            }

            @NotNull
            public FileVisitResult visitFile(@Nullable Path file, @Nullable BasicFileAttributes attrs) {
                Path path = file;
                Intrinsics.checkNotNull((Object)path);
                this.$task.invoke((Object)path);
                return FileVisitResult.CONTINUE;
            }

            @NotNull
            public FileVisitResult preVisitDirectory(@Nullable Path dir, @Nullable BasicFileAttributes attrs) {
                Path path = dir;
                Intrinsics.checkNotNull((Object)path);
                this.$task.invoke((Object)path);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public final void postorder(@NotNull Function1<? super Path, Unit> task) {
        Intrinsics.checkNotNullParameter(task, (String)"task");
        if (!this.getExists()) {
            return;
        }
        Files.walkFileTree(this.javaPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(task){
            final /* synthetic */ Function1<Path, Unit> $task;
            {
                this.$task = $task;
            }

            @NotNull
            public FileVisitResult visitFile(@Nullable Path file, @Nullable BasicFileAttributes attrs) {
                Path path = file;
                Intrinsics.checkNotNull((Object)path);
                this.$task.invoke((Object)path);
                return FileVisitResult.CONTINUE;
            }

            @NotNull
            public FileVisitResult postVisitDirectory(@Nullable Path dir, @Nullable IOException exc) {
                Path path = dir;
                Intrinsics.checkNotNull((Object)path);
                this.$task.invoke((Object)path);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    @NotNull
    public final MappedByteBuffer map(@NotNull FileChannel.MapMode mode, long start, long size) {
        MappedByteBuffer mappedByteBuffer;
        long l;
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        RandomAccessFile file = new RandomAccessFile(this.getPath(), Intrinsics.areEqual((Object)mode, (Object)FileChannel.MapMode.READ_ONLY) ? "r" : "rw");
        if (Intrinsics.areEqual((Object)mode, (Object)FileChannel.MapMode.READ_ONLY)) {
            l = file.length();
        } else {
            boolean bl;
            long l2;
            long it = l2 = size;
            boolean bl2 = false;
            boolean bl3 = bl = size != -1L;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            l = l2;
        }
        long fileSize = l;
        FileChannel channel = file.getChannel();
        MappedByteBuffer it = mappedByteBuffer = channel.map(mode, start, fileSize);
        boolean bl = false;
        channel.close();
        MappedByteBuffer mappedByteBuffer2 = mappedByteBuffer;
        Intrinsics.checkNotNullExpressionValue((Object)mappedByteBuffer2, (String)"channel.map(mode, start,\u2026.also { channel.close() }");
        return mappedByteBuffer2;
    }

    public static /* synthetic */ MappedByteBuffer map$default(File file, FileChannel.MapMode mapMode, long l, long l2, int n, Object object) {
        if ((n & 1) != 0) {
            FileChannel.MapMode mapMode2 = FileChannel.MapMode.READ_ONLY;
            Intrinsics.checkNotNullExpressionValue((Object)mapMode2, (String)"READ_ONLY");
            mapMode = mapMode2;
        }
        if ((n & 2) != 0) {
            l = 0L;
        }
        if ((n & 4) != 0) {
            l2 = -1L;
        }
        return file.map(mapMode, l, l2);
    }

    @NotNull
    public final File deleteOnExit() {
        this.javaPath.toFile().deleteOnExit();
        return this;
    }

    public final boolean createNew() {
        return this.javaPath.toFile().createNewFile();
    }

    public final byte[] readBytes() {
        return Files.readAllBytes(this.javaPath);
    }

    public final Path writeBytes(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        return Files.write(this.javaPath, bytes, new OpenOption[0]);
    }

    public final Path appendBytes(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.APPEND};
        return Files.write(this.javaPath, bytes, openOptionArray);
    }

    public final void writeLines(@NotNull Iterable<String> lines) {
        Intrinsics.checkNotNullParameter(lines, (String)"lines");
        Files.write(this.javaPath, lines, new OpenOption[0]);
    }

    public final void writeText(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.writeLines(CollectionsKt.listOf((Object)text));
    }

    public final void appendLines(@NotNull Iterable<String> lines) {
        Intrinsics.checkNotNullParameter(lines, (String)"lines");
        OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.APPEND};
        Files.write(this.javaPath, lines, openOptionArray);
    }

    public final void appendText(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.appendLines(CollectionsKt.listOf((Object)text));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void forEachLine(@NotNull Function1<? super String, Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        AutoCloseable $this$use$iv = Files.lines(this.javaPath);
        boolean $i$f$use = false;
        boolean closed$iv = false;
        try {
            Stream lines = (Stream)$this$use$iv;
            boolean bl = false;
            lines.forEach(new Consumer(action){
                final /* synthetic */ Function1<String, Unit> $action;
                {
                    this.$action = $action;
                }

                public final void accept(String it) {
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    this.$action.invoke((Object)it);
                }
            });
            lines = Unit.INSTANCE;
        }
        catch (Exception e$iv) {
            try {
                closed$iv = true;
                try {
                    AutoCloseable autoCloseable = $this$use$iv;
                    if (autoCloseable != null) {
                        autoCloseable.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw e$iv;
            }
            catch (Throwable throwable) {
                if (!closed$iv) {
                    AutoCloseable autoCloseable = $this$use$iv;
                    if (autoCloseable != null) {
                        autoCloseable.close();
                    }
                }
                throw throwable;
            }
        }
        AutoCloseable autoCloseable = $this$use$iv;
        if (autoCloseable != null) {
            autoCloseable.close();
        }
    }

    public final void createAsSymlink(@NotNull String target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Path targetPath = Paths.get(target, new String[0]);
        if (Files.isSymbolicLink(this.javaPath) && Intrinsics.areEqual((Object)Files.readSymbolicLink(this.javaPath), (Object)targetPath)) {
            return;
        }
        Files.createSymbolicLink(this.javaPath, targetPath, new FileAttribute[0]);
    }

    @NotNull
    public String toString() {
        return this.getPath();
    }

    public final BufferedReader bufferedReader() {
        return Files.newBufferedReader(this.javaPath);
    }

    public final OutputStream outputStream() {
        return Files.newOutputStream(this.javaPath, new OpenOption[0]);
    }

    @NotNull
    public final PrintWriter printWriter() {
        java.io.File file = this.javaPath.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"javaPath.toFile()");
        java.io.File file2 = file;
        Charset charset = Charsets.UTF_8;
        java.io.File file3 = file2;
        int n = 8192;
        Object object = file3;
        object = new OutputStreamWriter((OutputStream)new FileOutputStream((java.io.File)object), charset);
        return new PrintWriter(object instanceof BufferedWriter ? (BufferedWriter)object : new BufferedWriter((Writer)object, n));
    }

    @NotNull
    public final List<String> readStrings() {
        List list;
        List list2 = list = (List)new ArrayList();
        boolean bl = false;
        this.forEachLine((Function1<? super String, Unit>)((Function1)new Function1<String, Unit>((List<String>)list2){
            final /* synthetic */ List<String> $list;
            {
                this.$list = $list;
                super(1);
            }

            public final void invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$list.add(it);
            }
        }));
        return list;
    }

    public boolean equals(@Nullable Object other) {
        File file = other instanceof File ? (File)other : null;
        if (file == null) {
            return false;
        }
        File otherFile = file;
        return Intrinsics.areEqual((Object)otherFile.javaPath.toAbsolutePath(), (Object)this.javaPath.toAbsolutePath());
    }

    public int hashCode() {
        return ((Object)this.javaPath.toAbsolutePath()).hashCode();
    }

    @NotNull
    public final Path component1$kotlin_util_io() {
        return this.javaPath;
    }

    @NotNull
    public final File copy(@NotNull Path javaPath) {
        Intrinsics.checkNotNullParameter((Object)javaPath, (String)"javaPath");
        return new File(javaPath);
    }

    public static /* synthetic */ File copy$default(File file, Path path, int n, Object object) {
        if ((n & 1) != 0) {
            path = file.javaPath;
        }
        return file.copy(path);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\f\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0019\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0019\u0010\f\u001a\n \t*\u0004\u0018\u00010\b0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0006R\u0011\u0010\u0014\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0006\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/konan/file/File$Companion;", "", "()V", "javaHome", "Lorg/jetbrains/kotlin/konan/file/File;", "getJavaHome", "()Lorg/jetbrains/kotlin/konan/file/File;", "pathSeparator", "", "kotlin.jvm.PlatformType", "getPathSeparator", "()Ljava/lang/String;", "separator", "getSeparator", "separatorChar", "", "getSeparatorChar", "()C", "userDir", "getUserDir", "userHome", "getUserHome", "kotlin-util-io"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final File getUserDir() {
            String string = System.getProperty("user.dir");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(\"user.dir\")");
            return new File(string);
        }

        @NotNull
        public final File getUserHome() {
            String string = System.getProperty("user.home");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(\"user.home\")");
            return new File(string);
        }

        @NotNull
        public final File getJavaHome() {
            String string = System.getProperty("java.home");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(\"java.home\")");
            return new File(string);
        }

        public final String getPathSeparator() {
            return pathSeparator;
        }

        public final String getSeparator() {
            return separator;
        }

        public final char getSeparatorChar() {
            return separatorChar;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

