/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines.test;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.ContinuationInterceptor;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineExceptionHandler;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.test.DelayController;
import kotlinx.coroutines.test.TestCoroutineScheduler;
import kotlinx.coroutines.test.TestCoroutineScope;
import kotlinx.coroutines.test.TestCoroutineScopeKt;
import kotlinx.coroutines.test.UncaughtExceptionCaptor;
import kotlinx.coroutines.test.UncompletedCoroutinesError;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u000e\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u000bR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000f\u001a\u00060\u0010j\u0002`\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001a"}, d2={"Lkotlinx/coroutines/test/TestCoroutineScopeImpl;", "Lkotlinx/coroutines/test/TestCoroutineScope;", "coroutineContext", "Lkotlin/coroutines/CoroutineContext;", "(Lkotlin/coroutines/CoroutineContext;)V", "cleanedUp", "", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "exceptions", "", "", "initialJobs", "", "Lkotlinx/coroutines/Job;", "lock", "", "Lkotlinx/coroutines/internal/SynchronizedObject;", "testScheduler", "Lkotlinx/coroutines/test/TestCoroutineScheduler;", "getTestScheduler", "()Lkotlinx/coroutines/test/TestCoroutineScheduler;", "cleanupTestCoroutines", "", "reportException", "throwable", "kotlinx-coroutines-test"})
final class TestCoroutineScopeImpl
implements TestCoroutineScope {
    @NotNull
    private final CoroutineContext coroutineContext;
    @NotNull
    private final Object lock;
    @NotNull
    private List<Throwable> exceptions;
    private boolean cleanedUp;
    @NotNull
    private final Set<Job> initialJobs;

    public TestCoroutineScopeImpl(@NotNull CoroutineContext coroutineContext) {
        this.coroutineContext = coroutineContext;
        this.lock = new Object();
        this.exceptions = new ArrayList();
        this.initialJobs = TestCoroutineScopeKt.activeJobs(this.getCoroutineContext());
    }

    @NotNull
    public CoroutineContext getCoroutineContext() {
        return this.coroutineContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean reportException(@NotNull Throwable throwable) {
        boolean bl;
        Object lock$iv = this.lock;
        boolean $i$f$synchronized = false;
        Object object = lock$iv;
        synchronized (object) {
            boolean bl2;
            boolean bl3 = false;
            if (this.cleanedUp) {
                bl2 = false;
            } else {
                this.exceptions.add(throwable);
                bl2 = true;
            }
            bl = bl2;
        }
        return bl;
    }

    @Override
    @NotNull
    public TestCoroutineScheduler getTestScheduler() {
        CoroutineContext.Element element = this.getCoroutineContext().get((CoroutineContext.Key)TestCoroutineScheduler.Key);
        Intrinsics.checkNotNull((Object)element);
        return (TestCoroutineScheduler)element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanupTestCoroutines() {
        boolean bl;
        DelayController delayController;
        CoroutineContext $this$delayController$iv = this.getCoroutineContext();
        boolean $i$f$getDelayController = false;
        ContinuationInterceptor handler$iv = (ContinuationInterceptor)$this$delayController$iv.get((CoroutineContext.Key)ContinuationInterceptor.Key);
        DelayController delayController2 = delayController = handler$iv instanceof DelayController ? (DelayController)handler$iv : null;
        if (delayController != null) {
            try {
                delayController.cleanupTestCoroutines();
                $i$f$getDelayController = false;
            }
            catch (UncompletedCoroutinesError e) {
                $i$f$getDelayController = true;
            }
            bl = $i$f$getDelayController;
        } else {
            this.getTestScheduler().runCurrent();
            bl = !this.getTestScheduler().isIdle$kotlinx_coroutines_test(false);
        }
        boolean hasUnfinishedJobs = bl;
        CoroutineContext.Element e = this.getCoroutineContext().get((CoroutineContext.Key)CoroutineExceptionHandler.Key);
        UncaughtExceptionCaptor uncaughtExceptionCaptor = e instanceof UncaughtExceptionCaptor ? (UncaughtExceptionCaptor)e : null;
        if (uncaughtExceptionCaptor != null) {
            uncaughtExceptionCaptor.cleanupTestCoroutines();
        }
        Object lock$iv = this.lock;
        boolean $i$f$synchronized = false;
        Object object = lock$iv;
        synchronized (object) {
            boolean $i$a$-synchronized-TestCoroutineScopeImpl$cleanupTestCoroutines$22 = false;
            if (this.cleanedUp) {
                throw new IllegalStateException("Attempting to clean up a test coroutine scope more than once.");
            }
            this.cleanedUp = true;
            Unit $i$a$-synchronized-TestCoroutineScopeImpl$cleanupTestCoroutines$22 = Unit.INSTANCE;
        }
        lock$iv = (Throwable)CollectionsKt.firstOrNull(this.exceptions);
        if (lock$iv != null) {
            Object toThrow = lock$iv;
            boolean bl2 = false;
            Iterable $this$forEach$iv = CollectionsKt.drop((Iterable)this.exceptions, (int)1);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Throwable it = (Throwable)element$iv;
                boolean bl3 = false;
                ExceptionsKt.addSuppressed((Throwable)toThrow, (Throwable)it);
            }
            throw toThrow;
        }
        if (hasUnfinishedJobs) {
            throw new UncompletedCoroutinesError("Unfinished coroutines during teardown. Ensure all coroutines are completed or cancelled by your test.");
        }
        Set<Job> jobs = TestCoroutineScopeKt.activeJobs(this.getCoroutineContext());
        if (!((Collection)SetsKt.minus(jobs, (Iterable)this.initialJobs)).isEmpty()) {
            throw new UncompletedCoroutinesError("Test finished with active jobs: " + jobs);
        }
    }
}

