/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.artifactory.client.model;

public enum Privilege {
    ADMIN("m"),
    DELETE("d"),
    DEPLOY("w"),
    ANNOTATE("n"),
    READ("r");

    private String abbreviation;

    private Privilege(String abbreviation) {
        this.abbreviation = abbreviation;
    }

    public String getAbbreviation() {
        return this.abbreviation;
    }

    public static Privilege fromAbbreviation(String abbreviation) {
        for (Privilege privilege : Privilege.values()) {
            if (!privilege.abbreviation.equals(abbreviation)) continue;
            return privilege;
        }
        throw new IllegalArgumentException("No Privilege for " + abbreviation + " found.");
    }
}

