/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.artifactory.client;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.ssl.SSLContextBuilder;
import org.jfrog.artifactory.client.Artifactory;
import org.jfrog.artifactory.client.httpClient.http.ProxyConfig;
import org.jfrog.artifactory.client.impl.ArtifactoryImpl;
import org.jfrog.artifactory.client.impl.util.ArtifactoryHttpClient;

public class ArtifactoryClientBuilder {
    private final List<HttpRequestInterceptor> requestInterceptorList = new ArrayList<HttpRequestInterceptor>();
    private String url;
    private String username;
    private String password;
    private Integer connectionTimeout;
    private Integer socketTimeout;
    private ProxyConfig proxy;
    private String userAgent;
    private boolean ignoreSSLIssues;
    private SSLContext sslContext;
    private SSLContextBuilder sslContextBuilder;
    private String accessToken;
    private HttpProcessor httpProcessor;
    private String noProxyHosts;

    protected ArtifactoryClientBuilder() {
    }

    public static ArtifactoryClientBuilder create() {
        return new ArtifactoryClientBuilder();
    }

    public ArtifactoryClientBuilder setUrl(String url) {
        if (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        this.url = url;
        return this;
    }

    public ArtifactoryClientBuilder setUsername(String username) {
        this.username = username;
        return this;
    }

    public ArtifactoryClientBuilder setPassword(String password) {
        this.password = password;
        return this;
    }

    public ArtifactoryClientBuilder setConnectionTimeout(Integer connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        return this;
    }

    public ArtifactoryClientBuilder setSocketTimeout(Integer socketTimeout) {
        this.socketTimeout = socketTimeout;
        return this;
    }

    public ArtifactoryClientBuilder setProxy(ProxyConfig proxy) {
        this.proxy = proxy;
        return this;
    }

    public ArtifactoryClientBuilder setUserAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    public ArtifactoryClientBuilder setIgnoreSSLIssues(boolean ignoreSSLIssues) {
        this.ignoreSSLIssues = ignoreSSLIssues;
        return this;
    }

    public ArtifactoryClientBuilder setSslContextBuilder(SSLContextBuilder sslContextBuilder) {
        this.sslContextBuilder = sslContextBuilder;
        return this;
    }

    public ArtifactoryClientBuilder setSslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
        return this;
    }

    public ArtifactoryClientBuilder setAccessToken(String accessToken) {
        this.accessToken = accessToken;
        return this;
    }

    public ArtifactoryClientBuilder setHttpProcessor(HttpProcessor httpProcessor) {
        this.httpProcessor = httpProcessor;
        return this;
    }

    public ArtifactoryClientBuilder setNoProxyHosts(String noProxyHosts) {
        this.noProxyHosts = noProxyHosts;
        return this;
    }

    public ArtifactoryClientBuilder addInterceptorLast(HttpRequestInterceptor httpRequestInterceptor) {
        this.requestInterceptorList.add(httpRequestInterceptor);
        return this;
    }

    private CloseableHttpClient createClientBuilder(URI uri) {
        ArtifactoryHttpClient artifactoryHttpClient = new ArtifactoryHttpClient();
        artifactoryHttpClient.hostFromUrl(uri.toString());
        if (StringUtils.isEmpty((CharSequence)this.accessToken)) {
            artifactoryHttpClient.authentication(this.username, this.password);
        }
        artifactoryHttpClient.proxy(this.proxy);
        artifactoryHttpClient.userAgent(this.userAgent);
        if (this.connectionTimeout != null) {
            artifactoryHttpClient.connectionTimeout(this.connectionTimeout);
        }
        if (this.socketTimeout != null) {
            artifactoryHttpClient.socketTimeout(this.socketTimeout);
        }
        if (this.sslContext != null) {
            artifactoryHttpClient.sslContext(this.sslContext);
        } else if (this.sslContextBuilder != null) {
            artifactoryHttpClient.sslContextBuilder(this.sslContextBuilder);
        } else {
            artifactoryHttpClient.trustSelfSignCert(!this.ignoreSSLIssues);
        }
        for (HttpRequestInterceptor httpRequestInterceptor : this.requestInterceptorList) {
            artifactoryHttpClient.addInterceptorLast(httpRequestInterceptor);
        }
        artifactoryHttpClient.addInterceptorFirst((HttpRequestInterceptor)this.httpProcessor);
        artifactoryHttpClient.addInterceptorLast((HttpResponseInterceptor)this.httpProcessor);
        artifactoryHttpClient.noProxyHosts(this.noProxyHosts);
        return artifactoryHttpClient.build();
    }

    public Artifactory build() {
        URI uri;
        try {
            uri = new URIBuilder(this.url).build();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid Artifactory URL: " + this.url + ".", e);
        }
        if (this.sslContext != null && this.ignoreSSLIssues) {
            throw new IllegalStateException("SslContext can't be set with ignoreSSLIssues=true.");
        }
        if (StringUtils.isBlank((CharSequence)this.userAgent)) {
            try {
                this.userAgent = ArtifactoryClientBuilder.getUserAgent();
            }
            catch (IOException e) {
                this.userAgent = "artifactory-client-java";
            }
        }
        CloseableHttpClient closeableHttpClient = this.createClientBuilder(uri);
        return new ArtifactoryImpl(closeableHttpClient, this.url, this.userAgent, this.username, this.accessToken);
    }

    private static String getUserAgent() throws IOException {
        Properties prop = new Properties();
        URL resource = ArtifactoryClientBuilder.class.getClassLoader().getResource("artifactory.client.release.properties");
        if (resource != null) {
            InputStream propStream = resource.openStream();
            prop.load(propStream);
            return "artifactory-client-java/" + prop.getProperty("version");
        }
        return "";
    }

    public ProxyConfig getProxy() {
        return this.proxy;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public Integer getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public Integer getSocketTimeout() {
        return this.socketTimeout;
    }

    public boolean isIgnoreSSLIssues() {
        return this.ignoreSSLIssues;
    }

    public SSLContextBuilder getSslContextBuilder() {
        return this.sslContextBuilder;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public HttpProcessor getHttpProcessor() {
        return this.httpProcessor;
    }

    public String getNoProxyHosts() {
        return this.noProxyHosts;
    }
}

