/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.artifactory.client.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;
import org.jfrog.artifactory.client.ArtifactoryResponse;
import org.jfrog.artifactory.client.impl.AbstractArtifactoryResponseImpl;
import org.jfrog.artifactory.client.impl.util.Util;

public class ArtifactoryResponseImpl
extends AbstractArtifactoryResponseImpl
implements ArtifactoryResponse {
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private String rawBody;

    ArtifactoryResponseImpl(HttpResponse httpResponse) throws IOException {
        super(httpResponse);
        HttpEntity entity = httpResponse.getEntity();
        if (entity != null) {
            try {
                this.rawBody = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            }
            catch (IOException e) {
                throw new IOException("Failed reading from response stream.");
            }
            finally {
                EntityUtils.consumeQuietly((HttpEntity)entity);
            }
        }
    }

    public String getRawBody() {
        return this.rawBody;
    }

    public <T> T parseBody(Class<T> toType) throws IOException {
        Util.configureObjectMapper(objectMapper);
        try {
            return (T)objectMapper.readValue(this.rawBody, toType);
        }
        catch (IOException e) {
            throw new IOException("Failed casting response entity to " + toType.toString() + ". response status: " + this.getStatusLine().toString() + ". raw entity: " + this.rawBody, e);
        }
    }

    public boolean isSuccessResponse() {
        int status = this.getStatusLine().getStatusCode();
        return status >= 200 && status < 300;
    }
}

