/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.artifactory.client.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.jfrog.artifactory.client.Artifactory;
import org.jfrog.artifactory.client.DownloadableArtifact;
import org.jfrog.artifactory.client.impl.ArtifactBase;

public class DownloadableArtifactImpl
extends ArtifactBase<DownloadableArtifact>
implements DownloadableArtifact {
    private HashMap<String, Object[]> mandatoryProps = new HashMap();
    private Artifactory artifactory;
    private String path;

    DownloadableArtifactImpl(String repo, String path, Artifactory artifactory) {
        super(repo);
        this.artifactory = artifactory;
        this.path = path;
    }

    public InputStream doDownload() throws IOException {
        String uri = this.generateUriWithParams();
        return this.artifactory.getInputStream(uri);
    }

    public InputStream doDownloadWithHeaders(Map<String, String> headers) throws IOException {
        String uri = this.generateUriWithParams();
        return this.artifactory.getInputStreamWithHeaders(uri, headers);
    }

    private String generateUriWithParams() {
        String params = this.parseParams(this.props, "=") + this.parseParams(this.mandatoryProps, "+=");
        if (params.length() > 0) {
            params = ";" + params;
        }
        return String.format("/%s/%s%s", this.repo, this.path, params);
    }

    public DownloadableArtifact withProperty(String name, Object ... values) {
        super.withProperty(name, values);
        return this;
    }

    public DownloadableArtifact withProperty(String name, Object value) {
        super.withProperty(name, value);
        return this;
    }

    public DownloadableArtifact withMandatoryProperty(String name, Object ... values) {
        this.mandatoryProps.put(name, values);
        return this;
    }

    public DownloadableArtifact withMandatoryProperty(String name, Object value) {
        this.mandatoryProps.put(name, new Object[]{value});
        return this;
    }
}

