/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.artifactory.client.model.impl;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jfrog.artifactory.client.model.ContentSync;
import org.jfrog.artifactory.client.model.PackageType;
import org.jfrog.artifactory.client.model.RemoteRepository;
import org.jfrog.artifactory.client.model.RepositoryType;
import org.jfrog.artifactory.client.model.builder.RemoteRepositoryBuilder;
import org.jfrog.artifactory.client.model.impl.NonVirtualRepositoryBuilderBase;
import org.jfrog.artifactory.client.model.impl.PackageTypeImpl;
import org.jfrog.artifactory.client.model.impl.RemoteRepositoryImpl;
import org.jfrog.artifactory.client.model.impl.RepositoryTypeImpl;

public class RemoteRepositoryBuilderImpl
extends NonVirtualRepositoryBuilderBase<RemoteRepositoryBuilder, RemoteRepository>
implements RemoteRepositoryBuilder {
    private static Set<PackageType> remoteRepositorySupportedTypes = new HashSet<PackageTypeImpl>(Arrays.asList(PackageTypeImpl.bower, PackageTypeImpl.cocoapods, PackageTypeImpl.cran, PackageTypeImpl.conda, PackageTypeImpl.debian, PackageTypeImpl.docker, PackageTypeImpl.gems, PackageTypeImpl.generic, PackageTypeImpl.gitlfs, PackageTypeImpl.gradle, PackageTypeImpl.ivy, PackageTypeImpl.maven, PackageTypeImpl.npm, PackageTypeImpl.nuget, PackageTypeImpl.opkg, PackageTypeImpl.p2, PackageTypeImpl.pypi, PackageTypeImpl.sbt, PackageTypeImpl.vcs, PackageTypeImpl.yum, PackageTypeImpl.rpm, PackageTypeImpl.composer, PackageTypeImpl.conan, PackageTypeImpl.chef, PackageTypeImpl.puppet, PackageTypeImpl.helm, PackageTypeImpl.go, PackageTypeImpl.cargo, PackageTypeImpl.terraform));
    private String url;
    private String username = "";
    private String password;
    private String proxy;
    private boolean hardFail;
    private boolean offline;
    private boolean storeArtifactsLocally = true;
    private int socketTimeoutMillis = 15000;
    private boolean enableCookieManagement = false;
    private boolean bypassHeadRequests = false;
    private boolean allowAnyHostAuth = false;
    private String localAddress = "";
    private int retrievalCachePeriodSecs = 43200;
    private int missedRetrievalCachePeriodSecs = 7200;
    private int failedRetrievalCachePeriodSecs = 30;
    private boolean unusedArtifactsCleanupEnabled;
    private int unusedArtifactsCleanupPeriodHours;
    private boolean shareConfiguration;
    private boolean synchronizeProperties;
    private long assumedOfflinePeriodSecs = 300L;
    private boolean listRemoteFolderItems = true;
    private ContentSync contentSync;
    private String clientTlsCertificate = "";

    protected RemoteRepositoryBuilderImpl() {
        super(remoteRepositorySupportedTypes);
    }

    public RemoteRepositoryBuilder url(String url) {
        this.url = url;
        return this;
    }

    public String getUrl() {
        return this.url;
    }

    public RemoteRepositoryBuilder username(String username) {
        this.username = username;
        return this;
    }

    public String getUsername() {
        return this.username;
    }

    public RemoteRepositoryBuilder password(String password) {
        this.password = password;
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    public RemoteRepositoryBuilder proxy(String proxy) {
        this.proxy = proxy;
        return this;
    }

    public String getProxy() {
        return this.proxy;
    }

    public RemoteRepositoryBuilder hardFail(boolean hardFail) {
        this.hardFail = hardFail;
        return this;
    }

    public boolean isHardFail() {
        return this.hardFail;
    }

    public RemoteRepositoryBuilder offline(boolean offline) {
        this.offline = offline;
        return this;
    }

    public boolean isOffline() {
        return this.offline;
    }

    public RemoteRepositoryBuilder storeArtifactsLocally(boolean storeArtifactsLocally) {
        this.storeArtifactsLocally = storeArtifactsLocally;
        return this;
    }

    public boolean isStoreArtifactsLocally() {
        return this.storeArtifactsLocally;
    }

    public RemoteRepositoryBuilder socketTimeoutMillis(int socketTimeoutMillis) {
        this.socketTimeoutMillis = socketTimeoutMillis;
        return this;
    }

    public int getSocketTimeoutMillis() {
        return this.socketTimeoutMillis;
    }

    public RemoteRepositoryBuilder allowAnyHostAuth(boolean allowAnyHostAuth) {
        this.allowAnyHostAuth = allowAnyHostAuth;
        return this;
    }

    public boolean isAllowAnyHostAuth() {
        return this.allowAnyHostAuth;
    }

    public RemoteRepositoryBuilder enableCookieManagement(boolean cookieManagementEnabled) {
        this.enableCookieManagement = cookieManagementEnabled;
        return this;
    }

    public boolean isEnableCookieManagement() {
        return this.enableCookieManagement;
    }

    public RemoteRepositoryBuilder bypassHeadRequests(boolean bypass) {
        this.bypassHeadRequests = bypass;
        return this;
    }

    public boolean isBypassHeadRequests() {
        return this.bypassHeadRequests;
    }

    public RemoteRepositoryBuilder localAddress(String localAddress) {
        this.localAddress = localAddress;
        return this;
    }

    public String getLocalAddress() {
        return this.localAddress;
    }

    public RemoteRepositoryBuilder retrievalCachePeriodSecs(int retrievalCachePeriodSecs) {
        this.retrievalCachePeriodSecs = retrievalCachePeriodSecs;
        return this;
    }

    public int getRetrievalCachePeriodSecs() {
        return this.retrievalCachePeriodSecs;
    }

    public RemoteRepositoryBuilder missedRetrievalCachePeriodSecs(int missedRetrievalCachePeriodSecs) {
        this.missedRetrievalCachePeriodSecs = missedRetrievalCachePeriodSecs;
        return this;
    }

    public int getMissedRetrievalCachePeriodSecs() {
        return this.missedRetrievalCachePeriodSecs;
    }

    public RemoteRepositoryBuilder failedRetrievalCachePeriodSecs(int failedRetrievalCachePeriodSecs) {
        this.failedRetrievalCachePeriodSecs = failedRetrievalCachePeriodSecs;
        return this;
    }

    public int getFailedRetrievalCachePeriodSecs() {
        return this.failedRetrievalCachePeriodSecs;
    }

    public RemoteRepositoryBuilder unusedArtifactsCleanupEnabled(boolean unusedArtifactsCleanupEnabled) {
        this.unusedArtifactsCleanupEnabled = unusedArtifactsCleanupEnabled;
        return this;
    }

    public boolean isUnusedArtifactsCleanupEnabled() {
        return this.unusedArtifactsCleanupEnabled;
    }

    public RemoteRepositoryBuilder unusedArtifactsCleanupPeriodHours(int unusedArtifactsCleanupPeriodHours) {
        this.unusedArtifactsCleanupPeriodHours = unusedArtifactsCleanupPeriodHours;
        return this;
    }

    public int getUnusedArtifactsCleanupPeriodHours() {
        return this.unusedArtifactsCleanupPeriodHours;
    }

    public RemoteRepositoryBuilder shareConfiguration(boolean shareConfiguration) {
        this.shareConfiguration = shareConfiguration;
        return this;
    }

    public boolean isShareConfiguration() {
        return this.shareConfiguration;
    }

    public RemoteRepositoryBuilder synchronizeProperties(boolean synchronizeProperties) {
        this.synchronizeProperties = synchronizeProperties;
        return this;
    }

    public boolean isSynchronizeProperties() {
        return this.synchronizeProperties;
    }

    public RemoteRepositoryBuilder assumedOfflinePeriodSecs(long assumedOfflinePeriodSecs) {
        this.assumedOfflinePeriodSecs = assumedOfflinePeriodSecs;
        return this;
    }

    public long getAssumedOfflinePeriodSecs() {
        return this.assumedOfflinePeriodSecs;
    }

    public RemoteRepositoryBuilder listRemoteFolderItems(boolean listRemoteFolderItems) {
        this.listRemoteFolderItems = listRemoteFolderItems;
        return this;
    }

    public boolean isListRemoteFolderItems() {
        return this.listRemoteFolderItems;
    }

    public RemoteRepositoryBuilder contentSync(ContentSync contentSync) {
        this.contentSync = contentSync;
        return this;
    }

    public ContentSync getContentSync() {
        return this.contentSync;
    }

    public RemoteRepositoryBuilder clientTlsCertificate(String clientTlsCertificate) {
        this.clientTlsCertificate = clientTlsCertificate;
        return this;
    }

    public String getClientTlsCertificate() {
        return this.clientTlsCertificate;
    }

    public RemoteRepository build() {
        this.validate();
        this.setRepoLayoutFromSettings();
        return new RemoteRepositoryImpl(this.key, this.settings, this.xraySettings, this.contentSync, this.description, this.excludesPattern, this.includesPattern, this.notes, this.blackedOut, this.propertySets, this.failedRetrievalCachePeriodSecs, this.hardFail, this.localAddress, this.missedRetrievalCachePeriodSecs, this.offline, this.password, this.proxy, this.retrievalCachePeriodSecs, this.shareConfiguration, this.socketTimeoutMillis, this.enableCookieManagement, this.allowAnyHostAuth, this.storeArtifactsLocally, this.synchronizeProperties, this.unusedArtifactsCleanupEnabled, this.unusedArtifactsCleanupPeriodHours, this.url, this.username, this.repoLayoutRef, this.assumedOfflinePeriodSecs, this.archiveBrowsingEnabled, this.listRemoteFolderItems, this.clientTlsCertificate, this.customProperties, this.bypassHeadRequests);
    }

    @Override
    public RepositoryType getRepositoryType() {
        return RepositoryTypeImpl.REMOTE;
    }
}

