/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.artifactory.client.model.impl;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Map;
import org.jfrog.artifactory.client.model.Repository;
import org.jfrog.artifactory.client.model.repository.settings.RepositorySettings;
import org.jfrog.artifactory.client.model.repository.settings.XraySettings;

public abstract class RepositoryBase
implements Repository {
    private String key;
    private String description;
    private String notes;
    private String includesPattern;
    private String excludesPattern;
    protected String repoLayoutRef;
    @JsonIgnore
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    protected RepositorySettings settings;
    @JsonIgnore
    protected XraySettings xraySettings;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    protected Map<String, Object> customProperties;

    protected RepositoryBase() {
    }

    protected RepositoryBase(String key, RepositorySettings settings, XraySettings xraySettings, String description, String excludesPattern, String includesPattern, String notes, String repoLayoutRef, Map<String, Object> customProperties) {
        this.key = key;
        this.settings = settings;
        this.xraySettings = xraySettings;
        this.description = description;
        this.excludesPattern = excludesPattern;
        this.includesPattern = includesPattern;
        this.notes = notes;
        this.repoLayoutRef = repoLayoutRef;
        this.customProperties = customProperties;
    }

    protected RepositoryBase(String key, RepositorySettings settings, String description, String excludesPattern, String includesPattern, String notes, String repoLayoutRef, Map<String, Object> customProperties) {
        this(key, settings, null, description, excludesPattern, includesPattern, notes, repoLayoutRef, customProperties);
    }

    public String getKey() {
        return this.key;
    }

    private void setKey(String key) {
        this.key = key;
    }

    public String getDescription() {
        return this.description;
    }

    private void setDescription(String description) {
        this.description = description;
    }

    public String getNotes() {
        return this.notes;
    }

    private void setNotes(String notes) {
        this.notes = notes;
    }

    public String getIncludesPattern() {
        return this.includesPattern;
    }

    private void setIncludesPattern(String includesPattern) {
        this.includesPattern = includesPattern;
    }

    public String getExcludesPattern() {
        return this.excludesPattern;
    }

    private void setExcludesPattern(String excludesPattern) {
        this.excludesPattern = excludesPattern;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RepositoryBase that = (RepositoryBase)o;
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (this.excludesPattern != null ? !this.excludesPattern.equals(that.excludesPattern) : that.excludesPattern != null) {
            return false;
        }
        if (this.includesPattern != null ? !this.includesPattern.equals(that.includesPattern) : that.includesPattern != null) {
            return false;
        }
        if (this.key != null ? !this.key.equals(that.key) : that.key != null) {
            return false;
        }
        if (this.notes != null ? !this.notes.equals(that.notes) : that.notes != null) {
            return false;
        }
        if (this.getRclass() != that.getRclass()) {
            return false;
        }
        if (this.settings != null ? !this.settings.equals(that.settings) : that.settings != null) {
            return false;
        }
        return !(this.xraySettings != null ? !this.xraySettings.equals(that.xraySettings) : that.xraySettings != null);
    }

    public int hashCode() {
        int result = this.key != null ? this.key.hashCode() : 0;
        result = 31 * result + (this.getRclass() != null ? this.getRclass().hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.notes != null ? this.notes.hashCode() : 0);
        result = 31 * result + (this.includesPattern != null ? this.includesPattern.hashCode() : 0);
        result = 31 * result + (this.excludesPattern != null ? this.excludesPattern.hashCode() : 0);
        result = 31 * result + (this.settings != null ? this.settings.hashCode() : 0);
        result = 31 * result + (this.xraySettings != null ? this.xraySettings.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Repository{description='" + this.description + '\'' + ", key='" + this.key + '\'' + ", rclass=" + this.getRclass() + ", notes='" + this.notes + '\'' + ", includesPattern='" + this.includesPattern + '\'' + ", excludesPattern='" + this.excludesPattern + '\'' + '}';
    }

    public String getRepoLayoutRef() {
        return this.repoLayoutRef;
    }

    private void setRepoLayoutRef(String repoLayoutRef) {
        this.repoLayoutRef = repoLayoutRef;
    }

    public RepositorySettings getRepositorySettings() {
        return this.settings;
    }

    public void setRepositorySettings(RepositorySettings settings) {
        this.settings = settings;
    }

    public XraySettings getXraySettings() {
        return this.xraySettings;
    }

    public void setXraySettings(XraySettings xraySettings) {
        this.xraySettings = xraySettings;
    }

    @JsonAnyGetter
    public Map<String, Object> getCustomProperties() {
        return this.customProperties;
    }
}

