/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.artifactory.client.model.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jfrog.artifactory.client.model.PackageType;
import org.jfrog.artifactory.client.model.RepositoryType;
import org.jfrog.artifactory.client.model.VirtualRepository;
import org.jfrog.artifactory.client.model.builder.VirtualRepositoryBuilder;
import org.jfrog.artifactory.client.model.impl.PackageTypeImpl;
import org.jfrog.artifactory.client.model.impl.RepositoryBuilderBase;
import org.jfrog.artifactory.client.model.impl.RepositoryTypeImpl;
import org.jfrog.artifactory.client.model.impl.VirtualRepositoryImpl;

public class VirtualRepositoryBuilderImpl
extends RepositoryBuilderBase<VirtualRepositoryBuilder, VirtualRepository>
implements VirtualRepositoryBuilder {
    private static Set<PackageType> virtualRepositorySupportedTypes = new HashSet<PackageTypeImpl>(Arrays.asList(PackageTypeImpl.bower, PackageTypeImpl.cran, PackageTypeImpl.conda, PackageTypeImpl.docker, PackageTypeImpl.debian, PackageTypeImpl.gems, PackageTypeImpl.generic, PackageTypeImpl.gitlfs, PackageTypeImpl.gradle, PackageTypeImpl.ivy, PackageTypeImpl.maven, PackageTypeImpl.npm, PackageTypeImpl.nuget, PackageTypeImpl.p2, PackageTypeImpl.pypi, PackageTypeImpl.sbt, PackageTypeImpl.yum, PackageTypeImpl.rpm, PackageTypeImpl.composer, PackageTypeImpl.conan, PackageTypeImpl.chef, PackageTypeImpl.puppet, PackageTypeImpl.helm, PackageTypeImpl.go, PackageTypeImpl.terraform));
    private Collection<String> repositories = Collections.emptyList();
    private boolean artifactoryRequestsCanRetrieveRemoteArtifacts;
    private String defaultDeploymentRepo;

    protected VirtualRepositoryBuilderImpl() {
        super(virtualRepositorySupportedTypes);
    }

    public VirtualRepositoryBuilder repositories(Collection<String> repositories) {
        this.repositories = repositories;
        return this;
    }

    public Collection<String> getRepositories() {
        return this.repositories;
    }

    public VirtualRepositoryBuilder artifactoryRequestsCanRetrieveRemoteArtifacts(boolean artifactoryRequestsCanRetrieveRemoteArtifacts) {
        this.artifactoryRequestsCanRetrieveRemoteArtifacts = artifactoryRequestsCanRetrieveRemoteArtifacts;
        return this;
    }

    public boolean isArtifactoryRequestsCanRetrieveRemoteArtifacts() {
        return this.artifactoryRequestsCanRetrieveRemoteArtifacts;
    }

    public VirtualRepositoryBuilder defaultDeploymentRepo(String deploymentRepo) {
        this.defaultDeploymentRepo = deploymentRepo;
        return this;
    }

    public String getDefaultDeploymentRepo() {
        return this.defaultDeploymentRepo;
    }

    public VirtualRepository build() {
        this.validate();
        this.setRepoLayoutFromSettings();
        return new VirtualRepositoryImpl(this.key, this.settings, this.description, this.excludesPattern, this.includesPattern, this.notes, this.artifactoryRequestsCanRetrieveRemoteArtifacts, this.repositories, this.repoLayoutRef, this.defaultDeploymentRepo, this.customProperties);
    }

    @Override
    public RepositoryType getRepositoryType() {
        return RepositoryTypeImpl.VIRTUAL;
    }
}

