/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.artifactory.client.model.impl;

import java.util.List;
import java.util.Map;
import org.jfrog.artifactory.client.model.NonVirtualRepository;
import org.jfrog.artifactory.client.model.impl.RepositoryBase;
import org.jfrog.artifactory.client.model.repository.settings.RepositorySettings;
import org.jfrog.artifactory.client.model.repository.settings.XraySettings;

public abstract class NonVirtualRepositoryBase
extends RepositoryBase
implements NonVirtualRepository,
XraySettings {
    private boolean blackedOut;
    private List<String> propertySets;
    protected boolean archiveBrowsingEnabled;

    protected NonVirtualRepositoryBase() {
    }

    protected NonVirtualRepositoryBase(String key, RepositorySettings settings, XraySettings xraySettings, String description, String excludesPattern, String includesPattern, String notes, boolean blackedOut, List<String> propertySets, String repoLayoutRef, boolean archiveBrowsingEnabled, Map customProperties) {
        super(key, settings, xraySettings, description, excludesPattern, includesPattern, notes, repoLayoutRef, customProperties);
        this.blackedOut = blackedOut;
        this.propertySets = propertySets;
        this.archiveBrowsingEnabled = archiveBrowsingEnabled;
    }

    public boolean isBlackedOut() {
        return this.blackedOut;
    }

    private void setBlackedOut(boolean blackedOut) {
        this.blackedOut = blackedOut;
    }

    public List<String> getPropertySets() {
        return this.propertySets;
    }

    private void setPropertySets(List<String> propertySets) {
        this.propertySets = propertySets;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NonVirtualRepositoryBase)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NonVirtualRepositoryBase that = (NonVirtualRepositoryBase)o;
        if (this.blackedOut != that.blackedOut) {
            return false;
        }
        return !(this.propertySets != null ? !this.propertySets.equals(that.propertySets) : that.propertySets != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.blackedOut ? 1 : 0);
        result = 31 * result + (this.propertySets != null ? this.propertySets.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "NonVirtualRepositoryBase{blackedOut=" + this.blackedOut + ", propertySets=" + this.propertySets + '}';
    }

    public boolean isArchiveBrowsingEnabled() {
        return this.archiveBrowsingEnabled;
    }

    private void setArchiveBrowsingEnabled(boolean archiveBrowsingEnabled) {
        this.archiveBrowsingEnabled = archiveBrowsingEnabled;
    }

    public Boolean getXrayIndex() {
        if (this.xraySettings != null) {
            return this.xraySettings.getXrayIndex();
        }
        return null;
    }

    public void setXrayIndex(Boolean xrayIndex) {
        if (this.xraySettings != null) {
            this.xraySettings.setXrayIndex(xrayIndex);
        }
    }
}

