/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.artifactory.client.model.impl;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.List;
import org.jfrog.artifactory.client.model.RepositoryType;
import org.jfrog.artifactory.client.model.impl.FederatedRepositoryImpl;
import org.jfrog.artifactory.client.model.impl.LocalRepositoryImpl;
import org.jfrog.artifactory.client.model.impl.RemoteRepositoryImpl;
import org.jfrog.artifactory.client.model.impl.RepositoryBase;
import org.jfrog.artifactory.client.model.impl.VirtualRepositoryImpl;

public enum RepositoryTypeImpl implements RepositoryType
{
    LOCAL(LocalRepositoryImpl.class, (TypeReference)new TypeReference<List<LocalRepositoryImpl>>(){}),
    FEDERATED(FederatedRepositoryImpl.class, (TypeReference)new TypeReference<List<FederatedRepositoryImpl>>(){}),
    REMOTE(RemoteRepositoryImpl.class, (TypeReference)new TypeReference<List<RemoteRepositoryImpl>>(){}),
    VIRTUAL(VirtualRepositoryImpl.class, (TypeReference)new TypeReference<List<VirtualRepositoryImpl>>(){});

    private final TypeReference typeReference;
    private final Class<? extends RepositoryBase> typeClass;

    private RepositoryTypeImpl(Class<? extends RepositoryBase> typeClass, TypeReference typeReference) {
        this.typeClass = typeClass;
        this.typeReference = typeReference;
    }

    public Class<? extends RepositoryBase> getTypeClass() {
        return this.typeClass;
    }

    private TypeReference getTypeReference() {
        return this.typeReference;
    }

    @JsonCreator
    public static RepositoryTypeImpl parseString(String typeName) {
        return RepositoryTypeImpl.valueOf(typeName.toUpperCase());
    }

    @JsonValue
    public String toString() {
        return super.toString().toLowerCase();
    }
}

