/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.natives.compiler;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.codehaus.mojo.natives.AbstractExecutor;
import org.codehaus.mojo.natives.NativeBuildException;
import org.codehaus.mojo.natives.SourceDependencyAnalyzer;
import org.codehaus.mojo.natives.compiler.Compiler;
import org.codehaus.mojo.natives.compiler.CompilerConfiguration;
import org.codehaus.mojo.natives.parser.Parser;
import org.codehaus.mojo.natives.util.CommandLineUtil;
import org.codehaus.mojo.natives.util.EnvUtil;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.Os;
import org.codehaus.plexus.util.cli.Commandline;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCompiler
extends AbstractExecutor
implements Compiler {
    protected abstract Parser getParser();

    protected abstract Commandline getCommandLine(File var1, File var2, CompilerConfiguration var3) throws NativeBuildException;

    @Override
    public List<File> compile(CompilerConfiguration config, List<File> sourceFiles) throws NativeBuildException {
        if (config.getNbParallelCompilation() > 1) {
            return this.compileMultiThread(config, sourceFiles);
        }
        return this.compileOneThread(config, sourceFiles);
    }

    private List<File> compileOneThread(CompilerConfiguration config, List<File> sourceFiles) throws NativeBuildException {
        ArrayList<File> compilerOutputFiles = new ArrayList<File>(sourceFiles.size());
        for (File source : sourceFiles) {
            File objectFile = AbstractCompiler.getObjectFile(source, config.getOutputDirectory(), config.getObjectFileExtension());
            CompileRunnable runnable = new CompileRunnable(source, objectFile, config);
            runnable.run();
            runnable.testException();
            compilerOutputFiles.add(objectFile);
        }
        return compilerOutputFiles;
    }

    private List<File> compileMultiThread(CompilerConfiguration config, List<File> sourceFiles) throws NativeBuildException {
        int i;
        List<CompileRunnable> runned = Collections.synchronizedList(new ArrayList());
        LinkedBlockingQueue<CompileRunnable> toRun = new LinkedBlockingQueue<CompileRunnable>();
        Thread[] threads = new Thread[Math.min(config.getNbParallelCompilation(), sourceFiles.size())];
        for (int i2 = 0; i2 < threads.length; ++i2) {
            threads[i2] = new CompileThread("CompileThread" + i2, toRun);
            threads[i2].start();
        }
        for (File source : sourceFiles) {
            File objectFile = AbstractCompiler.getObjectFile(source, config.getOutputDirectory(), config.getObjectFileExtension());
            CompileRunnable runnable = new CompileRunnable(source, objectFile, config);
            toRun.add(runnable);
            runned.add(runnable);
        }
        CompileRunnable endOfWork = new CompileRunnable(null, null, null);
        for (i = 0; i < threads.length; ++i) {
            toRun.add(endOfWork);
        }
        for (i = 0; i < threads.length; ++i) {
            Thread thread = threads[i];
            try {
                thread.join();
                continue;
            }
            catch (InterruptedException e) {
                throw new NativeBuildException("Error waiting for thread", e);
            }
        }
        ArrayList<File> compilerOutputFiles = new ArrayList<File>(sourceFiles.size());
        for (CompileRunnable compileRunnable : runned) {
            compileRunnable.testException();
            compilerOutputFiles.add(compileRunnable.getObjectFile());
        }
        return compilerOutputFiles;
    }

    protected static String getObjectFileExtension(String fileExtension) {
        if (fileExtension != null) {
            return fileExtension;
        }
        if (Os.isFamily((String)"windows")) {
            return "obj";
        }
        return "o";
    }

    protected static File getObjectFile(File sourceFile, File outputDirectory, String objectFileExtension) throws NativeBuildException {
        String objectFileName;
        try {
            objectFileExtension = AbstractCompiler.getObjectFileExtension(objectFileExtension);
            objectFileName = FileUtils.basename((String)sourceFile.getCanonicalPath());
            objectFileName = objectFileName.charAt(objectFileName.length() - 1) != '.' ? objectFileName + "." + objectFileExtension : objectFileName + objectFileExtension;
        }
        catch (IOException e) {
            throw new NativeBuildException(e.getMessage());
        }
        return new File(outputDirectory, objectFileName);
    }

    private class CompileRunnable
    implements Runnable {
        private final File source;
        private final File objectFile;
        private final CompilerConfiguration config;
        private Exception exception = null;

        public CompileRunnable(File source, File objectFile, CompilerConfiguration config) {
            this.source = source;
            this.objectFile = objectFile;
            this.config = config;
        }

        public boolean isEndOfWork() {
            return this.source == null;
        }

        public void run() {
            try {
                boolean upToDate;
                if (this.config.getUpToDateAnalyzer() != null) {
                    upToDate = this.config.getUpToDateAnalyzer().isUpToDate(this.objectFile, this.source);
                } else {
                    Parser parser = AbstractCompiler.this.getParser();
                    boolean bl = upToDate = !SourceDependencyAnalyzer.isStaled(this.source, this.objectFile, parser, this.config.getIncludePaths());
                }
                if (!upToDate) {
                    Commandline cl = AbstractCompiler.this.getCommandLine(this.source, this.objectFile, this.config);
                    EnvUtil.setupCommandlineEnv(cl, this.config.getEnvFactoryName());
                    EnvUtil.setupCommandlineEnv(cl, this.config.getSystemProperties());
                    CommandLineUtil.execute(cl, AbstractCompiler.this.getLogger());
                } else {
                    AbstractCompiler.this.getLogger().debug(this.objectFile + " is up to date.");
                }
            }
            catch (Exception e) {
                AbstractCompiler.this.getLogger().error("Error compiling " + this.source + " :" + e.getMessage(), (Throwable)e);
                this.exception = e;
            }
        }

        public Exception getException() {
            return this.exception;
        }

        public File getObjectFile() {
            return this.objectFile;
        }

        public void testException() throws NativeBuildException {
            if (this.exception != null) {
                if (this.exception instanceof NativeBuildException) {
                    throw (NativeBuildException)this.exception;
                }
                throw new NativeBuildException("Received unkown exceptionm during compilation of " + this.objectFile, this.exception);
            }
            if (!this.objectFile.exists()) {
                throw new NativeBuildException("Internal error: " + this.objectFile + " not found after successfull compilation.");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CompileThread
    extends Thread {
        private final BlockingQueue<CompileRunnable> toRun;

        public CompileThread(String name, BlockingQueue<CompileRunnable> toRun) {
            super(name);
            this.toRun = toRun;
        }

        @Override
        public void run() {
            try {
                CompileRunnable compileRunnable;
                while (!(compileRunnable = this.toRun.take()).isEndOfWork()) {
                    compileRunnable.run();
                }
            }
            catch (InterruptedException e) {
            }
        }
    }
}

