/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.natives.util;

import java.io.File;
import java.io.IOException;
import org.codehaus.plexus.util.StringUtils;

public class FileUtil {
    public static String getRelativePath(String base, File targetFile) {
        try {
            String prefix2;
            int endPrefix;
            String prefix1;
            String canonicalTarget;
            String canonicalBase = base;
            if (base.charAt(base.length() - 1) == File.separatorChar) {
                canonicalBase = base.substring(0, base.length() - 1);
            }
            if ((canonicalTarget = System.getProperty("os.name").equals("OS/400") ? targetFile.getPath() : targetFile.getCanonicalPath()).charAt(canonicalTarget.length() - 1) == File.separatorChar) {
                canonicalTarget = canonicalTarget.substring(0, canonicalTarget.length() - 1);
            }
            if (canonicalTarget.equals(canonicalBase)) {
                return ".";
            }
            if (canonicalBase.substring(0, 2).equals("\\\\") ? !(prefix1 = canonicalBase.substring(0, endPrefix = canonicalBase.indexOf(92, 2))).equals(prefix2 = canonicalTarget.substring(0, endPrefix)) : (canonicalBase.substring(1, 3).equals(":\\") ? !(prefix1 = canonicalBase.substring(0, endPrefix = 2)).equals(prefix2 = canonicalTarget.substring(0, endPrefix)) : canonicalBase.charAt(0) == '/' && canonicalTarget.charAt(0) != '/')) {
                return canonicalTarget;
            }
            char separator = File.separatorChar;
            int lastSeparator = -1;
            int minLength = canonicalBase.length();
            if (canonicalTarget.length() < minLength) {
                minLength = canonicalTarget.length();
            }
            int firstDifference = minLength + 1;
            for (int i = 0; i < minLength; ++i) {
                if (canonicalTarget.charAt(i) == canonicalBase.charAt(i)) {
                    if (canonicalTarget.charAt(i) != separator) continue;
                    lastSeparator = i;
                    continue;
                }
                firstDifference = lastSeparator + 1;
                break;
            }
            StringBuffer relativePath = new StringBuffer(50);
            if (canonicalBase.length() > firstDifference) {
                relativePath.append("..");
                for (int i = firstDifference; i < canonicalBase.length(); ++i) {
                    if (canonicalBase.charAt(i) != separator) continue;
                    relativePath.append(separator);
                    relativePath.append("..");
                }
            }
            if (canonicalTarget.length() > firstDifference) {
                if (relativePath.length() > 0) {
                    relativePath.append(separator);
                }
                relativePath.append(canonicalTarget.substring(firstDifference));
            }
            return relativePath.toString();
        }
        catch (IOException iOException) {
            return targetFile.toString();
        }
    }

    public static File[] breakPaths(String paths) {
        String[] tokens = StringUtils.split((String)paths, (String)",");
        File[] files = new File[tokens.length];
        for (int i = 0; i < tokens.length; ++i) {
            files[i] = new File(tokens[i]);
        }
        return files;
    }
}

