package org.jfrog.jade.plugins.common.deploy;

/*
 * Copyright 2005-2006 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * @author Fred Simon
 */
public class Deployment {
    private String type;

    private String fileName;

    private String classifier;

    private String extension;

    public Deployment(String type, String fileName, String classifier, String extension) {
        this.type = type;
        this.fileName = fileName;
        this.classifier = classifier;
        this.extension = extension;
    }

    public Deployment(String type, String fileName) {
        this.type = type;
        this.fileName = fileName;
        this.classifier = type;
        this.extension = "jar";
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getFileName() {
        return fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getClassifier() {
        return classifier;
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    public String getExtension() {
        return extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }
}
