package org.jfrog.jade.plugins.common.deploy;

/*
 * Copyright 2005-2006 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import com.thoughtworks.xstream.XStream;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.jfrog.jade.plugins.common.injectable.MvnInjectable;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

/**
 * @author Fred Simon
 */
public class DeploymentHelper {
    public static final String CLASSIFIER = "deployments";

    public static final String TYPE = "xml";

    public static void saveDeployments(MvnInjectable injectable, ProjectDeployments projectDeployments) throws IOException {
        XStream xStream = getXStream();
        File deploymentsFile = new File(injectable.getProject().getBuild().getDirectory(), CLASSIFIER + "." + TYPE);
        xStream.toXML(projectDeployments, new FileWriter(deploymentsFile));
        injectable.getProjectHelper().attachArtifact(injectable.getProject(), TYPE, CLASSIFIER, deploymentsFile);
    }

    public static ProjectDeployments getDeployments(MvnInjectable injectable, Artifact dependency) throws IOException {
        // TODO: Find a way to know that there is no deployment
        ArtifactFactory artifactFactory = injectable.getArtifactFactory();
        if (artifactFactory == null) {
            throw new IOException("The MvnInjectable " + injectable + " has no artifact Factory");
        }
        Artifact deploymentsArtifact = artifactFactory.createArtifactWithClassifier(
                dependency.getGroupId(),
                dependency.getArtifactId(),
                dependency.getVersion(),
                TYPE,
                CLASSIFIER);
        try {
            injectable.getArtifactResolver().resolve(deploymentsArtifact,
                    injectable.getProject().getRemoteArtifactRepositories(),
                    injectable.getLocalRepository());
        } catch (ArtifactResolutionException e) {
            injectable.getLog().error(e);
            return null;
        } catch (ArtifactNotFoundException e) {
            injectable.getLog().error(e);
            return null;
        }
        File deploymentsFile = deploymentsArtifact.getFile();
        return (ProjectDeployments) getXStream().fromXML(new FileReader(deploymentsFile));
    }

    private static XStream getXStream() {
        XStream xStream = new XStream();
        xStream.alias("deployment", Deployment.class);
        xStream.alias("projectDeployments", ProjectDeployments.class);
        return xStream;
    }

}
