package org.jfrog.jade.plugins.common.injectable;

import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.jfrog.jade.plugins.common.ant.Maven2AntManager;
import org.jfrog.jade.plugins.common.naming.ProjectNameProvider;

import java.util.List;

/**
 * Created by IntelliJ IDEA.
 * User: yoavl
 */
public interface MvnInjectable {
    MavenProject getProject();

    MavenProjectHelper getProjectHelper();

    Log getLog();

    ArtifactRepository getLocalRepository();

    ArtifactResolver getArtifactResolver();

    ArtifactFactory getArtifactFactory();

    Maven2AntManager getMaven2AntManager();

    void updateFromMvnInjectable(MvnInjectable injectable);

    /**
     * @return the plugin dependency artifacts
     */
    List<Artifact> getPluginArtifacts();

    ProjectNameProvider getNameProvider();
}
