package org.jfrog.jade.plugins.common.naming;

/*
 * Copyright 2005-2006 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.project.MavenProject;

import java.util.Set;

/**
 * @author Fred Simon
 */
public interface ProjectNameProvider {

    String getProjectName(MavenProject project);

    String getProjectName(Artifact artifact);

    String getProjectName(Dependency dependency);

    Set<GroupDefinition> getGroupDefinitions();

    void setGroupDefinitions(Set<GroupDefinition> groupDefinitions);

    boolean isInitialized();

    void setInitialized(boolean initialized);

    boolean hasGroupDefinitions();

    String getGroupName(String groupId);
}