/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.jade.plugins.common.deploy;

import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.jfrog.jade.plugins.common.deploy.Deployment;
import org.jfrog.jade.plugins.common.deploy.ProjectDeployments;
import org.jfrog.jade.plugins.common.injectable.MvnInjectable;

public class DeploymentHelper {
    public static final String CLASSIFIER = "deployments";
    public static final String TYPE = "xml";

    public static void saveDeployments(MvnInjectable injectable, ProjectDeployments projectDeployments) throws IOException {
        XStream xStream = DeploymentHelper.getXStream();
        File deploymentsFile = new File(injectable.getProject().getBuild().getDirectory(), "deployments.xml");
        xStream.toXML((Object)projectDeployments, (Writer)new FileWriter(deploymentsFile));
        injectable.getProjectHelper().attachArtifact(injectable.getProject(), TYPE, CLASSIFIER, deploymentsFile);
    }

    public static ProjectDeployments getDeployments(MvnInjectable injectable, Artifact dependency) throws IOException {
        ArtifactFactory artifactFactory = injectable.getArtifactFactory();
        if (artifactFactory == null) {
            throw new IOException("The MvnInjectable " + injectable + " has no artifact Factory");
        }
        Artifact deploymentsArtifact = artifactFactory.createArtifactWithClassifier(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), TYPE, CLASSIFIER);
        try {
            injectable.getArtifactResolver().resolve(deploymentsArtifact, injectable.getProject().getRemoteArtifactRepositories(), injectable.getLocalRepository());
        }
        catch (ArtifactResolutionException e) {
            injectable.getLog().error((Throwable)e);
            return null;
        }
        catch (ArtifactNotFoundException e) {
            injectable.getLog().error((Throwable)e);
            return null;
        }
        File deploymentsFile = deploymentsArtifact.getFile();
        return (ProjectDeployments)DeploymentHelper.getXStream().fromXML((Reader)new FileReader(deploymentsFile));
    }

    private static XStream getXStream() {
        XStream xStream = new XStream();
        xStream.alias("deployment", Deployment.class);
        xStream.alias("projectDeployments", ProjectDeployments.class);
        return xStream;
    }
}

