/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.jade.plugins.common.uptodate;

import java.io.File;
import org.apache.maven.project.MavenProject;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.UpToDate;
import org.apache.tools.ant.types.FileSet;
import org.jfrog.jade.components.uptodate.UpToDateAnalyzer;
import org.jfrog.jade.plugins.common.injectable.MvnInjectable;

public class UpToDateAnalyzerImpl
implements UpToDateAnalyzer {
    private final Project antProject;
    private final MavenProject mavenProject;

    public UpToDateAnalyzerImpl(MvnInjectable injectable) {
        this.mavenProject = injectable.getProject();
        this.antProject = injectable.getMaven2AntManager().getAntProject(injectable);
    }

    public boolean isUpToDate(File dest, File src) {
        if (src == null || !src.exists()) {
            throw new RuntimeException("File " + src + " not found when trying to test for Up To Date of " + dest);
        }
        if (dest == null || !dest.exists() || dest.lastModified() < src.lastModified()) {
            return false;
        }
        if (src.isDirectory()) {
            FileSet fileSet = new FileSet();
            fileSet.setProject(this.antProject);
            fileSet.setDir(src);
            fileSet.setExcludes(".svn CVS");
            UpToDate upToDate = new UpToDate();
            upToDate.setProject(this.antProject);
            upToDate.setTargetFile(dest);
            upToDate.addSrcfiles(fileSet);
            return upToDate.eval();
        }
        return true;
    }
}

