/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.maven.annomojo.extractor;

import com.sun.mirror.apt.AnnotationProcessorFactory;
import com.sun.tools.apt.Main;
import java.io.File;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.descriptor.InvalidPluginDescriptorException;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.project.MavenProject;
import org.apache.maven.tools.plugin.PluginToolsRequest;
import org.apache.maven.tools.plugin.extractor.ExtractionException;
import org.apache.maven.tools.plugin.extractor.MojoDescriptorExtractor;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.codehaus.plexus.util.FileUtils;
import org.jfrog.maven.annomojo.extractor.MojoApf;
import org.jfrog.maven.annomojo.extractor.MojoDescriptorTls;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnoMojoDescriptorExtractor
extends AbstractLogEnabled
implements MojoDescriptorExtractor,
Contextualizable {
    public void contextualize(Context context) throws ContextException {
    }

    public List<MojoDescriptor> execute(PluginToolsRequest pluginToolsRequest) throws ExtractionException, InvalidPluginDescriptorException {
        List<MojoDescriptor> list = this.execute(pluginToolsRequest.getProject(), pluginToolsRequest.getPluginDescriptor());
        return list;
    }

    public List<MojoDescriptor> execute(MavenProject project, PluginDescriptor pluginDescriptor) throws InvalidPluginDescriptorException {
        URL[] urls;
        List compileClasspathElements;
        List sourceRoots = project.getCompileSourceRoots();
        HashSet<String> sourcePathElements = new HashSet<String>();
        String srcRoot = null;
        try {
            Iterator i$ = sourceRoots.iterator();
            while (i$.hasNext()) {
                String sourceRoot;
                srcRoot = sourceRoot = (String)i$.next();
                List files = FileUtils.getFiles((File)new File(srcRoot), (String)"**/*.java", null, (boolean)true);
                for (File file : files) {
                    String path = file.getPath();
                    sourcePathElements.add(path);
                }
            }
        }
        catch (Exception e) {
            throw new InvalidPluginDescriptorException("Failed to get source files from " + srcRoot, (Throwable)e);
        }
        ArrayList<String> argsList = new ArrayList<String>();
        argsList.add("-nocompile");
        argsList.add("-cp");
        StringBuilder cp = new StringBuilder();
        try {
            compileClasspathElements = project.getCompileClasspathElements();
        }
        catch (DependencyResolutionRequiredException e) {
            throw new InvalidPluginDescriptorException("Failed to get compileClasspathElements.", (Throwable)e);
        }
        for (String ccpe : compileClasspathElements) {
            this.appendToPath(cp, ccpe);
        }
        for (URL url : urls = ((URLClassLoader)((Object)((Object)this)).getClass().getClassLoader()).getURLs()) {
            String path;
            try {
                path = url.getPath();
            }
            catch (Exception e) {
                throw new InvalidPluginDescriptorException("Failed to get classpath files from " + url, (Throwable)e);
            }
            this.appendToPath(cp, path);
        }
        String classpath = cp.toString();
        this.debug("cl=" + classpath);
        argsList.add(classpath);
        argsList.addAll(sourcePathElements);
        String[] args = argsList.toArray(new String[argsList.size()]);
        ArrayList<MojoDescriptor> descriptors = new ArrayList<MojoDescriptor>();
        MojoDescriptorTls.setDescriptors(descriptors);
        try {
            Main.process((AnnotationProcessorFactory)new MojoApf(pluginDescriptor), (PrintWriter)new PrintWriter(System.out), (String[])args);
        }
        catch (Throwable t) {
            throw new InvalidPluginDescriptorException("Failed to extract plugin descriptor.", t);
        }
        return MojoDescriptorTls.getDescriptors();
    }

    private void debug(String msg) {
        Logger log = this.getLogger();
        if (log != null) {
            log.debug(msg);
        } else {
            System.out.println(msg);
        }
    }

    private void appendToPath(StringBuilder cp, String path) {
        if (path != null && path.length() > 0) {
            cp.append(path);
            cp.append(File.pathSeparator);
        }
    }
}

