/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.maven.plugins.javafx;

import com.sun.tools.javafx.ant.JavaFxAntTask;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.Path;
import org.jfrog.jade.plugins.common.ant.Maven2AntManager;
import org.jfrog.jade.plugins.common.injectable.MvnInjectableMojoSupport;
import org.jfrog.maven.annomojo.annotations.MojoGoal;
import org.jfrog.maven.annomojo.annotations.MojoParameter;
import org.jfrog.maven.annomojo.annotations.MojoPhase;
import org.jfrog.maven.annomojo.annotations.MojoRequiresDependencyResolution;

@MojoGoal(value="compile")
@MojoPhase(value="compile")
@MojoRequiresDependencyResolution(value="compile")
public class JavaFxCompilerMojo
extends MvnInjectableMojoSupport {
    @MojoParameter(required=true, readonly=true, defaultValue="${project.compileClasspathElements}", description="List of compile classpath elements.")
    private List<String> compileClasspathElements;
    @MojoParameter(required=true, expression="${basedir}/src/main/javafx", description="The source directory.")
    private File sourceDirectory;
    @MojoParameter(description="A list of inclusion filters for the compiler.")
    private List<String> includes;
    @MojoParameter(description="A list of exclusion filters for the compiler.")
    private List<String> excludes;
    @MojoParameter(required=true, defaultValue="${project.build.outputDirectory}", description="The output directory.")
    private String outputDirectory;
    @MojoParameter(expression="${javafxc.debug}", defaultValue="true", description="Whether to include debugging information in the compiled class files. The default value is true.")
    private boolean debug;
    @MojoParameter(expression="${javafxc.showDeprecation}", defaultValue="false", description="Output source locations where deprecated APIs are used.")
    private boolean showDeprecation;
    @MojoParameter(expression="${javafx.compiler.fork}", defaultValue="true", description="Fork the compiler if true.")
    private boolean fork;
    @MojoParameter(expression="${javafxc.optimize}", defaultValue="false", description="Optimize compiled code using the compiler's optimization methods.")
    private boolean optimize;
    @MojoParameter(expression="${javafxc.source}", defaultValue="1.6", description="The -source argument for the compiler.")
    private String source;
    @MojoParameter(expression="${javafxc.target}", defaultValue="1.6", description=" The -target argument for the compiler.")
    private String target;
    @MojoParameter(expression="${javafxc.executable}", description="The javafxc executable to use when fork is true.")
    private String executable;
    @MojoParameter(defaultValue="false", expression="${javafxc.verbose}", description="Print verbose output. Default is false. If running in debug mode will be set to true.")
    private boolean verbose;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if ("pom".equals(this.getProject().getPackaging())) {
            return;
        }
        if (this.getLog().isDebugEnabled()) {
            this.verbose = true;
        }
        this.printDebugInfo();
        if (!this.sourceDirectory.exists()) {
            throw new MojoFailureException("Source directory \"" + this.sourceDirectory.getAbsolutePath() + "\" doesn't exist.");
        }
        Maven2AntManager mvnHelper = this.getMaven2AntManager();
        Project antProject = this.getAntProject();
        JavaFxAntTask javafxc = new JavaFxAntTask();
        javafxc.setProject(antProject);
        Path compilerClasspath = new Path(antProject);
        mvnHelper.fillPathFromArtifacts(compilerClasspath, (Collection)this.getPluginArtifacts());
        javafxc.setCompilerClassPath(compilerClasspath);
        Path src = javafxc.createSrc();
        mvnHelper.fillPathFromLocations(src, Arrays.asList(this.sourceDirectory));
        Path sourcePath = javafxc.createSourcepath();
        mvnHelper.fillPathFromLocations(sourcePath, Arrays.asList(this.sourceDirectory));
        if (this.includes != null) {
            for (String include : this.includes) {
                this.getLog().warn((CharSequence)("Adding include pattern: " + include));
                javafxc.createPatternSet().createInclude().setName(include);
            }
        }
        if (this.excludes != null) {
            for (String exclude : this.excludes) {
                this.getLog().debug((CharSequence)("Adding exclude pattern: " + exclude));
                javafxc.createPatternSet().createExclude().setName(exclude);
            }
        }
        mvnHelper.fillPathFromPaths(javafxc.createClasspath(), this.compileClasspathElements);
        File outputFileDir = new File(this.outputDirectory);
        if (!outputFileDir.exists()) {
            outputFileDir.mkdirs();
        }
        javafxc.setDestdir(outputFileDir);
        javafxc.setSource(this.source);
        javafxc.setTarget(this.target);
        javafxc.setOptimize(this.optimize);
        javafxc.setDebug(this.debug);
        javafxc.setDeprecation(this.showDeprecation);
        javafxc.setFork(this.fork);
        javafxc.setExecutable(this.executable);
        javafxc.setFailonerror(true);
        try {
            javafxc.execute();
        }
        catch (BuildException be) {
            throw new MojoExecutionException(be.getMessage(), (Exception)((Object)be));
        }
    }

    private void printDebugInfo() {
        this.logIfVerbose(ToStringBuilder.reflectionToString((Object)((Object)this), (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE));
    }

    protected void logIfVerbose(String message) {
        if (this.verbose) {
            this.getLog().info((CharSequence)message);
        }
    }
}

