/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.maven.plugins.jnlp;

import java.io.IOException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.jfrog.maven.annomojo.annotations.MojoComponent;
import org.jfrog.maven.annomojo.annotations.MojoGoal;
import org.jfrog.maven.annomojo.annotations.MojoParameter;

@MojoGoal(value="execute")
public class JnlpExecutorMojo
extends AbstractMojo {
    @MojoParameter(expression="${jnlp.jnlpFullPath}", description="Jnlp file path to execute. Can be local or remote file.")
    private String jnlpFullPath;
    @MojoParameter(expression="${jnlp.jnlpRootPath}", description="Jnlp file root path to execute. Can be local or remote file.")
    private String jnlpRootPath;
    @MojoParameter(expression="${jnlp.jnlpRelativePath}", description="Relative path to jnlpRootPath pointing to the jnlp file. Deafult is the maven relative path.")
    private String jnlpRelativePath;
    @MojoParameter(required=true, readonly=true, expression="${project}", description="The Maven Project")
    private MavenProject project;
    @MojoComponent
    private ArtifactFactory artifactFactory;
    @MojoComponent
    private ArtifactRepositoryLayout repositoryLayout;

    public void execute() throws MojoExecutionException, MojoFailureException {
        String jnlpPath;
        if ("pom".equals(this.project.getPackaging())) {
            return;
        }
        if (this.jnlpFullPath != null) {
            jnlpPath = this.jnlpFullPath;
        } else if (this.jnlpRootPath != null) {
            if (this.jnlpRelativePath == null) {
                Artifact artifact = this.artifactFactory.createArtifact(this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion(), "compile", "jnlp");
                this.jnlpRelativePath = this.repositoryLayout.pathOf(artifact);
                this.getLog().debug((CharSequence)("Using default relative path: " + this.jnlpRelativePath));
            }
            jnlpPath = this.jnlpRootPath + "/" + this.jnlpRelativePath;
        } else {
            throw new MojoExecutionException("jnlpRootPath or jnlpFullPath must be set");
        }
        try {
            String command = "javaws " + jnlpPath;
            this.getLog().info((CharSequence)("Executing: " + command));
            Runtime.getRuntime().exec(command);
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }
}

