/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.maven.plugins.jnlp;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.model.Model;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.jfrog.maven.annomojo.annotations.MojoComponent;
import org.jfrog.maven.annomojo.annotations.MojoGoal;
import org.jfrog.maven.annomojo.annotations.MojoParameter;
import org.jfrog.maven.annomojo.annotations.MojoPhase;
import org.jfrog.maven.annomojo.annotations.MojoRequiresDependencyResolution;
import org.jfrog.maven.plugins.jnlp.ExclusionsFilter;
import org.jfrog.maven.plugins.jnlp.VelocityGenerator;

@MojoPhase(value="package")
@MojoGoal(value="jnlp")
@MojoRequiresDependencyResolution(value="runtime")
public class JnlpGeneratorMojo
extends AbstractMojo {
    private final String DEFAULT_JNLP_TEMPLATE = "template/default.jnlp.vm";
    private final String DEFAULT_JAVAFX_JNLP_TEMPLATE = "template/default-javafx.jnlp.vm";
    @MojoParameter(defaultValue="${project.basedir}/src/main/jnlp", description="Directory containing the jnlp template file.")
    private File templateDirectory;
    @MojoParameter(expression="${jnlp.templateFileName}", description="The jnlp template file (relative to the template directory). If not set use the default jnlp template.")
    private String templateFileName;
    @MojoParameter(defaultValue="${project.build.directory}/jnlp", description="The target directory of the generated jnlp file.")
    private File targetDirectory;
    @MojoParameter(defaultValue="${project.artifactId}.jnlp", alias="targetFile", description="The target file name. The default is the name of the input file.")
    private String targetFileName;
    @MojoParameter(defaultValue="false", expression="${jnlp.mavenStyleResourceLinks}", description="If set to true the jar resources href path will use maven layout. i.e., /groupId/artifactId/filename")
    private boolean mavenStyleResourceLinks;
    @MojoParameter(defaultValue="true", expression="${jnlp.offlineAllowed}", description="Used as template parameter")
    private boolean offlineAllowed = true;
    @MojoParameter(defaultValue="false", expression="${jnlp.allPermissions}", description="Used as template parameter")
    private boolean allPermissions = false;
    @MojoParameter(defaultValue="1.5+", expression="${jnlp.j2seVersion}", description="Used as template parameter")
    private String j2seVersion = "1.5+";
    @MojoParameter(defaultValue="", expression="${jnlp.javaVmArgs}", description="Used as template parameter")
    private String javaVmArgs = "";
    @MojoParameter(defaultValue="600", expression="${jnlp.appletWidth}", description="Used as template parameter")
    private int appletWidth = 600;
    @MojoParameter(defaultValue="400", expression="${jnlp.appletHeight}", description="Used as template parameter")
    private int appletHeight = 400;
    @MojoParameter(defaultValue="false", expression="${jnlp.attach}", description="Whether to attach the generated jnlp file to the deployable artifact list.")
    private boolean attach;
    @MojoParameter(defaultValue="false", expression="${jnlp.generateJavafxJnlp}", description="If true and using the default template, the plugin will also generate a jnlp file using the default javafx template. If attach is true the generated jnlp will be attached with the classifier 'browser'.")
    private boolean generateJavaFxJnlp;
    @MojoParameter(defaultValue="false", expression="${jnlp.verbose}", description="Print verbose output. Default is false. If running in debug mode will be set to true.")
    private boolean verbose;
    @MojoParameter(description="Group id and artifact id in the form of groupId:artifactId of the jar with the main class. If not specified and mainClass is specified the plugin will try to detect the main jar by reflection.")
    private String mainJar;
    @MojoParameter(expression="${jnlp.mainClass}", description="Fully qualified name of the main class. If specified and mainJar is not specified the plugin will try to detect the main jar by reflection.")
    private String mainClass;
    @MojoParameter(description="List of dependencies to exclude in the form of groupId:artifactId:version.")
    private List<String> excludes;
    @MojoParameter(description="Additional key:value parameters to replace in the template.")
    private Map<String, String> additionalParameters;
    @MojoParameter(required=true, readonly=true, expression="${project}", description="The Maven Project")
    private MavenProject project;
    @MojoParameter(readonly=true, expression="${project.artifacts}", description="The project dependency artifacts")
    private Set<Artifact> projectRuntimeArtifacts;
    @MojoComponent(description="project-helper instance, used to make addition of resources simpler")
    private MavenProjectHelper projectHelper;
    @MojoComponent
    private ArtifactRepositoryLayout repositoryLayout;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if ("pom".equals(this.project.getPackaging())) {
            return;
        }
        if (this.getLog().isDebugEnabled()) {
            this.verbose = true;
        }
        this.printDebugInfo();
        if (this.templateFileName == null) {
            this.getLog().info((CharSequence)"'templateFileName' not set. Using default jnlp template.");
            this.templateFileName = this.generateJavaFxJnlp ? "template/default-javafx.jnlp.vm" : "template/default.jnlp.vm";
        } else {
            File jnlpTemplate = new File(this.templateDirectory, this.templateFileName);
            if (!jnlpTemplate.exists()) {
                throw new MojoFailureException("Couldn't find jnlp template: " + jnlpTemplate.getAbsolutePath());
            }
        }
        this.createTargetDirectoryIfNotExist();
        Artifact currentProjectArtifact = this.project.getArtifact();
        if (currentProjectArtifact != null && currentProjectArtifact.getFile() != null) {
            this.projectRuntimeArtifacts.add(currentProjectArtifact);
        }
        if (StringUtils.isNotBlank((String)this.mainClass) && StringUtils.isBlank((String)this.mainJar)) {
            this.resolveMainJar();
        }
        this.generateJnlpFile();
        if (this.generateJavaFxJnlp) {
            this.doGenerateJavaFxJnlp();
        }
        if (this.attach) {
            this.logIfVerbose("Attaching generated jnlp file to the project artifacts");
            this.projectHelper.attachArtifact(this.project, "jnlp", this.getTargetFile());
            if (this.generateJavaFxJnlp) {
                this.projectHelper.attachArtifact(this.project, "jnlp", "browser", this.getJavaFxTargetFile());
            }
        }
    }

    private void generateJnlpFile() throws MojoExecutionException {
        File targetFile = this.getTargetFile();
        VelocityGenerator.Builder builder = new VelocityGenerator.Builder(this.templateFileName, targetFile);
        builder.setContext(this.createTemplateContext()).setTemplateDirectory(this.templateDirectory);
        try {
            VelocityGenerator generator = builder.build();
            generator.generate();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to generate jnlp file: " + e.getMessage(), (Exception)e);
        }
    }

    private void doGenerateJavaFxJnlp() throws MojoExecutionException {
        VelocityGenerator.Builder builder = new VelocityGenerator.Builder("template/default-javafx.jnlp.vm", this.getJavaFxTargetFile());
        builder.setContext(this.createJavaFxTemplateContext());
        try {
            VelocityGenerator generator = builder.build();
            generator.generate();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to generate javafx jnlp file: " + e.getMessage(), (Exception)e);
        }
    }

    private File getTargetFile() {
        return new File(this.targetDirectory, this.targetFileName);
    }

    private void resolveMainJar() throws MojoExecutionException {
        this.logIfVerbose("Looking for jar containing main class: " + this.mainClass);
        for (Artifact artifact : this.projectRuntimeArtifacts) {
            URL artifactFileUrl;
            try {
                artifactFileUrl = artifact.getFile().toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new MojoExecutionException("Failed to get artifact file", (Exception)e);
            }
            boolean mainJarFound = false;
            URLClassLoader cl = new URLClassLoader(new URL[]{artifactFileUrl});
            try {
                Class.forName(this.mainClass, false, cl);
                mainJarFound = true;
            }
            catch (ClassNotFoundException e) {
                this.getLog().debug((CharSequence)("Artifact " + artifact + " doesn't contain the main class."));
            }
            catch (NoClassDefFoundError e) {
                this.getLog().debug((CharSequence)("Artifact " + artifact + " seems to contain the main class " + "(got NoClassDefFoundError: + " + e.getMessage() + ")."));
                mainJarFound = true;
            }
            if (!mainJarFound) continue;
            this.logIfVerbose("Artifact containing main class detected: " + artifact);
            this.mainJar = artifact.getGroupId() + ":" + artifact.getArtifactId();
            return;
        }
    }

    private String getDependenciesString() {
        ExclusionsFilter filter = new ExclusionsFilter(this.excludes);
        StringBuilder sb = new StringBuilder();
        Iterator<Artifact> artifactsIter = this.projectRuntimeArtifacts.iterator();
        while (artifactsIter.hasNext()) {
            Artifact artifact = artifactsIter.next();
            if (filter.isExcluded(artifact)) continue;
            sb.append("<jar href=\"");
            String href = this.mavenStyleResourceLinks ? this.repositoryLayout.pathOf(artifact) : artifact.getFile().getName();
            sb.append(href);
            sb.append("\"");
            if (this.isMainArtifact(artifact)) {
                sb.append(" main=\"true\"");
            }
            sb.append("/>");
            if (!artifactsIter.hasNext()) continue;
            sb.append("\n        ");
        }
        String jarResources = sb.toString();
        this.logIfVerbose("Jar resources:\n" + jarResources);
        return jarResources;
    }

    private boolean isMainArtifact(Artifact artifact) {
        if (StringUtils.isBlank((String)this.mainJar)) {
            return false;
        }
        return this.mainJar.equals(artifact.getGroupId() + ":" + artifact.getArtifactId());
    }

    private void printDebugInfo() {
        this.logIfVerbose(ToStringBuilder.reflectionToString((Object)((Object)this), (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE));
    }

    private void logIfVerbose(String message) {
        if (this.verbose) {
            this.getLog().info((CharSequence)message);
        }
    }

    private Map<String, Object> createTemplateContext() {
        HashMap<String, Object> context = new HashMap<String, Object>();
        Properties projectProperties = this.project.getProperties();
        this.addAllProperties(context, projectProperties);
        context.put("dependencies", this.getDependenciesString());
        if (this.mainClass != null) {
            context.put("mainClass", this.mainClass);
        }
        if (this.additionalParameters != null) {
            context.putAll(this.additionalParameters);
        }
        Model projectModel = this.project.getModel();
        context.put("project", projectModel);
        context.put("informationTitle", projectModel.getName());
        context.put("informationDescription", projectModel.getDescription());
        if (projectModel.getOrganization() != null) {
            context.put("informationVendor", projectModel.getOrganization().getName());
            context.put("informationHomepage", projectModel.getOrganization().getUrl());
        }
        context.put("targetFileName", this.targetFileName);
        context.put("j2seVersion", this.j2seVersion);
        context.put("javaVmArgs", this.javaVmArgs);
        context.put("offlineAllowed", this.offlineAllowed);
        context.put("allPermissions", this.allPermissions);
        context.put("appletWidth", this.appletWidth);
        context.put("appletHeight", this.appletHeight);
        if ("template/default-javafx.jnlp.vm".equals(this.templateFileName)) {
            context.put("_javafxApplication", true);
        }
        Properties systemProps = System.getProperties();
        this.addAllProperties(context, systemProps);
        this.getLog().debug((CharSequence)("Template context: " + context));
        return context;
    }

    private Map<String, Object> createJavaFxTemplateContext() {
        Map<String, Object> context = this.createTemplateContext();
        context.put("targetFileName", this.getJavaFxTargetFileName());
        context.put("_javafxApplication", false);
        context.put("_javafxApplet", true);
        return context;
    }

    private void addAllProperties(Map<String, Object> context, Properties systemProps) {
        for (String key : systemProps.stringPropertyNames()) {
            String escapedKey = key.replaceAll("\\.", "_");
            context.put(escapedKey, systemProps.getProperty(key));
        }
    }

    private void createTargetDirectoryIfNotExist() throws MojoFailureException {
        if (!this.targetDirectory.exists() && !this.targetDirectory.mkdirs()) {
            throw new MojoFailureException("Failed to create target directory: " + this.targetDirectory.getAbsolutePath());
        }
    }

    public String getTargetFileName() {
        return this.targetFileName;
    }

    File getJavaFxTargetFile() {
        return new File(this.targetDirectory, this.getJavaFxTargetFileName());
    }

    String getJavaFxTargetFileName() {
        int extensionIndex = this.targetFileName.lastIndexOf(".");
        if (extensionIndex > 0) {
            return this.targetFileName.substring(0, extensionIndex) + "-browser" + this.targetFileName.substring(extensionIndex, this.targetFileName.length());
        }
        return this.targetFileName + "-browser";
    }
}

