/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.maven.plugins.jnlp;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.Artifact;

public class ArtifactsFilter {
    private final List<String> filterPatterns;

    public ArtifactsFilter(List<String> filters) {
        this.filterPatterns = filters;
    }

    public boolean isFiltered(Artifact artifact) {
        if (this.filterPatterns == null || this.filterPatterns.isEmpty()) {
            return false;
        }
        for (String pattern : this.filterPatterns) {
            String[] filterPatternTokens = pattern.split(":");
            if (!this.matches(artifact, filterPatternTokens = StringUtils.stripAll((String[])filterPatternTokens))) continue;
            return true;
        }
        return false;
    }

    protected boolean matches(Artifact artifact, String[] pattern) {
        boolean result = false;
        if (pattern.length > 0) {
            boolean bl = result = pattern[0].equals("*") || artifact.getGroupId().equals(pattern[0]);
        }
        if (result && pattern.length > 1) {
            boolean bl = result = pattern[1].equals("*") || artifact.getArtifactId().equals(pattern[1]);
        }
        if (result && pattern.length > 2) {
            result = pattern[2].equals("*") || artifact.getVersion().equals(pattern[2]);
        }
        return result;
    }
}

