/*
 * (C) Copyright 2015-2020, by Alexey Kudinkin and Contributors.
 *
 * JGraphT : a free Java graph-theory library
 *
 * See the CONTRIBUTORS.md file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0, or the
 * GNU Lesser General Public License v2.1 or later
 * which is available at
 * http://www.gnu.org/licenses/old-licenses/lgpl-2.1-standalone.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR LGPL-2.1-or-later
 */
package org.jgrapht.alg.util.extension;

/**
 * Factory class which creates extension/encapsulation objects
 * 
 * @param <B> class-type of extension
 */
public interface ExtensionFactory<B extends Extension>
{
    /**
     * Factory method which creates a new object which extends Extension
     * 
     * @return new object which extends Extension
     */
    B create();
}
