/*
 * Decompiled with CFR 0.152.
 */
package org.jutils.jhardware.info.bios.unix;

import java.util.HashMap;
import java.util.Map;
import org.jutils.jhardware.info.bios.AbstractBiosInfo;
import org.jutils.jhardware.util.HardwareInfoUtils;

public final class UnixBiosInfo
extends AbstractBiosInfo {
    private static final String DMIPATH = "/sys/devices/virtual/dmi/id/";

    private static String getBiosData() {
        String fullData = "";
        if (HardwareInfoUtils.isSudo()) {
            fullData = fullData + HardwareInfoUtils.executeCommand("sudo", "dmidecode", "--type", "0");
        } else {
            fullData = fullData + "\tRelease Date: " + HardwareInfoUtils.executeCommand("cat", "/sys/devices/virtual/dmi/id/bios_date");
            fullData = fullData + "\tVendor: " + HardwareInfoUtils.executeCommand("cat", "/sys/devices/virtual/dmi/id/bios_vendor");
            fullData = fullData + "\tVersion: " + HardwareInfoUtils.executeCommand("cat", "/sys/devices/virtual/dmi/id/bios_version");
        }
        return fullData;
    }

    @Override
    protected Map<String, String> parseInfo() {
        String[] dataStringLines;
        HashMap<String, String> biosDataMap = new HashMap<String, String>();
        for (String dataLine : dataStringLines = UnixBiosInfo.getBiosData().split("\\r?\\n")) {
            if (!dataLine.startsWith("\t")) continue;
            String[] dataStringInfo = dataLine.split(":");
            if (dataStringInfo.length == 2) {
                biosDataMap.put(dataStringInfo[0].trim(), dataStringInfo[1].trim());
                continue;
            }
            if (dataStringInfo.length != 1 || !"\tCharacteristics".equals(dataStringInfo[0])) continue;
            biosDataMap.put(dataStringInfo[0].trim(), UnixBiosInfo.getCharacteristics(dataStringLines));
        }
        return biosDataMap;
    }

    private static String getCharacteristics(String[] dataStringLines) {
        StringBuilder characteristics = new StringBuilder();
        for (String characteristicsLine : dataStringLines) {
            if (characteristicsLine.trim().length() <= 0 || !characteristicsLine.startsWith("\t\t")) continue;
            characteristics.append(characteristicsLine.trim()).append("\n");
        }
        return characteristics.toString();
    }
}

