/*
 * Decompiled with CFR 0.152.
 */
package org.jutils.jhardware.info.display;

import java.util.ArrayList;
import java.util.Map;
import org.jutils.jhardware.info.HardwareInfo;
import org.jutils.jhardware.model.Display;
import org.jutils.jhardware.model.DisplayInfo;

public abstract class AbstractDisplayInfo
implements HardwareInfo {
    @Override
    public DisplayInfo getInfo() {
        return this.buildFromDataMap(this.parseInfo());
    }

    protected abstract Map<String, String> parseInfo();

    protected DisplayInfo buildFromDataMap(Map<String, String> dataMap) {
        DisplayInfo info = new DisplayInfo();
        ArrayList<Display> displayList = new ArrayList<Display>();
        if (dataMap != null && !dataMap.isEmpty()) {
            int numOfDisplays = Integer.parseInt(dataMap.get("numOfDisplays"));
            for (int i = 0; i < numOfDisplays; ++i) {
                Display display = new Display();
                display.setName(dataMap.get("name_" + i));
                display.setCurrentResolution(dataMap.get("current_res_" + i));
                display.setRefreshRate(dataMap.get("current_refresh_rate_" + i));
                display.setSupportedResolutions(dataMap.get("available_res_" + i).split(";"));
                displayList.add(display);
            }
        }
        info.setDisplayDevices(displayList);
        return info;
    }
}

