/*
 * Decompiled with CFR 0.152.
 */
package org.jutils.jhardware.info.display.unix;

import java.util.HashMap;
import java.util.Map;
import org.jutils.jhardware.info.display.AbstractDisplayInfo;
import org.jutils.jhardware.util.HardwareInfoUtils;

public final class UnixDisplayInfo
extends AbstractDisplayInfo {
    private static final String XRANDR_COMMAND = "xrandr";
    private static final String XRANDR_PARAM = "-q";

    private static String getDisplayData() {
        return HardwareInfoUtils.executeCommand(XRANDR_COMMAND, XRANDR_PARAM);
    }

    @Override
    protected Map<String, String> parseInfo() {
        HashMap<String, String> displayDataMap = new HashMap<String, String>();
        String[] dataStringLines = UnixDisplayInfo.getDisplayData().split("\\r?\\n");
        int count = -1;
        for (String dataLine : dataStringLines) {
            if (dataLine.startsWith("Screen")) {
                displayDataMap.put("name_" + ++count, dataLine.substring(0, dataLine.indexOf(":")));
                displayDataMap.put("current_res_" + count, HardwareInfoUtils.extractText(dataLine, "current (.+?),"));
                continue;
            }
            if (!Character.isWhitespace(dataLine.charAt(0))) continue;
            String[] availableResData = dataLine.split("\\s+");
            if (availableResData[2].endsWith("*+")) {
                displayDataMap.put("current_refresh_rate_" + count, availableResData[2].substring(0, availableResData[2].indexOf("*+")));
                continue;
            }
            String alreadyAddedResolutions = displayDataMap.get("available_res_" + count) != null ? (String)displayDataMap.get("available_res_" + count) : "";
            displayDataMap.put("available_res_" + count, alreadyAddedResolutions + availableResData[1] + "x" + availableResData[2] + ";");
        }
        displayDataMap.put("numOfDisplays", String.valueOf(count + 1));
        return displayDataMap;
    }
}

