/*
 * Decompiled with CFR 0.152.
 */
package org.jutils.jhardware.info.display.windows;

import com.profesorfalken.wmi4java.WMI4Java;
import com.profesorfalken.wmi4java.WMIClass;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jutils.jhardware.info.display.AbstractDisplayInfo;
import org.jutils.jhardware.util.DirectXInfoLoader;
import org.jutils.jhardware.util.HardwareInfoUtils;

public final class WindowsDisplayInfo
extends AbstractDisplayInfo {
    @Override
    protected Map<String, String> parseInfo() {
        Map<String, String> displayDataMap = this.getInfoFromWin32DesktopMonitor();
        if (!this.checkData(displayDataMap)) {
            this.completeWithDXData(displayDataMap);
        }
        this.addSupportedResolutions(displayDataMap);
        return displayDataMap;
    }

    private boolean checkData(Map<String, String> displayDataMap) {
        for (Map.Entry<String, String> entry : displayDataMap.entrySet()) {
            if (entry.getValue() != null && !entry.getValue().isEmpty()) continue;
            return false;
        }
        return true;
    }

    private void completeWithDXData(Map<String, String> displayDataMap) {
        Map<String, String> dxDisplayDataMap = this.getInfoFromDXDiag();
        for (Map.Entry<String, String> entry : displayDataMap.entrySet()) {
            if (entry.getValue() != null && !entry.getValue().isEmpty()) continue;
            entry.setValue(dxDisplayDataMap.get(entry.getKey()));
        }
    }

    private Map<String, String> getInfoFromDXDiag() {
        HashMap<String, String> displayDataMap = new HashMap<String, String>();
        DirectXInfoLoader directXinfo = DirectXInfoLoader.get;
        List<Map<String, String>> rawDisplayInfoMap = directXinfo.getDisplayInfo();
        int numDevice = 0;
        for (Map<String, String> displayInfoMap : rawDisplayInfoMap) {
            displayDataMap.put("name_" + numDevice, displayInfoMap.get("MonitorName"));
            displayDataMap.put("current_res_" + numDevice, this.getResolution(displayInfoMap.get("CurrentMode")));
            displayDataMap.put("current_refresh_rate_" + numDevice, this.getRefreshRate(displayInfoMap.get("CurrentMode")));
            ++numDevice;
        }
        displayDataMap.put("numOfDisplays", String.valueOf(rawDisplayInfoMap.size()));
        return displayDataMap;
    }

    private Map<String, String> getInfoFromWin32DesktopMonitor() {
        HashMap<String, String> displayDataMap = new HashMap<String, String>();
        String rawdisplayData = WMI4Java.get().VBSEngine().properties(Arrays.asList("Name", "ScreenWidth", "ScreenHeight")).getRawWMIObjectOutput(WMIClass.WIN32_DESKTOPMONITOR);
        String[] dataStringLines = rawdisplayData.split("\\r?\\n");
        int numDevice = 0;
        for (String dataLine : dataStringLines) {
            if (dataLine.startsWith("Name")) {
                displayDataMap.put("name_" + numDevice, dataLine.split(":", 2)[1]);
                continue;
            }
            if (dataLine.startsWith("ScreenWidth")) {
                displayDataMap.put("current_res_" + numDevice, dataLine.split(":", 2)[1]);
                continue;
            }
            if (!dataLine.startsWith("ScreenHeight")) continue;
            displayDataMap.put("current_res_" + numDevice, HardwareInfoUtils.removeAllSpaces((String)displayDataMap.get("current_res_" + numDevice) + "x" + dataLine.split(":", 2)[1]));
            displayDataMap.put("current_refresh_rate_" + numDevice, this.getCurrentRefreshRate());
            ++numDevice;
        }
        displayDataMap.put("numOfDisplays", String.valueOf(numDevice));
        return displayDataMap;
    }

    private String getCurrentRefreshRate() {
        String rawRefresRateData = WMI4Java.get().VBSEngine().properties(Arrays.asList("CurrentRefreshRate")).getRawWMIObjectOutput(WMIClass.WIN32_VIDEOCONTROLLER);
        String[] dataStringLines = rawRefresRateData.split("\\r?\\n");
        return dataStringLines[0].split(":", 2)[1];
    }

    private void addSupportedResolutions(Map<String, String> displayDataMap) {
        HashSet<String> supportedResolutions = new HashSet<String>();
        StringBuilder allSupportedResolutions = new StringBuilder();
        String rawdisplayData = WMI4Java.get().VBSEngine().properties(Arrays.asList("HorizontalResolution", "VerticalResolution", "RefreshRate")).getRawWMIObjectOutput(WMIClass.CIM_VIDEOCONTROLLERRESOLUTION);
        String[] dataStringLines = rawdisplayData.split("\\r?\\n");
        String hRes = "";
        String vRes = "";
        for (String dataLine : dataStringLines) {
            if (dataLine.startsWith("HorizontalResolution")) {
                hRes = dataLine.split(":", 2)[1];
                continue;
            }
            if (dataLine.startsWith("VerticalResolution")) {
                vRes = dataLine.split(":", 2)[1];
                continue;
            }
            if (!dataLine.startsWith("RefreshRate")) continue;
            supportedResolutions.add(HardwareInfoUtils.removeAllSpaces(hRes + "x" + vRes + "x" + dataLine.split(":", 2)[1]));
        }
        supportedResolutions.stream().forEach(supportedResolution -> allSupportedResolutions.append((String)supportedResolution).append(";"));
        displayDataMap.put("available_res_0", allSupportedResolutions.toString());
    }

    private String getResolution(String currentMode) {
        return HardwareInfoUtils.removeAllSpaces(currentMode.substring(0, currentMode.indexOf("(")));
    }

    private String getRefreshRate(String currentMode) {
        return HardwareInfoUtils.extractText(currentMode, "\\) \\((.+?)Hz");
    }
}

