/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.binding.classes;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.jibx.binding.classes.BindingMethod;
import org.jibx.binding.classes.ClassCache;
import org.jibx.binding.classes.ClassFile;
import org.jibx.binding.classes.ExistingMethod;
import org.jibx.binding.classes.MethodBuilder;
import org.jibx.runtime.JiBXException;

public class MungedClass {
    private static final ClassFile[] EMPTY_CLASSFILE_ARRAY = new ClassFile[0];
    private static final String BINDING_LISTNAME = "JiBX_bindingList";
    private static final String[] EXTRA_METHODS_MATCHES = new String[]{"marshal", "(Lorg/jibx/runtime/IMarshallingContext;)V", "unmarshal", "(Lorg/jibx/runtime/IUnmarshallingContext;)V"};
    private static ArrayList s_classes;
    private static HashMap s_classMap;
    private static HashMap s_directories;
    private static HashMap s_nameMap;
    private static ArrayList s_pendingClasses;
    private ClassFile m_classFile;
    private HashMap m_methodMap;
    private ExistingMethod[] m_existingMethods;
    private String m_factoryList;

    private MungedClass(ClassFile cf) {
        this.m_classFile = cf;
        this.m_methodMap = new HashMap();
        ExistingMethod[] exists = cf.getBindingMethods("JiBX_", EXTRA_METHODS_MATCHES);
        if (exists != null) {
            for (int i = 0; i < exists.length; ++i) {
                this.m_methodMap.put(exists[i], exists[i]);
            }
        }
        this.m_existingMethods = exists;
    }

    ClassFile getClassFile() {
        return this.m_classFile;
    }

    private void purgeUnusedMethods() throws JiBXException {
        if (this.m_existingMethods != null) {
            for (int i = 0; i < this.m_existingMethods.length; ++i) {
                ExistingMethod method = this.m_existingMethods[i];
                if (method.isUsed()) continue;
                method.delete();
            }
        }
    }

    BindingMethod getUniqueMethod(MethodBuilder builder, boolean suffix) throws JiBXException {
        if (builder.getClassFile() != this.m_classFile) {
            throw new IllegalStateException("Internal error: wrong class for call");
        }
        builder.codeComplete(suffix);
        BindingMethod method = (BindingMethod)this.m_methodMap.get(builder);
        if (method == null) {
            builder.addMethod();
            this.m_methodMap.put(builder, builder);
            return builder;
        }
        if (method instanceof ExistingMethod) {
            ((ExistingMethod)method).setUsed();
        }
        return method;
    }

    public static ClassFile getUniqueSupportClass(ClassFile cf) {
        cf.codeComplete();
        Object value = s_classMap.get(cf);
        if (value == null) {
            s_classes.add(cf);
            s_classMap.put(cf, cf);
            return cf;
        }
        ClassFile prior = (ClassFile)value;
        prior.incrementUseCount();
        return prior;
    }

    static void checkDirectory(File root, String pack) throws JiBXException {
        try {
            File directory = new File(root, pack.replace('.', File.separatorChar));
            String cpath = directory.getCanonicalPath();
            if (s_directories.get(cpath) == null) {
                File[] matches = new File(cpath).listFiles(new JiBXFilter());
                for (int i = 0; i < matches.length; ++i) {
                    File file = matches[i];
                    String name = file.getName();
                    int split = name.indexOf(46);
                    if (split >= 0) {
                        name = name.substring(0, split);
                    }
                    if (pack.length() > 0) {
                        name = pack + '.' + name;
                    }
                    ClassFile cf = ClassCache.getClassFile(name);
                    s_classes.add(cf);
                    s_classMap.put(cf, cf);
                }
                s_directories.put(cpath, cpath);
            }
        }
        catch (IOException ex) {
            throw new JiBXException("Error loading class file", (Throwable)ex);
        }
    }

    void addFactory(String fact) {
        this.m_factoryList = this.m_factoryList == null ? "|" + fact + "|" : this.m_factoryList + fact + "|";
    }

    void setFactoryList() throws JiBXException {
        if (this.m_factoryList != null) {
            int access = 25;
            this.m_classFile.updateField("java.lang.String", BINDING_LISTNAME, access, this.m_factoryList);
        }
    }

    static MungedClass getInstance(ClassFile cf) throws JiBXException {
        MungedClass inst = (MungedClass)s_nameMap.get(cf.getName());
        if (inst == null) {
            inst = new MungedClass(cf);
            s_nameMap.put(cf.getName(), inst);
            if (cf.isComplete()) {
                if (s_classMap.get(cf) != null) {
                    throw new IllegalStateException("Existing class conflicts with load");
                }
                s_classes.add(inst);
                s_classMap.put(cf, cf);
                String pack = cf.getPackage();
                MungedClass.checkDirectory(cf.getRoot(), pack);
            }
        }
        inst.m_classFile.incrementUseCount();
        return inst;
    }

    public static void delayedAddUnique(ClassFile cf) {
        s_pendingClasses.add(cf);
    }

    public static ClassFile[][] fixChanges(boolean write) throws JiBXException {
        try {
            for (int i = 0; i < s_pendingClasses.size(); ++i) {
                MungedClass.getUniqueSupportClass((ClassFile)s_pendingClasses.get(i));
            }
            ArrayList<ClassFile> writes = new ArrayList<ClassFile>();
            ArrayList<ClassFile> keeps = new ArrayList<ClassFile>();
            ArrayList<ClassFile> deletes = new ArrayList<ClassFile>();
            for (int i = 0; i < s_classes.size(); ++i) {
                ClassFile cf;
                Object obj = s_classes.get(i);
                if (obj instanceof MungedClass) {
                    MungedClass inst = (MungedClass)obj;
                    inst.purgeUnusedMethods();
                    inst.setFactoryList();
                    cf = inst.getClassFile();
                } else {
                    cf = (ClassFile)obj;
                }
                if (cf.isModified()) {
                    if (write) {
                        cf.writeFile();
                    }
                    writes.add(cf);
                    continue;
                }
                if (cf.getUseCount() > 0) {
                    keeps.add(cf);
                    continue;
                }
                cf.delete();
                deletes.add(cf);
            }
            ClassFile[][] results = new ClassFile[][]{writes.toArray(EMPTY_CLASSFILE_ARRAY), keeps.toArray(EMPTY_CLASSFILE_ARRAY), deletes.toArray(EMPTY_CLASSFILE_ARRAY)};
            return results;
        }
        catch (IOException ex) {
            throw new JiBXException("Error writing to file", (Throwable)ex);
        }
    }

    public static void reset() {
        s_classes = new ArrayList();
        s_classMap = new HashMap();
        s_directories = new HashMap();
        s_nameMap = new HashMap();
        s_pendingClasses = new ArrayList();
    }

    private static class JiBXFilter
    implements FileFilter {
        private JiBXFilter() {
        }

        public boolean accept(File file) {
            String name = file.getName();
            return name.startsWith("JiBX_") && name.endsWith(".class");
        }
    }
}

